function ItemSearch(search_terms)
{
    // input element hold user-typed words to search for
    this._search_terms = search_terms;
}
 
ItemSearch.prototype =
{
    doSearch: function(offset) {
        var state = { search_terms : this._search_terms.val().trim() };
 
        if (typeof offset !== 'undefined') {
            state['offset'] = offset;
        }
 
        this.getResults(state);
    },
 
    getResults: function(state)
    {
        var offset = typeof state['offset'] === 'undefined' ? '' : state['offset'];
 
        $.ajax({
            url: '/site/search/' + offset,
            data: state,
            type: 'POST',
            dataType: 'html',
            beforeSend: this.beforeGetResults,
            success: this.onGetResults,
            error: this.onGetResultsError
        }) ;
    },
 
    beforeGetResults: function()
    {
        $('#search_results').addClass('ajax_loader');
    },
 
    onGetResults: function(html)
    {
        $('#search_results').removeClass('ajax_loader');
        $('#search_results').html(html);
 
        $('html, body').animate({
            scrollTop: $('#search_results').offset().top
        }, 1000);
    },
 
    onGetResultsError: function(a, b, c)
    { 
        $('#search_results').removeClass('ajax_loader');
        alert(c);
    }
};