<?php if (strlen($search_terms) > 0) { ?>
    <p>
        You searched for:
        <em><?php echo htmlspecialchars($search_terms); ?></em>
        (<?php echo $pagination->total_rows; ?> found<?php if ($pagination->total_rows > 0) { ?>.
        Displaying <?php echo $offset+1; ?>
        -
        <?php echo $offset + $items->result_count(); ?><?php } ?>)
    </p>
<?php } ?>
 
<?php if ($items->result_count() > 0) { ?>
    <div class="pagination">
        <form class="search_form" action="/site/search" method="POST">
            <input type="hidden"
                   name="search_terms"
                   value="<?php echo htmlspecialchars($search_terms); ?/>" />
            <?php echo $pagination->create_links(); ?>
        </form>
    </div>
    <ul class="item_list">
        <?php foreach ($items as $item) { ?>
            <li>
                <a href="site/view/<?php echo $item->id; ?>">
                    <?php echo htmlspecialchars($item->name); ?>
                </a>
            </li>
        <?php } ?>
    </ul>
    <div class="pagination">
        <form class="search_form" action="/site/search" method="POST">
            <input type="hidden"
                   name="search_terms"
                   value="<?php echo htmlspecialchars($search_terms); ?>" />
            <?php echo $pagination->create_links(); ?>
        </form>
    </div>
<?php } else { ?>
    <div class="item_list_empty">
        No items found matching your search terms.
    </div>
<?php } ?>
 
<script src="http://code.jquery.com/jquery-1.11.2.min.js"></script>
<?php if ($is_ajax_request) { ?>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/ItemSearch.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/search_results_ajax.js"></script>
<?php } else { ?>
    <script type="text/javascript" src="<?php echo base_url();?>assets/js/search_results.js"></script>
<?php } ?>