<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
    ?>
<div class="content-wrapper">
    <section class="content-header">
        <?php echo $pagetitle; ?>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <div class="col-sm-10">
                            <h3 class="box-title">Información Expediente</h3>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row panel-group">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading" data-toggle="collapse" href="#collapse1">
                                        <h3 class="panel-title">Información general</h3>
                                    </div>
                                    <div id="collapse1" class="panel-collapse collapse">
                                        <table class="table table-striped table-hover">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo lang('expedientes_codigo'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->codigo, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_entrada'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->fecha_ingreso), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_meu'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->codigo_meu, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_meu'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->daj_fecha_meu), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_proyecto'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['proyecto']) ? $descripcion['proyecto'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_tramo'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['tramo']) ? $descripcion['tramo'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_subtramo'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->subtramo, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_franja'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->franja_dominio, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_progresiva_inicio'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->progresiva_inicial, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_progresiva_fin'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->progresiva_final, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_aplica_carpeta'); ?></th>
                                                    <td><?php echo htmlspecialchars(empty($expediente->desafectado) ? $expediente->desafectado : 'Pendiente', ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_notificacion'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->notificacion, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_departamento'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['departamento']) ? $descripcion['departamento'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_distrito'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['distrito']) ? $descripcion['distrito'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_lugar'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->lugar, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_tipo_afectacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['afeccion']) ? $descripcion['afeccion'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_condicion_dominio'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($descripcion['dominio']) ? $descripcion['dominio'] : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_nombre_y_apellido'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->nombre_completo, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_afectacion_cedula_afectado'); ?></th>
                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->cedula_identidad), ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_afectacion_fecha_nac_afectado'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->fecha_nacimiento), ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_telefono'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->telefono, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_cta_cte_catastral'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->cta_cte_catastral, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_padron'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->padron, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_finca'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->finca, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_ubi_dao_daj_matricula'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->matricula, ENT_QUOTES, 'UTF-8'); ?></
                                                </tr>
                                                
                                            </tbody>
                                        </table>
                                        <div class="row panel-group">
                                            <div class="col-md-12">
                                                <div class="col-sm-3">
                                                    <div class="panel panel-default">
                                                        <div class="panel-heading">
                                                            <h3 class="panel-title">Coordenadas UTM</h3>
                                                        </div>
                                                        <div id="collapsey" class="panel-collapse">
                                                            <table class="table table-striped table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th><?php echo lang('expedientes_coordenada_e'); ?></th>
                                                                        <th><?php echo lang('expedientes_coordenada_n'); ?></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php if(isset($expediente->ubi_coordenada_e)) : ?>
                                                                    <tr>
                                                                        <td>
                                                                            <?php echo htmlspecialchars(str_replace(".",",",$expediente->ubi_coordenada_e), ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo htmlspecialchars(str_replace(".",",",$expediente->ubi_coordenada_n), ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                    </tr>
                                                                    <?php else : ?>
                                                                    <tr>
                                                                        <td>No se ingresaron coordenadas.</td>
                                                                    </tr>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-3">
                                                    <div class="panel panel-default">
                                                        <div class="panel-heading">
                                                            <h3 class="panel-title">Coordenadas de la afectación</h3>
                                                        </div>
                                                        <div id="collapsey" class="panel-collapse">
                                                            <table class="table table-striped table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Coordenada x</th>
                                                                        <th>Coordenada y</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php if(isset($coordenadas)) : ?>
                                                                    <?php foreach ($coordenadas as $coor) : ?>
                                                                    <tr>
                                                                        <td>
                                                                            <?php echo htmlspecialchars($coor['coordenada_e'], ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo htmlspecialchars($coor['coordenada_n'], ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                    </tr>
                                                                    <?php endforeach; ?>
                                                                    <?php else : ?>
                                                                    <tr>
                                                                        <td>No se ingresaron coordenadas.</td>
                                                                    </tr>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row panel-group">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading" data-toggle="collapse" href="#collapse2">
                                        <h3 class="panel-title">Información UBI</h3>
                                    </div>
                                    <div id="collapse2" class="panel-collapse collapse">
                                        <table class="table table-striped table-hover">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_entrada'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->ubi_fecha_entrada), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_superficie_afectada'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($expediente->ubi_superficie_afectacion) ? str_replace(".",",", (float)$expediente->ubi_superficie_afectacion) : null, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_superficie_titulo'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($expediente->ubi_superficie_titulo) ? str_replace(".",",", (float)$expediente->ubi_superficie_titulo) : null, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_porcentaje_afectacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($expediente->ubi_porcentaje_afectacion) ? (float)$expediente->ubi_porcentaje_afectacion : null, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_supervisor_asignado'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->ubi_supervisor, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_revision'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->ubi_fecha_revision), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_aprobacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->ubi_fecha_aprobacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                            </tbody>
                                        </table>
                                        <div class="row panel-group">
                                            <div class="col-md-12">
                                                <div class="col-sm-3">
                                                    <div class="panel panel-default">
                                                        <div class="panel-heading">
                                                            <h3 class="panel-title">Coordenadas de la afectación</h3>
                                                        </div>
                                                        <div id="collapsey" class="panel-collapse">
                                                            <table class="table table-striped table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Coordenada x</th>
                                                                        <th>Coordenada y</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php if(isset($coordenadas)) : ?>
                                                                    <?php foreach ($coordenadas as $coor) : ?>
                                                                    <tr>
                                                                        <td>
                                                                            <?php echo htmlspecialchars($coor['coordenada_e'], ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                        <td>
                                                                            <?php echo htmlspecialchars($coor['coordenada_n'], ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                    </tr>
                                                                    <?php endforeach; ?>
                                                                    <?php else : ?>
                                                                    <tr>
                                                                        <td>No se ingresaron coordenadas.</td>
                                                                    </tr>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-sm-9">
                                                    <div class="panel panel-default">
                                                        <div class="panel-heading">
                                                            <h3 class="panel-title">Linderos</h3>
                                                        </div>
                                                        <div id="collapsey" class="panel-collapse">
                                                            <table class="table table-striped table-hover">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Lindero</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php if(isset($coordenadas)) : ?>
                                                                    <?php foreach ($coordenadas as $coor) : ?>
                                                                    <tr>
                                                                        <td>
                                                                            <?php echo htmlspecialchars(empty($coor['lindero']) ? '-' : $coor['lindero'], ENT_QUOTES, 'UTF-8'); ?>
                                                                        </td>
                                                                    </tr>
                                                                    <?php endforeach; ?>
                                                                    <?php else : ?>
                                                                    <tr>
                                                                        <td>No se ingresaron coordenadas.</td>
                                                                    </tr>
                                                                    <?php endif; ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if ( ! $oculta_dao) : ?>
                        <div class="row panel-group">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading" data-toggle="collapse" href="#collapse3">
                                        <h3 class="panel-title">Información DAO</h3>
                                    </div>
                                    <div id="collapse3" class="panel-collapse collapse">
                                        <table class="table table-striped table-hover">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_ingreso'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_ingreso_verificacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th>
                                                        <div class="row panel-group">
                                                            <div class="col-md-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">Avalúo para porcentaje afectado del terreno</h3>
                                                                    </div>
                                                                    <div id="collapsey" class="panel-collapse">
                                                                        <table class="table table-striped table-hover">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_terreno'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_terreno), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_gastos_transferencia'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_gastos_transferencia), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_mejoras_edilicias'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_mejoras_edilicias), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_mejoras_agroforestales'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_mejoras_agroforestales), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_total_mejoras'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_total_mejoras), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_total_notificacion'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_total_notificacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </th>
                                                    <td>
                                                        <div class="row panel-group">
                                                            <div class="col-md-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">Avalúo por el total del terreno</h3>
                                                                    </div>
                                                                    <div id="collapsex" class="panel-collapse">
                                                                        <table class="table table-striped table-hover">
                                                                            <tbody>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_terreno'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_terreno2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_gastos_transferencia'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_gastos_transferencia2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_mejoras_edilicias'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_mejoras_edilicias2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_mejoras_agroforestales'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_mejoras_agroforestales2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_total_mejoras'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_total_mejoras2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                                <tr>
                                                                                    <th><?php echo lang('expedientes_valor_total_notificacion'); ?></th>
                                                                                    <td><?php echo htmlspecialchars(formatear_moneda($expediente->dao_total_notificacion2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                                                </tr>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_supervisor_asignado'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->dao_supervisor, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_revision'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_fecha_verificacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_aprobacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_fecha_aprobacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_recepcion_notificacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_fecha_recepcion_notificacion_avaluo), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_eleccion_afectado'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->dao_eleccion_escogida, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_notificacion_avaluo'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_notificacion2), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_opcion_escogida'); ?></th>
                                                    <td><?php echo htmlspecialchars(isset($expediente->dao_indemnizacion_escogida) ? $expediente->dao_indemnizacion_escogida : '', ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_firma_conformidad'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->dao_firmado_conformidad), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_valor_total_conformidad'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->dao_total_conformidad, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_aplica_conformidad'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->dao_aplica_conformidad, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="row panel-group">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading" data-toggle="collapse" href="#collapse4">
                                        <h3 class="panel-title">Información DAJ</h3>
                                    </div>
                                    <div id="collapse4" class="panel-collapse collapse">
                                        <table class="table table-striped table-hover">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_ingreso'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->daj_fecha_entrada), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_documentacion_adicionales'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_documentos_adicionales, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_supervisor_asignado'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_supervisor, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_revision'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->daj_fecha_revision), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_aprobacion'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->daj_fecha_aprobacion), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_nro_dictamen'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_nro_dictamen, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_dictamen'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_dictamen, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_numero_resolucion'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_nro_resolucion, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_resolucion'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_resolucion, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_notificacion_resolucion'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_notificacion_resolucion, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_codigo_cexter'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_codigo_cexter, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_nro_decreto'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_nro_decreto, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_decreto'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_decreto, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_notificacion_decreto'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_notificacion_decreto, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_nro_dictamen_PGR'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_nro_dictamen_pgr, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_nro_nota_PGR'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_nro_nota_pgr, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_entrega_PGR'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->daj_fecha_entrega_a_pgr, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row panel-group">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading" data-toggle="collapse" href="#collapse5">
                                        <h3 class="panel-title">Información financiera</h3>
                                    </div>
                                    <div id="collapse5" class="panel-collapse collapse">
                                        <table class="table table-striped table-hover">
                                            <tbody>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_ini_tramite_pago'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->seg_fecha_inicio_tramite), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_certificado_pago'); ?></th>
                                                    <td><?php echo htmlspecialchars($expediente->seg_certificado_pago, ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <tr>
                                                    <th><?php echo lang('expedientes_fecha_pago'); ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($expediente->seg_fecha_pagado), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group">
                            <div 
                                class="col-md-offset-1 col-md-10" align="center">
                                <div class="btn-group">
                                    <?php echo anchor('expedientes/expedientes/', 'ATRAS', array('class' => 'btn btn-default ')); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Archivos del expediente</h3>
                    </div>
                    <div class="box-body">
                        <!-- /.box-header -->
                        <div class="col-sm-6">
                            <div class="box box-option">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Expediente PDF</h3>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <?php
                                        $i = 0;
                                        if (isset($archivos) && !empty($archivos)) : ?>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Archivo</th>
                                                <th>Fecha guardado</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($archivos as $arc) : 
                                                $i = $i + 1; ?>
                                            <tr>
                                                <th scope="row"><?php echo $i; ?></th>
                                                <?php if (strpos($arc['archivo'], 'pdf') == true or strpos($arc['archivo'], 'PDF') == true) :  ?>
                                                <td><?php echo anchor('expedientes/expedientes/ver_archivo/'.$arc['id'], htmlspecialchars($arc['archivo'], ENT_QUOTES, 'UTF-8'), array('target' => "_blank", 'style' => "color:#4287f5;")); ?></td>
                                                <?php else : ?>
                                                <td><?php echo htmlspecialchars($arc['archivo'], ENT_QUOTES, 'UTF-8'); ?></td>
                                                <?php endif; ?>
                                                <td><?php echo htmlspecialchars(formato_fecha_hora($arc['fecha_insercion']), ENT_QUOTES, 'UTF-8'); ?></td>
                                                <td>
                                                    <?php 
                                                        echo anchor('expedientes/expedientes/download_expe/'.$arc['id'], 'Descargar archivo'); 
                                                        ?>
                                                </td>
                                            </tr>
                                            <?php endforeach;?>
                                        </tbody>
                                    </table>
                                    <?php else : ?>
                                    <p>No se encontraron archivos</p>
                                    <?php endif; ?>
                                </div>
                                <!-- /.box-body -->
                            </div>
                            <!-- Crear Formulario -->
                            <!-- Sección botones -->
                        </div>
                        <div class="col-sm-6">
                            <div class="box box-option">
                                <div class="box-header with-border">
                                    <h3 class="box-title">Otros documentos</h3>
                                </div>
                                <!-- /.box-header -->
                                <div class="box-body">
                                    <?php
                                        $i = 0;
                                        if (isset($otros) && !empty($otros)) : ?>
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>Archivo</th>
                                                <th>Fecha guardado</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($otros as $arc) : 
                                                $i = $i + 1; ?>
                                            <tr>
                                                <th scope="row"><?php echo $i; ?></th>
                                                <?php if (strpos($arc['archivo'], 'pdf') == true) :  ?>
                                                <td><?php echo anchor('expedientes/expedientes/ver_archivo/'.$arc['id'], htmlspecialchars($arc['archivo'], ENT_QUOTES, 'UTF-8'), array('target' => "_blank")); ?></td>
                                                <?php else : ?>
                                                <td><?php echo htmlspecialchars($arc['archivo'], ENT_QUOTES, 'UTF-8'); ?></td>
                                                <?php endif; ?>
                                                <td><?php echo htmlspecialchars(formato_fecha_hora($arc['fecha_insercion']), ENT_QUOTES, 'UTF-8'); ?></td>
                                                <td>
                                                    <?php 
                                                        echo anchor('expedientes/expedientes/download_expe/'.$arc['id'], 'Descargar archivo'); 
                                                        ?>
                                                </td>
                                            </tr>
                                            <?php endforeach;?>
                                        </tbody>
                                    </table>
                                    <?php else : ?>
                                    <p>No se encontraron archivos</p>
                                    <?php endif; ?>
                                </div>
                                <!-- /.box-body -->
                            </div>
                            <!-- Crear Formulario -->
                            <!-- Sección botones -->
                        </div>
                        <!-- /.box-body -->
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>