<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vistas_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * vistas
	 *
	 * @return object
	 * @author Raquel Romero and Tanya Paredes
	 **/
	public function vistas()
	{
		$this->trigger_events('vistas');

		// run each where that was passed
		
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['v_vistas']);
		
		return $this;
	}

	/**
	 * vistas
	 *
	 * @return object
	 * @author Raquel Romero and Tanya Paredes
	 **/
	public function vista($id = NULL)
	{
		$this->trigger_events('vistas');

		if (isset($id))
		{
			$this->where($this->tables['v_vistas'].'.id', $id);
		}

		$this->limit(1);
		$this->order_by('id', 'nombre_vista');

		return $this->vistas();
	}

	/* Trae de la tabla view v_tipovista el "concepto y nombre" */
	public function get_vista ($concepto = ''){
		$nombre = $this->db->get_where($this->tables['v_tipovista'], array('concepto' => $concepto));
		return $c_tipo;
	}

	public function get_vista2 ($concepto = ''){
		$nombre = $this->db->get_where($this->tables['v_modulos'], array('concepto' => $concepto));
		return $c_modulo;
	}

	/**
	 * create_vista
	 *
	 * @author Raquel Romero and Tanya Paredes
	*/
	
	public function create_vista($data, $additional_data = array())
	{

		// Verifica si ya se encuentra insertado el nombre de la vista.
		$existing_vistas = $this->db->get_where($this->tables['vistas'], array('nombre_vista' => $data['nombre_vista']))->num_rows();

		
		if($existing_vistas !== 0)
		{
			$this->ion_auth->set_error('vista_already_exists');
			return FALSE;
		}
		
		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['vistas'], $additional_data), $data);

		$this->trigger_events('extra_vista_set');

		// insertar nueva vistas
		$this->db->insert($this->tables['vistas'], $data);
		$vista_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('vista_creation_successful');
		// return the brand new vista id
		return $vista_id;
	}	

	  
	public function update_vista($vid,$data){
		
		// Verifica si ya se encuentra insertado el nombre de la vista.
		//$existing_vistas = $this->db->get_where($this->tables['vistas'], array('nombre_vista' => $data['nombre_vista']))->num_rows();
		$existing_vistas = $this->db->get_where($this->tables['vistas'], $data)->num_rows();

		if($existing_vistas !== 0)
		{
			$this->ion_auth->set_error('vista_already_exists');
			return FALSE;
		}

		$this->db->update($this->tables['vistas'], $data, array('id' => $vid));

		$this->set_message('vistas_update_successful');

		return TRUE;
	}

	public function v_tipovista()
	{
		$this->response = $this->db->get($this->tables['v_tipovista']);

		return $this;
	}

	public function v_modulos()
	{
		$this->response = $this->db->get($this->tables['v_modulos']);

		return $this;
	}

	public function delete_vista($vid){

		$this->db->delete($this->tables['vistas'], array('id' => $vid));

		return TRUE;

	}

}