<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Vistas extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('vistas/vistas_model');
        $this->lang->load('vistas/vistas');

        /* Title Page :: Common */
        $this->page_title->push(lang('menu_vistas'));
        $this->data['pagetitle'] = $this->page_title->show();
        
        $_SESSION['id_modulo'] = 'VISTAS';


        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_vistas'), 'vistas/vistas');
    }
    
    
	public function index()
	{
      

       if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Llama al modelo de la vista */
            $this->data['vistas'] = $this->vistas_model->vistas()->result();

            /* Load Template */
            $this->template->admin_render('vistas/index', $this->data);
        }
    }


    public function create()
    {

        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_vistas'), 'vistas/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Valida cada campo del formulario crear */
        /* Validación form input */
        $this->form_validation->set_rules('nombre_vista', 'lang:create_vista_validation_name_label', 'required|alpha_dash');

        /* Validación form input */
        $this->form_validation->set_rules('url', 'lang:create_url_validation_name_label', 'required');

              
        if ($this->form_validation->run() == TRUE)
        {
            /* Pasa los datos por post */
            $data['nombre_vista']     = $this->input->post('nombre_vista');
            $data['url']              = $this->input->post('url');
            $data['c_tipo']           = $this->input->post('concepto_tipo');
            $data['c_modulo']         = $this->input->post('concepto_modulo'); 

            $new_vista_id             = $this->vistas_model->create_vista($data);

            if ($new_vista_id)
            {
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                redirect('vistas/vistas', 'refresh');
            }else{
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('vistas/vistas/create');

            }

            
        }
        else
        {
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
    
            $this->data['nombre_vista'] = array(
                'name'  => 'nombre_vista',
                'id'    => 'nombre_vista',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('nombre_vista')
            );
            $this->data['url'] = array(
                'name'  => 'url',
                'id'    => 'url',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('url')
            );
                   

            $this->data['ddl_tipovista'] = $this->vistas_model->v_tipovista()->result();
            $this->data['ddl_modulos']   = $this->vistas_model->v_modulos()->result();

            /* Load Template */
            $this->template->admin_render('vistas/create', $this->data);
        }

    }


    public function edit($id)
    {
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_vistas_edit'), 'vistas/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables */

        $vistas  = $this->vistas_model->vista($id)->row();

         /* Validación form input */
        $this->form_validation->set_rules('nombre_vista', 'lang:create_vista_validation_name_label', 'required|alpha_dash');

         /* Validación form input */
        $this->form_validation->set_rules('url', 'lang:create_url_validation_name_label', 'required');

    
        if (isset($_POST) && ! empty($_POST))
        {
            if ($this->form_validation->run() == TRUE)
            {
                $data['nombre_vista']     = $this->input->post('nombre_vista');
                $data['url']              = $this->input->post('url');
                $data['c_tipo']           = $this->input->post('concepto_tipo');
                $data['c_modulo']         = $this->input->post('concepto_modulo');

                $vista_update = $this->vistas_model->update_vista($id, $data);

                if ($vista_update)
                {
                    $this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
                    redirect('vistas/vistas', 'refresh');
                }
                else
                {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                }
            }
        }

        /* Load Template */     
        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        $this->data['vistas']   = $vistas;
    
            $this->data['nombre_vista'] = array(
                'name'  => 'nombre_vista',
                'id'    => 'nombre_vista',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('nombre_vista', $vistas->nombre_vista)
            );

            $this->data['url'] = array(
                'name'  => 'url',
                'id'    => 'url',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('url', $vistas->url)
            );

            $this->data['tipo'] = array(
                'value' => $this->form_validation->set_value('tipo', $vistas->c_tipo)
            );

            $this->data['modulo'] = array(
                'value' => $this->form_validation->set_value('modulo', $vistas->c_modulo)
            );

        $this->data['ddl_tipovista'] = $this->vistas_model->v_tipovista()->result();
        $this->data['ddl_modulos']   = $this->vistas_model->v_modulos()->result();
        $this->template->admin_render('vistas/edit', $this->data);
    }

    public function delete($id){

        $vista_delete = $this->vistas_model->delete_vista($id);

        if ($vista_delete)
        {
            $this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
            redirect('vistas/vistas');
        }
        else
        {
            $this->session->set_flashdata('message', $this->ion_auth->errors());
        }
    
    }

}