<?php  if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}
/**
* Name:  Ion Auth
*
* Version: 2.5.2
*
* Author: Ben Edmunds
*         ben.edmunds@gmail.com
*         @benedmunds
*
* Added Awesomeness: Phil Sturgeon
*
* Location: http://github.com/benedmunds/CodeIgniter-Ion-Auth
*
* Created:  10.01.2009
*
* Description:  Modified auth system based on redux_auth with extensive customization.  This is basically what Redux Auth 2 should be.
* Original Author name has been kept but that does not mean that the method has not been modified.
*
* Requirements: PHP5 or above
*
*/

/*
| -------------------------------------------------------------------------
| Tables.
| -------------------------------------------------------------------------
| Database table names.
*/
$config['tables']['users']                          = 'users';
$config['tables']['groups']                         = 'groups';
$config['tables']['auditoria']                      = 'auditor.auditoria';
$config['tables']['users_groups']                   = 'users_groups';
$config['tables']['login_attempts']                 = 'login_attempts';
$config['tables']['expedientes']                    = 'ide.expedientes';
$config['tables']['v_expedientes']                  = 'ide.v_expedientes';
$config['tables']['terrenos']                       = 'ide.terrenos';
$config['tables']['tipificacion']                   = 'v_tipificacion';
$config['tables']['tipo_afectacion']                = 'tipos_afeccion';
$config['tables']['v_tipos_afectacion_todos']       = 'v_tipos_afectacion_todos';
$config['tables']['v_tipos_ocupacion_todos']        = 'v_tipos_ocupacion_todos';
$config['tables']['tipo_ocupacion']                 = 'tipos_ocupacion';
$config['tables']['tipos_moneda']                   = 'tipos_moneda';
$config['tables']['proyectos']                      = 'proyectos';
$config['tables']['tramos']                         = 'public.tramos';
$config['tables']['historial_meu']                  = 'ide.historial_meu';
$config['tables']['historial_fecha_ingreso']        = 'ide.historial_fecha_ingreso';
$config['tables']['historial_notificacion']         = 'ide.historial_notificacion';
$config['tables']['coordenadas']                    = 'ide.coordenadas';
$config['tables']['documentos_sge']                 = 'ide.documentos_sge';
$config['tables']['tramos_ide']                     = 'ide.tramos_ide';
$config['tables']['exp_observ']                     = 'ide.expedientes_observaciones';
$config['tables']['tipos_documentos']               = 'ide.tipos_documentos';
$config['tables']['documentos']                     = 'ide.documentos_presentados';
$config['tables']['franja_dominio']                 = 'ide.franja_dominio';
$config['tables']['franja_dominio_pol']             = 'ide.franja_dominio_pol';
$config['tables']['franja_construccion']            = 'ide.franja_construccion';
$config['tables']['coordafecta']                    = 'ide.coordafecta';
$config['tables']['afectaciones']                   = 'ide.afectaciones';
$config['tables']['afectaciones_ci']                = 'ide.afectaciones_ci';
$config['tables']['afectaciones_gen']               = 'ide.afectaciones_gen';
$config['tables']['terrenos_ci']                    = 'ide.terrenos_ci';
$config['tables']['terrenos_gen']                   = 'ide.terrenos_gen';
$config['tables']['mejoras']                        = 'ide.mejoras';
$config['tables']['mejoras_gen']                    = 'ide.mejoras_gen';
$config['tables']['mejoras_ci']                     = 'ide.mejoras_ci';
$config['tables']['mejoras_afectadas']              = 'ide.mejoras_afectadas';
$config['tables']['mejoras_afectadas_ci']           = 'ide.mejoras_afectadas_ci';
$config['tables']['mejoras_afectadas_gen']          = 'ide.mejoras_afectadas_gen';
$config['tables']['eje']                            = 'ide.eje';
$config['tables']['progresivas']                    = 'ide.progresivas';
$config['tables']['ide_tramos']                     = 'ide.tramos';
$config['tables']['resto_snc']                      = 'ide.resto_snc';
$config['tables']['v_reportemapas_n_hojas']         = 'ide.v_reportemapas_n_hojas';



// JMAP
$config['tables']['geocolonias']        = 'public.geocolonias';
$config['tables']['reg01']    	        = 'reg01';
$config['tables']['vistas']			    = 'vistas';	
$config['tables']['distritos']    	    = 'indert.distritos';
$config['tables']['colonias']    	    = 'bya.colonias';
$config['tables']['v_colonias_index']   = 'bya.v_colonias_index';
$config['tables']['v_municipios_index'] = 'municipal.v_municipios_index';
$config['tables']['menus']			    = 'menus';
$config['tables']['v_bb_parcelas']	    = 'i3geo.v_bb_parcelas';
$config['tables']['parcelas']		    = 'i3geo.parcelas';
$config['tables']['lotes']              = 'municipal.lotes';
$config['tables']['v_lotes_index']      = 'municipal.v_lotes_index';
$config['tables']['v_lotes_datos']      = 'municipal.v_lotes_datos';
$config['tables']['municipios']		    = 'municipal.municipios';
$config['tables']['departamentos']	    = 'municipal.departamentos';
$config['tables']['provincias']         = 'municipal.provincias';
$config['tables']['lotes_uso86']        = 'i3geo.lotes_uso86';
$config['tables']['exp']			    = 'bya.exp';
$config['tables']['conceptos']	        = 'conceptos';
$config['tables']['t_epsgs']            = 'bya.t_epsgs';
$config['tables']['radios_urbanos']     = 'municipal.radios_urbanos';
$config['tables']['distritos']          = 'municipal.distritos';
$config['tables']['distritos_catastrales'] = 'municipal.distritos_catastrales';
$config['tables']['zonas_homogeneas']   = 'municipal.zonas_homogeneas';
$config['tables']['manzanas']           = 'municipal.manzanas';
$config['tables']['vias']               = 'municipal.vias';
$config['tables']['i_epsg']               = 'municipal.i_epsg';
$config['tables']['v_json_lotes']         = 'municipal.v_json_lotes';
$config['tables']['v_lotes_factores']     = 'municipal.v_lotes_factores';
$config['tables']['lotes_factores']       = 'municipal.lotes_factores';


$config['tables']['v_resumen_uso_actual'] = 'bya.v_resumen_uso_actual';
$config['tables']['v_resumen_uso_alter']  = 'bya.v_resumen_uso_alter';
$config['tables']['v_resumen_uso86']      = 'bya.v_resumen_uso86';


$config['tables']['v_dpto_distrito_colonia']		= 'vista_dpto_distrito_colonia';
$config['tables']['v_dpto_distrito_colonia_pk']		= 'vista_dpto_distrito_colonia_pk';   
$config['tables']['v_dpto_distrito_colonia_rp']		= 'vista_dpto_distrito_colonia_rp';


$config['tables']['capacidad']	 	 = 'bya.capacidad';
$config['tables']['fincas']	 	     = 'bya.fincas';
$config['tables']['parcelas']	 	 = 'bya.parcelas';
$config['tables']['taxonomia']	 	 = 'bya.taxonomia';
$config['tables']['uso86']	 	     = 'bya.uso86';
$config['tables']['uso_actual']	 	 = 'bya.uso_actual';
$config['tables']['uso_alternativo'] = 'bya.uso_alternativo';
$config['tables']['usos']	 	     = 'bya.usos';
$config['tables']['aldeas']	 	     = 'bya.aldeas';
$config['tables']['bloques']         = 'bya.bloques';


$config['tables']['bloques_uso_alternativo']  = 'bya.bloques_uso_alternativo';
$config['tables']['aldeas_uso_alternativo']   = 'bya.aldeas_uso_alternativo';
$config['tables']['parcelas_uso_alternativo'] = 'bya.parcelas_uso_alternativo';
$config['tables']['bloques_uso_actual']       = 'bya.bloques_uso_actual';
$config['tables']['aldeas_uso_actual']        = 'bya.aldeas_uso_actual';
$config['tables']['parcelas_uso_actual']      = 'bya.parcelas_uso_actual';
$config['tables']['bloques_uso86']            = 'bya.bloques_uso86';
$config['tables']['aldeas_uso86']             = 'bya.aldeas_uso86';
$config['tables']['parcelas_uso86']           = 'bya.parcelas_uso86';
//FIN JMAP




$config['tables']['geocolonias']                    = 'indert.geocolonia';
$config['tables']['in_temp']                        = 'indert.in_temp';
$config['tables']['v_in_temp']                      = 'indert.v_in_temp';
$config['tables']['in_parc']                        = 'indert.in_parc';
//$config['tables']['departamentos']                  = 'indert.dpto';
$config['tables']['vistas']                         = 'vistas';
$config['tables']['v_vistas']                       = 'v_vistas';
$config['tables']['distritos']                      = 'indert.distritos';
$config['tables']['colonias']                       = 'indert.colonias';
$config['tables']['fincas']                         = 'indert.in_fincas_ajust';
$config['tables']['v_colonias']                     = 'indert.v_colonias';
$config['tables']['menus']                          = 'menus';
$config['tables']['v_bb_parcelas']                  = 'i3geo.v_bb_parcelas';
$config['tables']['in_planopericia1']               = 'indert.in_planopericia1';
$config['tables']['in_planopericia2']               = 'indert.in_planopericia2';
$config['tables']['v_in_planopericia1']             = 'indert.v_in_planopericia1';
$config['tables']['v_in_planopericia1_cnt']         = 'indert.v_in_planopericia1_cnt';
$config['tables']['v_in_planopericia2']             = 'indert.v_in_planopericia2';



$config['tables']['v_tipovista']                    = 'public.v_tipovista';
$config['tables']['conceptos']                      = 'conceptos';
$config['tables']['v_modulos']                      = 'public.v_modulos';
$config['tables']['v_habilitado']                   = 'public.v_habilitado';
$config['tables']['user_menus_privs']               = 'public.user_menus_privs';



$config['tables']['equipos']                        = 'public.equipos';
$config['tables']['menus_jerarquia']                = 'v_menus_jerarquia';
$config['tables']['asignacionlotes']                = 'asignacionlotes';
$config['tables']['monitoreo_verificador']          = 'v_monitoreo_verificador';
$config['tables']['monitoreo_supervisor']           = 'v_monitoreo_control';
$config['tables']['monitoreo']                      = 'monitoreo';
$config['tables']['v_dpto_distrito_colonia']        = 'vista_dpto_distrito_colonia';
$config['tables']['panel1A']                        = 'public.panel1A';
$config['tables']['v_pericia']                      = 'indert.v_pericias2';
$config['tables']['columnas_tabla']                 = 'information_schema.columns';
$config['tables']['v_empate_1']                     = 'v_empate_1';
$config['tables']['v_empate_2']                     = 'v_empate_2';
$config['tables']['v_empate_3']                     = 'v_empate_3';


/***  MOPC  ***/
//$config['tables']['departamentos']                  = 'ide.dpto';
$config['tables']['distritos']                      = 'ide.distritos';
$config['tables']['exp']                            = 'ide.exp';
$config['tables']['v_exp01']                        = 'ide.v_exp01';
$config['tables']['v_lic_exp_transac']              = 'ide.v_lic_exp_transac';
$config['tables']['consultores']                    = 'ide.consultores';
$config['tables']['dependencias']                   = 'ide.dependencias';
$config['tables']['declaraciones']                  = 'ide.declaraciones';
$config['tables']['resoluciones']                   = 'ide.resoluciones';
$config['tables']['imagenes']                       = 'ide.imagenes';
$config['tables']['dic1_datos']                     = 'ide.dic1_datos';
$config['tables']['dic2_mapas_img']                 = 'ide.dic2_mapas_img';
$config['tables']['dic3_verificacion']              = 'ide.dic3_verificacion';
$config['tables']['dic4_informe']                   = 'ide.dic4_informe';
$config['tables']['MOPC_POLIGONO']                  = 'MOPC_ide.MOPC_poligono';
$config['tables']['MOPC_UACTUAL']                   = 'MOPC_ide.MOPC_uactual';
$config['tables']['MOPC_UALTER']                    = 'MOPC_ide.MOPC_ualter';
$config['tables']['MOPC_U86']                       = 'MOPC_ide.MOPC_u86';
$config['tables']['MOPC_U04']                       = 'MOPC_ide.MOPC_u04';
$config['tables']['MOPC_TSUELO']                    = 'MOPC_ide.MOPC_tsuelo';
$config['tables']['MOPC_FINCAS']                    = 'MOPC_ide.MOPC_fincas';
$config['tables']['MOPC_CAP_SUELO']                 = 'MOPC_ide.MOPC_cap_suelo';
$config['tables']['MOPC_CLA_ECO']                   = 'MOPC_ide.MOPC_cla_eco';
$config['tables']['MOPC_COMP_DEF']                  = 'MOPC_ide.MOPC_comp_def';
$config['tables']['MOPC_DEF_BOS']                   = 'MOPC_ide.MOPC_def_bos';
$config['tables']['MOPC_PROP_CERT']                 = 'MOPC_ide.MOPC_prop_cert';
$config['tables']['i3geo_MOPC_poligono']            = 'i3geo.MOPC_poligono';
$config['tables']['i3geo_MOPC_uactual']             = 'i3geo.MOPC_uactual';
$config['tables']['i3geo_MOPC_ualter']              = 'i3geo.MOPC_ualter';


/****	Memos		****/
$config['tables']['profesionales']                 	= 'profesionales';
$config['tables']['categorias']                    	= 'categorias';
$config['tables']['memos']                    		= 'memos';
$config['tables']['memos_detalle']                  = 'memos_detalle';
/****	Fin - Memos	****/

//cuestionarios
$config['tables']['reg01']                          = 'reg01';
$config['tables']['reg02']                          = 'reg02';
$config['tables']['reg03']                          = 'reg03';
$config['tables']['reg04']                          = 'reg04';
$config['tables']['reg05']                          = 'reg05';
$config['tables']['reg06']                          = 'reg06';
$config['tables']['reg07']                          = 'reg07';
$config['tables']['reg08']                          = 'reg08';
$config['tables']['reg09']                          = 'reg09';
$config['tables']['reg10']                          = 'reg10';
$config['tables']['reg11']                          = 'reg11';
$config['tables']['reg12']                          = 'reg12';
$config['tables']['reg_fotos']                      = 'reg_fotos';
$config['tables']['reg_errores']                    = 'reg_errores';


/*
 | Users table column and Group table column you want to join WITH.
 |
 | Joins from users.id
 | Joins from groups.id
 */
$config['join']['users']  = 'user_id';
$config['join']['groups'] = 'group_id';

/*
 | -------------------------------------------------------------------------
 | Hash Method (sha1 or bcrypt)
 | -------------------------------------------------------------------------
 | Bcrypt is available in PHP 5.3+
 |
 | IMPORTANT: Based on the recommendation by many professionals, it is highly recommended to use
 | bcrypt instead of sha1.
 |
 | NOTE: If you use bcrypt you will need to increase your password column character limit to (80)
 |
 | Below there is "default_rounds" setting.  This defines how strong the encryption will be,
 | but remember the more rounds you set the longer it will take to hash (CPU usage) So adjust
 | this based on your server hardware.
 |
 | If you are using Bcrypt the Admin password field also needs to be changed in order to login as admin:
 | $2y$: $2y$08$200Z6ZZbp3RAEXoaWcMA6uJOFicwNZaqk4oDhqTUiFXFe63MG.Daa
 | $2a$: $2a$08$6TTcWD1CJ8pzDy.2U3mdi.tpl.nYOR1pwYXwblZdyQd9SL16B7Cqa
 |
 | Be careful how high you set max_rounds, I would do your own testing on how long it takes
 | to encrypt with x rounds.
 |
 | salt_prefix: Used for bcrypt. Versions of PHP before 5.3.7 only support "$2a$" as the salt prefix
 | Versions 5.3.7 or greater should use the default of "$2y$".
 */
$config['hash_method']    = 'bcrypt';   // sha1 or bcrypt, bcrypt is STRONGLY recommended
$config['default_rounds'] = 8;      // This does not apply if random_rounds is set to true
$config['random_rounds']  = false;
$config['min_rounds']     = 5;
$config['max_rounds']     = 9;
$config['salt_prefix']    = version_compare(PHP_VERSION, '5.3.7', '<') ? '$2a$' : '$2y$';

/*
 | -------------------------------------------------------------------------
 | Authentication options.
 | -------------------------------------------------------------------------
 | maximum_login_attempts: This maximum is not enforced by the library, but is
 | used by $this->ion_auth->is_max_login_attempts_exceeded().
 | The controller should check this function and act
 | appropriately. If this variable set to 0, there is no maximum.
 */
$config['site_title']                 = "Example.com";       // Site Title, example.com
$config['admin_email']                = "admin@example.com"; // Admin Email, admin@example.com
$config['default_group']              = 'members';           // Default group, use name
$config['admin_group']                = 'admin';             // Default administrators group, use name
$config['identity']                   = 'username';          // You can use any unique column in your table as identity column. The values in this column, alongside password, will be used for login purposes
$config['min_password_length']        = 8;                   // Minimum Required Length of Password
$config['max_password_length']        = 20;                  // Maximum Allowed Length of Password
$config['email_activation']           = false;               // Email Activation for registration
$config['manual_activation']          = false;               // Manual Activation for registration
$config['remember_users']             = true;                // Allow users to be remembered and enable auto-login
$config['user_expire']                = 86500;               // How long to remember the user (seconds). Set to zero for no expiration
$config['user_extend_on_login']       = false;               // Extend the users cookies every time they auto-login
$config['track_login_attempts']       = true;                // Track the number of failed login attempts for each user or ip.
$config['track_login_ip_address']     = true;                // Track login attempts by IP Address, if FALSE will track based on identity. (Default: TRUE)
$config['maximum_login_attempts']     = 3;                   // The maximum number of failed login attempts.
$config['lockout_time']               = 600;                 // The number of seconds to lockout an account due to exceeded attempts
$config['forgot_password_expiration'] = 0;                   // The number of milliseconds after which a forgot password request will expire. If set to 0, forgot password requests will not expire.

/*
 | -------------------------------------------------------------------------
 | Cookie options.
 | -------------------------------------------------------------------------
 | remember_cookie_name Default: remember_code
 | identity_cookie_name Default: identity
 */
$config['remember_cookie_name'] = 'remember_code';
$config['identity_cookie_name'] = 'identity';

/*
 | -------------------------------------------------------------------------
 | Email options.
 | -------------------------------------------------------------------------
 | email_config:
 | 	  'file' = Use the default CI config or use from a config file
 | 	  array  = Manually set your email config settings
 */
$config['use_ci_email'] = false; // Send Email using the builtin CI email class, if false it will return the code and the identity
$config['email_config'] = array(
    'mailtype' => 'html',
);

/*
 | -------------------------------------------------------------------------
 | Email templates.
 | -------------------------------------------------------------------------
 | Folder where email templates are stored.
 | Default: auth/
 */
$config['email_templates'] = 'auth/email/';

/*
 | -------------------------------------------------------------------------
 | Activate Account Email Template
 | -------------------------------------------------------------------------
 | Default: activate.tpl.php
 */
$config['email_activate'] = 'activate.tpl.php';

/*
 | -------------------------------------------------------------------------
 | Forgot Password Email Template
 | -------------------------------------------------------------------------
 | Default: forgot_password.tpl.php
 */
$config['email_forgot_password'] = 'forgot_password.tpl.php';

/*
 | -------------------------------------------------------------------------
 | Forgot Password Complete Email Template
 | -------------------------------------------------------------------------
 | Default: new_password.tpl.php
 */
$config['email_forgot_password_complete'] = 'new_password.tpl.php';

/*
 | -------------------------------------------------------------------------
 | Salt options
 | -------------------------------------------------------------------------
 | salt_length Default: 22
 |
 | store_salt: Should the salt be stored in the database?
 | This will change your password encryption algorithm,
 | default password, 'password', changes to
 | fbaa5e216d163a02ae630ab1a43372635dd374c0 with default salt.
 */
$config['salt_length'] = 22;
$config['store_salt']  = false;

/*
 | -------------------------------------------------------------------------
 | Message Delimiters.
 | -------------------------------------------------------------------------
 */
$config['delimiters_source']       = 'config';  // "config" = use the settings defined here, "form_validation" = use the settings defined in CI's form validation library
$config['message_start_delimiter'] = '<p>';     // Message start delimiter
$config['message_end_delimiter']   = '</p>';    // Message end delimiter
$config['error_start_delimiter']   = '<p>';     // Error message start delimiter
$config['error_end_delimiter']     = '</p>';    // Error message end delimiter

/* End of file ion_auth.php */
/* Location: ./application/config/ion_auth.php */
