<head> 
<style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <!-- Encabezado de la página -->
        <section class="content-header">
          
        </section>

        <!-- Contenido principal -->
        <section class="content">
            <div class="container mt-5">
                <!-- Título de la sección -->
                <h1 class="mb-4">Listado de Alertas</h1>
                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?> 
                <?php
                    } else {  
                ?>
                    <!-- Botón para crear nuevo Tipo Alerta -->
                    <?php echo anchor('tipo_alertnotific/create', '<i class="fa fa-plus"></i> Crear Tipo Alerta', array('class' => 'btn btn-block btn-primary btn-flat')); ?>
                <?php
                    } 
                ?>
                <!-- Contenedor de la tabla -->
                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>Código</th>
                                    <th>Mensaje</th>
                                    <th>Módulo</th>
                                    <th>Clase</th>
                                    <th>Tipo</th>
                                    <th>Tabla</th>
                                    <th>Campo</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($tipo_alertas as $row): ?>
                                <tr>
                                    <td>
                                        <?php 
                                            $user_id = $this->session->userdata('user_id');
                                            $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                            $id_cliente = $_SESSION['id_cliente'][0];
                                            if ($tipo_usuario == 'C') { 
                                        ?> 
                                            <a href="<?= site_url('tipo_alertnotific/edit/'.$row->codigo) ?>" class="btn btn-warning btn-sm">Ver</a>
                                            
                                        <?php
                                            } else {  
                                        ?>   
                                            <a href="<?= site_url('tipo_alertnotific/edit/'.$row->codigo) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp
                                            <a href="<?= site_url('tipo_alertnotific/delete/'.$row->codigo) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                            
                                        <?php
                                            } 
                                        ?>
                                    </td>
                                    <td><?= htmlspecialchars($row->codigo, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars(substr( $row->mensaje, 0, 15), ENT_QUOTES, 'UTF-8')  ?></td>
                                    <td><?= htmlspecialchars($row->modulo, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row->clase, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row->tipo, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row->tabla, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row->campo, ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row->estado, ENT_QUOTES, 'UTF-8') ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>

                        </table>
                    </div>
                </div>

                <!-- Paginación (si la tienes configurada) -->
                <div class="pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>
</html>
