<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px; /* Espacio entre los botones y los campos */
        }
        .btn-container .btn {
            margin-right: 10px; /* Espacio entre los botones */
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    
    <section class="content-header">
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('message')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('message'); ?>
            </div>
        <?php endif; ?>
    </section>

    <section class="content">
        <div class="container mt-5">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Crear Tipo Alerta</h4>
                </div>
                <div class="card-body">
                    <form action="<?= site_url('tipo_alertnotific/create') ?>" method="post">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="codigo">Código</label>
                            <input type="text" class="form-control" name="codigo" id="codigo" required>
                            <?= form_error('codigo', '<small class="text-danger">', '</small>') ?>
                        </div>
                        <div class="form-group col-md-8">
                            <label for="mensaje">Mensaje</label>
                            <input type="text" class="form-control" name="mensaje" id="mensaje" required>
                            <?= form_error('mensaje', '<small class="text-danger">', '</small>') ?>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="modulo">Módulo</label>
                            <input type="text" class="form-control" name="modulo" id="modulo" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="clase">Clase</label>
                            <input type="text" class="form-control" name="clase" id="clase" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="tipo">Tipo</label>
                            <input type="text" class="form-control" name="tipo" id="tipo">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="tabla">Tabla</label>
                            <input type="text" class="form-control" name="tabla" id="tabla" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="campo">Campo</label>
                            <input type="text" class="form-control" name="campo" id="campo">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="dias_alerta1">Días Alerta 1</label>
                            <input type="number" class="form-control" name="dias_alerta1" id="dias_alerta1" required>
                        </div>
                        <div class="form-group col-md-2">
                            <label for="dias_alerta2">Días Alerta 2</label>
                            <input type="number" class="form-control" name="dias_alerta2" id="dias_alerta2">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="dias_alerta3">Días Alerta 3</label>
                            <input type="number" class="form-control" name="dias_alerta3" id="dias_alerta3">
                        </div>
                    </div>

                    <div class="form-row">   
                        <div class="form-group col-md-2">
                            <label for="dias_alerta4">Días Alerta 4</label>
                            <input type="number" class="form-control" name="dias_alerta4" id="dias_alerta4">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="dias_alerta5">Días Alerta 5</label>
                            <input type="number" class="form-control" name="dias_alerta5" id="dias_alerta5">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="rgb1">RGB 1</label>
                            <input type="color" class="form-control" name="rgb1" id="rgb1" required>
                        </div>
                        <div class="form-group col-md-2">
                            <label for="rgb2">RGB 2</label>
                            <input type="color" class="form-control" name="rgb2" id="rgb2">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="rgb3">RGB 3</label>
                            <input type="color" class="form-control" name="rgb3" id="rgb3">
                        </div>
                        <div class="form-group col-md-2">
                            <label for="rgb4">RGB 4</label>
                            <input type="color" class="form-control" name="rgb4" id="rgb4">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label for="rgb5">RGB 5</label>
                            <input type="color" class="form-control" name="rgb5" id="rgb5">
                        </div>
                        <div class="form-group col-md-3">
                            <label for="estado">Estado</label>
                            <select name="estado" id="estado" class="form-control">
                                <option value="activo">Activo</option>
                                <option value="inactivo">Inactivo</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-12">
                            <div class="btn-container">
                                <button type="submit" class="btn btn-primary">Guardar</button>
                                <a href="<?= base_url('tipo_alertnotific/index') ?>" class="btn btn-warning">Cancelar</a>
                            </div>
                        </div>
                    </div>
                </form>
                    <br>
            </div>
    </section>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
