<?php
defined('BASEPATH') OR exit('No direct script access allowed');
?>
<!-- Dependencias para el datepicker (si las necesitas) -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/css/bootstrap-datepicker.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/js/bootstrap-datepicker.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.9.0/locales/bootstrap-datepicker.es.min.js"></script>

<div class="content-wrapper">
    <section class="content-header">
        <?php echo 'VER PROPONENTE'; ?>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                 <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo 'Visualizar Proponente'; ?></h3>
                        <?php echo $message;?> 
                    </div>
                    <div class="box-body">
                        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-edit_user')); ?>                                    
                        
                            <!-- ID Proponente (read-only) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_id_proponente', 'id_proponente', array('class' => 'col-sm-3 control-label', 'readonly')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($id_proponente); ?>
                                </div>
                            </div>
                            
                            <!-- Tipo de Persona (ahora input) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_tipo_persona', 'dp_tipo_persona', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php  
                                        // Se extrae el valor de la opción seleccionada
                                        $tipo_persona_val = isset($tipo_persona[$tipo_persona_sel]) ? $tipo_persona[$tipo_persona_sel] : '';
                                        echo form_input(array(
                                            'name'     => 'dp_tipo_persona',
                                            'id'       => 'dp_tipo_persona',
                                            'value'    => $tipo_persona_val,
                                            'class'    => 'form-control',
                                            'readonly' => 'readonly'
                                        ));
                                    ?>
                                </div>
                            </div>
                            
                            <!-- Cédula/RUC -->
                            <div class="form-group">
                                <?php echo lang('proponentes_cedularuc', 'cedularuc', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($cedularuc); ?>
                                </div>
                            </div>
                            
                            <!-- Nombre (read-only) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_nombre', 'nombre', array('class' => 'col-sm-3 control-label', 'readonly')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($nombre); ?>
                                </div>
                            </div>
                            
                            <!-- Apellido (read-only) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_apellido', 'apellido', array('class' => 'col-sm-3 control-label', 'readonly')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($apellido); ?>
                                </div>
                            </div>
                            
                            <!-- Email (read-only) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_email', 'email', array('class' => 'col-sm-3 control-label', 'readonly')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($email); ?>
                                </div>
                            </div>
                            
                            <!-- Fecha de Nacimiento -->
                            <div class="form-group"> 
                                <?php echo lang('proponentes_fecha_nac', 'fecha_nac', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($fecha_nac); ?>
                                </div>                                            
                            </div>
                            
                            <!-- Sexo (ahora input) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_sexo', 'dp_sexo', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php  
                                        $sexo_val = isset($sexo[$sexo_sel]) ? $sexo[$sexo_sel] : '';
                                        echo form_input(array(
                                            'name'     => 'dp_sexo',
                                            'id'       => 'dp_sexo',
                                            'value'    => $sexo_val,
                                            'class'    => 'form-control',
                                            'readonly' => 'readonly'
                                        ));
                                    ?>
                                </div>
                            </div>
                            
                            <!-- Cliente (ahora input) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_id_cliente', 'id_cliente', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php  
                                        $cliente_val = isset($cliente[$cliente_sel]) ? $cliente[$cliente_sel] : '';
                                        echo form_input(array(
                                            'name'     => 'dp_clientes',
                                            'id'       => 'dp_clientes',
                                            'value'    => $cliente_val,
                                            'class'    => 'form-control',
                                            'readonly' => 'readonly'
                                        ));
                                    ?>
                                </div>
                            </div>
                            
                            <!-- Teléfono -->
                            <div class="form-group">
                                <?php echo lang('proponentes_telefono', 'telefono', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($telefono); ?>
                                </div>
                            </div>
                            
                            <!-- Dirección -->
                            <div class="form-group">
                                <?php echo lang('proponentes_direccion', 'direccion', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($direccion); ?>
                                </div>
                            </div>
                            
                            <!-- Tipo Empresa (ahora input) -->
                            <div class="form-group">
                                <?php echo lang('proponentes_tipo_emporesa', 'dp_tipo_empresa', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php  
                                        $tipo_empresa_val = isset($tipo_empresa[$tipo_empresa_sel]) ? $tipo_empresa[$tipo_empresa_sel] : '';
                                        echo form_input(array(
                                            'name'     => 'dp_tipo_empresa',
                                            'id'       => 'dp_tipo_empresa',
                                            'value'    => $tipo_empresa_val,
                                            'class'    => 'form-control',
                                            'readonly' => 'readonly'
                                        ));
                                    ?>
                                </div>
                            </div>
                            
                            <!-- Nacionalidad -->
                            <div class="form-group">
                                <?php echo lang('proponentes_nacionalidad', 'nacionalidad', array('class' => 'col-sm-3 control-label')); ?>
                                <div class="col-sm-4">
                                    <?php echo form_input($nacionalidad); ?>
                                </div>
                            </div>
                            
                            <!-- Sección de Representante Legal -->
                            <div style="border: 1px solid #ccc; border-radius: 5px; background-color: #f9f9f9; padding: 20px; margin-top: 20px;">
                                <div class="form-group">
                                    <div class="col-sm-6 control-label">
                                        <h4 style="font-weight: bold;">Representante Legal</h4>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <?php echo lang('proponentes_rlegal_cedula', 'rlegal_cedula', array('class' => 'col-sm-3 control-label')); ?>
                                    <div class="col-sm-4">
                                        <?php echo form_input($rlegal_cedula); ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <?php echo lang('proponentes_rlegal_nombre', 'rlegal_nombre', array('class' => 'col-sm-3 control-label')); ?>
                                    <div class="col-sm-4">
                                        <?php echo form_input($rlegal_nombre); ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <?php echo lang('proponentes_rlegal_apellido', 'rlegal_apellido', array('class' => 'col-sm-3 control-label')); ?>
                                    <div class="col-sm-4">
                                        <?php echo form_input($rlegal_apellido); ?>
                                    </div>
                                </div>
                                <!-- Sexo Representante Legal (ahora input) -->
                                <div class="form-group">
                                    <?php echo lang('proponentes_rlegal_sexo', 'dp_rlegal_sexo', array('class' => 'col-sm-3 control-label')); ?>
                                    <div class="col-sm-4">
                                        <?php  
                                            $rlegal_sexo_val = isset($rlegal_sexo[$rlegal_sexo_sel]) ? $rlegal_sexo[$rlegal_sexo_sel] : '';
                                            echo form_input(array(
                                                'name'     => 'dp_rlegal_sexo',
                                                'id'       => 'dp_rlegal_sexo',
                                                'value'    => $rlegal_sexo_val,
                                                'class'    => 'form-control',
                                                'readonly' => 'readonly'
                                            ));
                                        ?>
                                    </div>
                                </div>
                            </div>
                            
                            <br>
                            <div class="form-group">
                                <div class="col-sm-offset-2 col-sm-10">
                                    <div class="btn-group">
                                        <?php echo anchor('proponentes/proponentes/index', lang('actions_cancel'), array('class' => 'btn btn-default btn-flat')); ?>
                                    </div>
                                </div>
                            </div>
                        <?php echo form_close(); ?>
                    </div>
                 </div>
             </div>
        </div>
    </section>
</div>

