<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Proyectos</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
</head>
<body>
    <div class="container">
        <h2 class="text-center">Listado de Proyectos</h2>
        <a href="<?php echo site_url('proyectos/export_excel'); ?>" class="btn btn-success">
            <span class="glyphicon glyphicon-download"></span> Exportar a Excel
        </a>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Descripción</th>
                    <th>Proponente</th>
                    <th>Consultor</th>
                    <th>Código</th>
                    <th>Fecha Registro</th>
                    <th>Fecha Inicio</th>
                    <th>Fecha Final</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($proyectos as $p) : ?>
                    <tr>
                        <td><?php echo $p['gid']; ?></td>
                        <td><?php echo $p['nombre']; ?></td>
                        <td><?php echo $p['descripcion']; ?></td>
                        <td><?php echo $p['proponente']; ?></td>
                        <td><?php echo $p['consultor']; ?></td>
                        <td><?php echo $p['codigo']; ?></td>
                        <td><?php echo $p['fecha_registro']; ?></td>
                        <td><?php echo $p['fecha_inicio']; ?></td>
                        <td><?php echo $p['fecha_final']; ?></td>
                        <td><?php echo $p['estado']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
