<head> 
<style>
    body {
        background-color: #f8f9fa;
    }

    .table th {
        background-color: #007bff;
        color: white;
    }

    .table-container {
        max-width: 1200px;
        margin: auto;
        padding: 20px;
        border-radius: 5px;
        background-color: #ffffff;
    }

    .table {
        font-size: 15px;
    }

    .pagination {
        display: flex;
        justify-content: center;
        margin-top: 20px;
    }

    .pagination a, .pagination strong {
        padding: 10px 15px;
        margin: 0 5px;
        text-decoration: none;
        background-color: #007bff;
        color: #ffffff;
        border-radius: 3px;
    }

    .pagination a:hover {
        background-color: #0056b3;
    }

    .pagination strong {
        background-color: #6c757d;
    }
</style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <h1 class="mb-4">Listado de Departamentos</h1>
        </section>

        <section class="content">
            <div class="container mt-5">
                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>ID Departamento</th>
                                    <th>Departamento</th>
                                    <th>Distrito</th>
                                    <th>Localidad</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($departamentos as $departamento): ?>
                                    <tr>
                                        <td><?php echo htmlspecialchars($departamento['id_departamento'], ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?php echo htmlspecialchars($departamento['departamento'], ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?php echo htmlspecialchars($departamento['distrito'], ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td><?php echo htmlspecialchars($departamento['localidad'], ENT_QUOTES, 'UTF-8'); ?></td>
                                        <td>
                                            <a href="<?php echo site_url('departamentos/view/'.$departamento['id_departamento']); ?>" class="btn btn-info btn-sm">Ver</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>