CREATE OR REPLACE FUNCTION bya.cuadrar_superficies(
   i_tabla character varying,
   i_gid integer,
   i_codigo character varying)
    RETURNS boolean
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE STRICT PARALLEL UNSAFE
AS $BODY$
DECLARE

   resultado  boolean;
   i integer;
   a_linea geometry(MultiLineString);
   d bya.uso_alternativo%ROWTYPE;

   b bya.bloques%ROWTYPE;
   a bya.aldeas%ROWTYPE;
   p bya.parcelas%ROWTYPE;

   -- Bloques
   ba bya.bloques_uso_alternativo%ROWTYPE;
   bai i3geo.bloques_uso_alternativo%ROWTYPE;
   bu bya.bloques_uso_actual%ROWTYPE;
   bui i3geo.bloques_uso_actual%ROWTYPE; 
   b6 bya.bloques_uso86%ROWTYPE;
   b6i i3geo.bloques_uso86%ROWTYPE;     

   -- Aldeas
   aa bya.aldeas_uso_alternativo%ROWTYPE;
   aai i3geo.aldeas_uso_alternativo%ROWTYPE;
   au bya.aldeas_uso_actual%ROWTYPE;
   aui i3geo.aldeas_uso_actual%ROWTYPE;   
   a6 bya.aldeas_uso86%ROWTYPE;
   a6i i3geo.aldeas_uso86%ROWTYPE;   

   -- Parcelas
   pa bya.parcelas_uso_alternativo%ROWTYPE;
   pai i3geo.parcelas_uso_alternativo%ROWTYPE;
   pu bya.parcelas_uso_actual%ROWTYPE;
   pui i3geo.parcelas_uso_actual%ROWTYPE;   
   p6 bya.parcelas_uso86%ROWTYPE;
   p6i i3geo.parcelas_uso86%ROWTYPE;   

   
   i_nombre_uso varchar(50);
   i_sql varchar(4000);
   i_desc varchar;
   c_tabla0 refcursor;
   c_tabla1 refcursor;
   c_tabla2 refcursor;
   c_tabla3 refcursor;
   c_tabla4 refcursor;
   
   i_tot_sup_cat decimal;
   i_tot_sup_cat_c decimal;
   i_tot_dif decimal;
   i_diferencia decimal;
   i_incremento decimal;
   i_cantidad integer;
   
   i_epsg integer;
   i_error varchar;
   
BEGIN
   resultado:=true;
   
   select codigo_epsg into i_epsg from bya.colonias where gid=i_gid;

   if i_tabla='BLOQUES_USO_ALTERNATIVO' then   
      delete from bya.errores;
      --delete from bya.bloques_uso_alternativo where id_colonia = i_gid;
      --delete from i3geo.bloques_uso_alternativo where id_colonia = i_gid;
     i_sql='select * from bya.bloques where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   
   if i_tabla='ALDEAS_USO_ALTERNATIVO' then   
      delete from bya.errores;
      --delete from bya.aldeas_uso_alternativo where id_colonia = i_gid;
      --delete from i3geo.aldeas_uso_alternativo where id_colonia = i_gid;
     i_sql='select * from bya.aldeas where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='PARCELAS_USO_ALTERNATIVO' then    
      i = 0;
      i_sql='select * from bya.parcelas where lote_n ='||''''||i_codigo||''''; 
      open c_tabla0 for execute i_sql;
      loop                      
         fetch c_tabla0 into p;
         exit when not found; 
        i_error = 'Colonia: '||i_gid::varchar||' Lote: '||i_codigo||' gid_parcela: '||p.gid::varchar||' ------   '||p.supha::varchar;
        insert into bya.errores (descripcion) values (i_error);          
       select 
       sum(sup_cat), 
       sum(round((st_area(ST_Transform(ST_SetSRID(p.geom,32721),i_epsg))/10000)::numeric,4)),
       count(*)
       into i_tot_sup_cat,i_tot_sup_cat_c,i_cantidad from bya.parcelas_uso_alternativo where objectid_par=p.gid;     
       i_diferencia = ABS(p.supha-i_tot_sup_cat);     
       if i_cantidad >= ABS(i_diferencia) then
          i_incremento = 0.0001;
       else
          i_incremento =   ABS(round(i_diferencia/i_cantidad,4));
       end if;
         i_error = 'Colonia: '||i_gid::varchar||' INCREMENTO: '||i_incremento||' gid_parcela: '||p.gid::varchar||' DIFERENCIA   '||i_diferencia;             
       insert into bya.errores (descripcion) values (i_error);
       i_tot_dif=0;      
         if i_diferencia <> 0 then   
           i_sql='select * from bya.parcelas_uso_alternativo where objectid_par='||p.gid||' order by sup_cat desc;'; 
            open c_tabla1 for execute i_sql;
            loop                                                                
              fetch c_tabla1 into pa;
              exit when not found;
           exit when i_diferencia>0;
           if (i_diferencia>0) then
               if (p.supha > i_tot_sup_cat) then
                update bya.parcelas_uso_alternativo set sup_cat = (sup_cat + i_incremento) where gid = pa.gid;
                  i_diferencia = i_diferencia + i_incremento;
               elseif (p.supha < i_tot_sup_cat) then
                update bya.parcelas_uso_alternativo set sup_cat = (sup_cat - i_incremento) where gid = pa.gid;
                    i_diferencia = i_diferencia -i_incremento;
               end if;            
             end if;
            end loop;     
            close c_tabla1;    
         end if; 
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='BLOQUES_USO_ACTUAL' then   
      delete from bya.errores;
      --delete from bya.bloques_uso_actual where id_colonia = i_gid;
      --delete from i3geo.bloques_uso_actual where id_colonia = i_gid;
     i_sql='select * from bya.bloques where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='ALDEAS_USO_ACTUAL' then   
      delete from bya.errores;
      --delete from bya.aldeas_uso_actual where id_colonia = i_gid;
      --delete from i3geo.aldeas_uso_actual where id_colonia = i_gid;
     i_sql='select * from bya.aldeas where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='PARCELAS_USO_ACTUAL' then 
      delete from bya.errores;
      --delete from bya.parcelas_uso_actual where id_colonia = i_gid;
      --delete from i3geo.parcelas_uso_actual where id_colonia = i_gid;   
      i_sql='select * from bya.parcelas where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into p;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='BLOQUES_USO86' then   
      delete from bya.errores;
      --delete from bya.bloques_uso86 where id_colonia = i_gid;
      --delete from i3geo.bloques_uso86 where id_colonia = i_gid;
     i_sql='select * from bya.bloques where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into b;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='ALDEAS_USO86' then   
      delete from bya.errores;
      --delete from bya.aldeas_uso86 where id_colonia = i_gid;
      --delete from i3geo.aldeas_uso86 where id_colonia = i_gid;
     i_sql='select * from bya.aldeas where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into a;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   if i_tabla='PARCELAS_USO86' then 
      delete from bya.errores;
      --delete from bya.parcelas_uso86 where id_colonia = i_gid;
      --delete from i3geo.parcelas_uso86 where id_colonia = i_gid;   
      i_sql='select * from bya.parcelas where id_colonia='||i_gid; 
      open c_tabla0 for execute i_sql;
      loop                                                                
         fetch c_tabla0 into p;
         exit when not found;     
      end loop;     
      close c_tabla0;     
   end if; 

   RETURN resultado;
END;
$BODY$;

ALTER FUNCTION bya.cuadrar_superficies(character varying, integer, character varying)
    OWNER TO postgres;