<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proyectos_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * proyectos
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/

	 // Proyectos_model.php

	public function get_cliente_id_usuario_actual()
	{
		$user_id = $this->ion_auth->get_user_id();

		// Consultar tabla users por id_cliente del usuario actual
		$this->db->select('id_cliente');
		$this->db->where('id', $user_id);
		$query = $this->db->get('public.users');

		if ($query->num_rows() > 0) {
			return $query->row()->id_cliente;
		} else {
			return NULL; // o FALSE si prefieres
		}
	}

	public function create_actividad($data) {
        return $this->db->insert('ema.actividades', $data);
    }

	 public function get_departamentos()
	 {
		$this->db->select('id, dpto_desc');
		return $this->db->get('ide.dpto')->result();
	 }
	 

	 public function get_distritos_by_dpto($dpto)
	 {
		 $this->db->select('id, dist_desc, distrito');
		 $this->db->where('dpto', $dpto);
		 return $this->db->get('ide.distritos')->result();
	 }
	 
	 public function get_barloc_by_distrito($dpto, $distrito)
	 {
		 $this->db->select('id, bar_loc, barlo_desc');
		 $this->db->where('dpto', $dpto);
		 $this->db->where('distrito', $distrito);
		 $this->db->order_by('id', 'ASC');
		 return $this->db->get('ide.barloc')->result();
	 }

	 public function get_barloc_by_id($id) {
		$query = $this->db->get_where('ide.barloc', ['id' => $id]);
		return $query->row();
	 }
	 
	
	 public function view_all($tabla, $where = NULL)
	 {
		 $this->trigger_events('proyectos');
 
		 $this->response = $this->db->get_where($this->tables[$tabla], $where)->num_rows();
		 
		 return $this;
	 }
 
	 public function get_proyectos($filters = [], $limit = 10, $offset = 0)
	 {
		 if (!empty($filters['gid'])) {
			 $this->db->like('CAST(gid AS TEXT)', $filters['gid']);
		 }
		 if (!empty($filters['id_cliente'])) {
			 $this->db->like('CAST(id_cliente AS TEXT)', $filters['id_cliente']);
		 }    
		 if (!empty($filters['codigo'])) {
			 $this->db->like('LOWER(codigo)', strtolower($filters['codigo']));
		 }
		 if (!empty($filters['nombre'])) {
			 $this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
		 }
		 if (!empty($filters['estado'])) {
			$this->db->where('estado', $filters['estado']);
		 }
		 if (!empty($filters['proponente'])) {
			 $this->db->like('LOWER(proponente)', strtolower($filters['proponente']));
		 }
		 if (!empty($filters['consultor'])) {
			 $this->db->like('LOWER(consultor)', strtolower($filters['consultor']));
		 }
		 if (!empty($filters['fecha_inicio'])) {
			 $this->db->where('fecha_inicio >=', $filters['fecha_inicio']);
		 }
		 if (!empty($filters['fecha_inicio2'])) {
			 $this->db->where('fecha_inicio <=', $filters['fecha_inicio2']);
		 }
	 
		 // Ordenar por fecha_inicio descendente (la más reciente primero)
		 $this->db->order_by('gid', 'DESC');
	 
		 return $this->db->get('ema.v_proyectos_index', $limit, $offset)->result_array();
	 }
	 
	 
	 public function count_proyectos($filters = [])
	 {
		if (!empty($filters['gid'])) {
			$this->db->like('CAST(gid AS TEXT)', $filters['gid']);
		}
		if (!empty($filters['id_cliente'])) {
			$this->db->like('CAST(id_cliente AS TEXT)', $filters['id_cliente']);
		}    
		if (!empty($filters['codigo'])) {
			$this->db->like('LOWER(codigo)', strtolower($filters['codigo']));
		}
		if (!empty($filters['nombre'])) {
			$this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
		}
		if (!empty($filters['estado'])) {
		   $this->db->where('estado', $filters['estado']);
		}
		if (!empty($filters['proponente'])) {
			$this->db->like('LOWER(proponente)', strtolower($filters['proponente']));
		}
		if (!empty($filters['consultor'])) {
			$this->db->like('LOWER(consultor)', strtolower($filters['consultor']));
		}
		if (!empty($filters['fecha_inicio'])) {
			$this->db->where('fecha_inicio >=', $filters['fecha_inicio']);
		}
		if (!empty($filters['fecha_inicio2'])) {
			$this->db->where('fecha_inicio <=', $filters['fecha_inicio2']);
		}
	 
		 return $this->db->count_all_results('ema.v_proyectos_index');
	 }
	 
	 
	 

	public function obtener_parcelas($tabla, $where = NULL)
	{
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}


	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}

	/**
	 * Proyectos
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view($tabla, $where = NULL)
	{
		$this->trigger_events('proyectos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}

	

	/**
	 * concepto
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/

	public function concepto ($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
	{
		$query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.conceptos WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

		if ($i_concepto == TRUE) {
			$query = $query . " AND CONCEPTO = '" . $i_concepto . "'";
		}

		if ($blanco == TRUE) {
			$query = $query . " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
		}
		if ($orderby) {
			$query = $query . " ORDER BY ".$orderby;
		}
		$this->response = $this->db->query($query);

		$_SESSION['last_query'] = $this->db->last_query();

		return $this;
	}	

	public function concepto2($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }	

	/**
	 * create_colonia
	 *
	 * @author aditya menon
	*/
	public function create_colonia($arraycampos = NULL)
	{
		// Verificar si la colonia ya existe basándonos en los campos recibidos
		$existing_colonia = $this->db->get_where($this->tables['proyectos'], $arraycampos)->num_rows();

		// Si ya existe una colonia con esos datos, devolver false
		if ($existing_colonia !== 0)
		{
			$this->ion_auth->set_error('colonia_already_exists');
			return FALSE;
		}

		// Insertar el nuevo proyecto (colonia)
		$this->db->insert($this->tables['proyectos'], $arraycampos);

		// Obtener el ID del proyecto insertado
		$colonia_gid = $this->db->insert_id();

		// Si se inserta correctamente, devolver el ID del nuevo proyecto
		$this->set_message('colonia_creation_successful');
		return $colonia_gid;
	}


	
	
	/**
	 * update_colonia
	 *
	 * @return bool
	 * @author aditya menon
	 **/

    public function update_colonia($gid, $arraycampos)
	{
		$this->db->update($this->tables['proyectos'], $arraycampos, array('gid' => $gid));

        $this->ion_auth->set_message('proyectos_update_successful');

        return TRUE;
	}

//		$resultado = $this->db->query("SELECT ide.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;


	/**
	 * cnt_col_reg_layers
	 * cuenta registros espaciales dependientes de colonia.
	 * @return integer 
	 * @author Jaime Rojas Landivar
	 **/
    public function cnt_col_reg_layers($gid = null)
	{
		$total =  0; 
        $sq = "select sum(cnt) total from (
         select 'Bloques' tabla, count(*) cnt from ema.bloques where id_colonia = ".$gid."
        union select 'Parcelas' tabla, count(*) cnt from ema.parcelas where id_colonia = ".$gid."
        union select 'Lotes' tabla, count(*) cnt from ema.Lotes where id_colonia = ".$gid."
        union select 'UsoActual' tabla, count(*) cnt from ema.uso_actual where id_colonia = ".$gid."
        union select 'UsoAlter' tabla, count(*) cnt from ema.uso_alternativo where id_colonia = ".$gid."
        union select 'Uso86' tabla, count(*) cnt from ema.uso86 where id_colonia = ".$gid."
        union select 'capacidad' tabla, count(*) cnt from ema.capacidad where id_colonia = ".$gid."
        union select 'taxonomia' tabla, count(*) cnt from ema.taxonomia where id_colonia = ".$gid."
        union select 'poligono_proyecto' tabla, count(*) cnt from ema.poligono_proyecto where id_proyecto = ".$gid."
        union select 'unidad_productiva' tabla, count(*) cnt from ema.unidad_productiva where id_proyecto = ".$gid." 
        union select 'plano_proyecto' tabla, count(*) cnt from ema.plano_proyecto where id_proyecto = ".$gid."
        union select 'plano_proyecto' tabla, count(*) cnt from ema.coordenadas where id_proyecto = ".$gid."                
		) x;     
         ";

		$total = $this->db->query($sq)->row()->total;
		return $total; 
	}

	/**
	 * eliminar_proyectos
	 * elimina parcelas correspondientes a la colonia de la tabla in_temp
	 * @return bool
	 * @author Jaime Rojas Landivar
	 **/
    public function eliminar_colonia($gid)
	{
		$resultado =  true; 
        $sq = "select sum(x.cnt) as total from (
         select 'Bloques' tabla, count(*) cnt from ema.bloques where id_colonia = ".$gid."
        union select 'Parcelas' tabla, count(*) cnt from ema.parcelas where id_colonia = ".$gid."
        union select 'Lotes' tabla, count(*) cnt from ema.Lotes where id_colonia = ".$gid."
        union select 'UsoActual' tabla, count(*) cnt from ema.uso_actual where id_colonia = ".$gid." 
        union select 'UsoAlter' tabla, count(*) cnt from ema.uso_alternativo where id_colonia = ".$gid."
        union select 'Uso86' tabla, count(*) cnt from ema.uso86 where id_colonia = ".$gid."
        union select 'capacidad' tabla, count(*) cnt from ema.capacidad where id_colonia = ".$gid."
        union select 'taxonomia' tabla, count(*) cnt from ema.taxonomia where id_colonia = ".$gid."
        union select 'poligono_proyecto' tabla, count(*) cnt from ema.poligono_proyecto where id_proyecto = ".$gid."
        union select 'unidad_productiva' tabla, count(*) cnt from ema.unidad_productiva where id_proyecto = ".$gid."     
        union select 'plano_proyecto' tabla, count(*) cnt from ema.plano_proyecto where id_proyecto = ".$gid."
        union select 'plano_proyecto' tabla, count(*) cnt from ema.coordenadas where id_proyecto = ".$gid."    
		) x;     
         ";

		$total = $this->db->query($sq)->row()->total;

		if ($total == 0) {
			$sq = "delete from ema.proyectos where gid = ".$gid.";";			
			$del = $this->db->query($sq);
			$sq = "select count(*) as total from ema.proyectos where gid = ".$gid;
			$total = $this->db->query($sq)->row()->total;	
			if ($total == 0) {
				$resultado = true;
			}else{
				$resultado = false;
			}			

		}else{
			$resultado = false;
		}
		return $resultado; 
	}

	/**
	 * eliminar_parcelas
	 * elimina parcelas correspondientes a la colonia de la tabla in_temp
	 * @return bool
	 * @author Diego Ferreira
	 **/
    public function eliminar_parcelas($tabla, $where)
	{
		$this->db->delete($this->tables[$tabla], $where);

        return TRUE;
	}

	public function generar_periciasimple ($objectid)
	{
		$pericia = $this->db->query('SELECT indert.pericias_generarsimple('.$objectid.') r;');
		if ($pericia->num_rows() > 0) {
			//$this->response = $pericia;
			return true;
		}else{
			return false;
		}
	
	}

	public function generar_periciaresumido ($objectid)
	{
		$pericia = $this->db->query('SELECT indert.pericias_generarpericia('.$objectid.') r;');
		if ($pericia->num_rows() > 0) {
			//$this->response = $pericia;
			return true;
		}else{
			return false;
		}
	
	}


    public function eliminar_basura()
	{
		$sql_query = "delete from indert.in_temp ";
		$sql_query = $sql_query . "where (coalesce(dpto,'NN'),coalesce(distrito,'NN'),coalesce(colonia,0)) ";
		$sql_query = $sql_query . "not in (select dpto_cod,dist_cod,col_cod from indert.proyectos); ";
		$resultado = $this->db->query($sql_query);

        return TRUE;
	}

    public function eliminar_pericia($objectid)
	{
		$resultado = $this->db->query('delete from indert.in_planopericia3 where objectid = '.$objectid.';');
		$resultado = $this->db->query('delete from indert.in_planopericia2 where objectid = '.$objectid.';');
		$resultado = $this->db->query('delete from indert.in_planopericia1 where objectid = '.$objectid.';');

        return TRUE;
	}

	public function obtener_pericia ($tabla, $where)
	{
		//$pericia = $this->db->pg_query($this->tables['in_planopericia2'], $where);
		$pericia = $this->db->get_where($this->tables[$tabla], $where);
		if ($pericia->num_rows() > 0) {
			$this->response = $pericia;
		}else{
			return false;
		}

		return $this;
	}




	public function md_generar_pericia_completa ($dpto, $distrito, $colonia)
	{

		$pericia = $this->db->query("SELECT indert.generar_pericias_x_colonia("."'".$dpto."','".$distrito."',".$colonia.");");
		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
	}


	public function crear_poligono_colonia ($dpto, $distrito, $colonia)
	{

		$pericia = $this->db->query("SELECT indert.actualizar_proyectos_una("."'".$dpto."','".$distrito."',".$colonia.");");
		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
	}



	public function md_generar_lineas ($dpto, $distrito, $colonia)
	{

		$pericia = $this->db->query("SELECT indert.pericias_generar_lineas("."'".$dpto."','".$distrito."',".$colonia.");");

		if ($pericia->num_rows() > 0) {
			return true;
		}else{
			return false;
		}
		
	

	}

	public function obtener_parcelas_sinpericias($dpto, $distrito, $colonia)
	{
		
		$sql_query = "select t.*,c.formato_lado from indert.in_temp t, indert.proyectos c where ";
  		$sql_query = $sql_query . " t.dpto::text = c.dpto_cod::text and t.distrito::text = c.dist_cod::text ";
  		$sql_query = $sql_query . " and t.colonia::numeric = c.col_cod ";    	
		$sql_query = $sql_query . "and t.objectid in ( ";
		$sql_query = $sql_query . "select p.objectid from indert.v_pericias_lados p ";
		$sql_query = $sql_query . "where p.dpto = '".$dpto."' and  p.distrito = '".$distrito."' and p.colonia  = " .$colonia;
		$sql_query = $sql_query . " and (p.objectid,p.num_p1) ";
		$sql_query = $sql_query . "not in (select x.objectid, x.num_p1 ";
		$sql_query = $sql_query . "from indert.in_planopericia1 x ";
		$sql_query = $sql_query . "where x.dpto = '".$dpto."' and  x.distrito = '".$distrito."' and x.colonia = ".$colonia.")) ;";

		$this->response = $this->db->query($sql_query);
		
		return $this;
	}


	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}


	/**
	 * actualizar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL, $id_epsg = NULL)
	{

		$resultado = $this->db->query("SELECT indert.actualizar_shapes(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.",".$id_epsg.");");

		return $resultado;
	}


	/**
	 * validar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function validar_shapes($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL, $id_epsg = NULL)
	{

		$resultado = $this->db->query("SELECT indert.validar_shapes(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.",".$id_epsg.");");

		return $resultado;
	}


	/**
	 * eliminar_geometrias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_geometrias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{
		$resultado = $this->db->query("SELECT indert.f_eliminar_geometrias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");")->row()->f_eliminar_geometrias;;


		return $resultado;
	}


	/**
	 * validar_pericias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function validar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_validar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;

	}


	/**
	 * eliminar_in_parc
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_in_parc($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_eliminar_in_parc(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;

	}


	/**
	 * confirmar_pericia
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function confirmar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_confirmar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}


	/**
	 * habilitar_pericias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function habilitar_pericias($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_habilitar_pericias(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}



	/**
	 * bloquea_planocolonia
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function bloquear_planocolonia($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_bloquear_planocolonia(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}

	/**
	 * eliminar_periciaconfirmada
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_periciaconfirmada($gid = NULL, $dpto_cod = NULL, $dist_cod = NULL, $col_cod = NULL)
	{

		$resultado = $this->db->query("SELECT indert.f_eliminar_periciaconfirmada(".$gid.",'".$dpto_cod."','".$dist_cod."',".$col_cod.");");

		return $resultado;
	}



	/**
	 * campo_valor_maximo
	 *	Obtiene el valor máximo de una columna y tabla específica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_valor_campo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select($columna." as campo");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->campo;
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros_all ($tabla = NULL)
	{

		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla($tabla = NULL)
	{
		
		$resultado = $this->db->query("SELECT ema.f_eliminar_datos_tabla('".$tabla."');");

		return $resultado;
	}
	

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla_colonia($tabla = NULL, $gid = NULL)
	{
		
		$resultado = $this->db->query("SELECT ema.f_eliminar_datos_tabla_colonia('".$tabla."',".$gid.");");

		return $resultado;
	}


	/**
	 * copiar_temporal_a_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function copiar_temporal_a_tabla($tabla = NULL)
	{

		$resultado = $this->db->query("SELECT ema.copiar_temporal_a_tabla('".$tabla."');");

		return $resultado;
	}

	/**
	 * dinamic_copiar_temporal_a_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function dinamic_copiar_temporal_a_tabla($tabla = NULL, $gid = NULL, $id_epsg = NULL)
	{

		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT ema.dinamic_copiar_temporal_a_tabla('".$tabla."',".$gid.",".$id_epsg.");";

	        try {

				$resultado = $this->db->query($i_sql);
				$resultado = 0;
	        }
	        catch(Exception $e) {
	        	$resultado = 1;
	        }

		return $resultado;
	}


	/**
	 * generar_lotes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function generar_lotes($i_colonia = NULL)
	{

		$i_sql = "SELECT ema.dinamic_generar_lotes_usos(".$i_colonia.",'LOTES');";
		$resultado = $this->db->query($i_sql); //run query	

		return $resultado;
	}		

	/**
	 * actualizar_categorias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_categorias($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT ema.actualizar_categorias('USO_ALTERNATIVO',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT ema.actualizar_categorias('USO_ACTUAL',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query		
		$i_sql = "SELECT ema.actualizar_categorias('USO86',".$i_colonia.");";
		
		$resultado = $this->db->query($i_sql); //run query			
		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	



	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos($i_tabla = NULL, $i_colonia = NULL)
	{
		if ($i_tabla = 'PARCELAS_USO_ALTERNATIVO') { 
			$i_sql = "SELECT ema.actualizar_uso_alternativo('".$i_tabla."',".$i_colonia.");";
			$resultado = $this->db->query($i_sql); //run query	
		} else { 
			$i_sql = "SELECT ema.actualizar_usos('".$i_tabla."',".$i_colonia.");";
			$resultado = $this->db->query($i_sql); //run query	
		} 
		return $resultado;
	}


	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/


	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos2($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */

		//$i_sql = "SELECT ema.actualizar_usos('BLOQUES_USO_ACTUAL',".$i_colonia.");";
		//$resultado = $this->db->query($i_sql); //run query	
		//$i_sql = "SELECT ema.actualizar_usos('ALDEAS_USO_ACTUAL',".$i_colonia.");";
		//$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT ema.actualizar_usos('PARCELAS_USO_ACTUAL',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query


		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	

	/**
	 * actualizar_usos
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_usos3($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */	

		//$i_sql = "SELECT ema.actualizar_usos('BLOQUES_USO86',".$i_colonia.");";
		//$resultado = $this->db->query($i_sql); //run query	
		//$i_sql = "SELECT ema.actualizar_usos('ALDEAS_USO86',".$i_colonia.");";
		//$resultado = $this->db->query($i_sql); //run query
		$i_sql = "SELECT ema.actualizar_usos('PARCELAS_USO86',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query


		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'USO_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}

	// Nuevo 02/09/2025

	
	public function get_proyectos1($filters = []) 
	{
		$this->db->select('*');
		$this->db->from('ema.v_proyectos_index');

		// Si hay filtros, aplicarlos
		if (!empty($filters)) {
			$this->db->where($filters);
		}

		$query = $this->db->get();
		return $query->result_array();
	}

	public function codigo_existe($codigo) {
		$this->db->where('codigo', $codigo);
		return $this->db->count_all_results('ema.v_proyectos_index') > 0;
	}

	//Nuevo 13/03/2025

	public function save_evaluacion($data)
	{
		// Verifica si la evaluación ya existe para el proyecto y la categoría
		$this->db->where('proyecto_id', $data['proyecto_id']);
		$this->db->where('categoria', $data['categoria']);
		$this->db->where('estado', $data['estado']);
		$query = $this->db->get('proyectos_evaluaciones');

		if ($query->num_rows() > 0) {
			// Si existe, actualiza
			$this->db->where('proyecto_id', $data['proyecto_id']);
			$this->db->where('categoria', $data['categoria']);
			$this->db->where('estado', $data['estado']);
			return $this->db->update('proyectos_evaluaciones', $data);
		} else {
			// Si no existe, inserta un nuevo registro
			return $this->db->insert('proyectos_evaluaciones', $data);
		}
	}

	    /**
     * Obtener los archivos relacionados con un proyecto específico
     * @param int $proyecto_id ID del proyecto
     * @return array Lista de evaluaciones relacionadas con el proyecto
     */
    public function get_archivos_by_proyecto($proyecto_id) {
        $this->db->select('*');
        $this->db->from('ema.proyectos_evaluaciones');
        $this->db->where('proyecto_id', (int) $proyecto_id);
        return $this->db->get()->result_array();
    }

}