<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tipocapacidad_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * tipocapacidad
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view_all($tabla, $where = NULL)
	{
		$this->trigger_events('tipocapacidad');

		// run each where that was passed
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where)->num_rows();
		
		return $this;
	}



	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}


	/**
	 * tipocapacidad
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view($tabla, $where = NULL)
	{
		$this->trigger_events('proyectos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}

	/**
	 * create tipocapacidad
	 *
	 * @author Jaime Rojas
	*/
	public function create_tipocapacidad($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existing_tipo = $this->db->get_where($this->tables['tipocapacidad'], $arraycampos)->num_rows();

		
		if($existing_tipo !== 0)
		{
			$this->ion_auth->set_error('tipocapacidad_already_exists');
			return FALSE;
		}
		
		// insert the new group
		$this->db->insert($this->tables['tipocapacidad'], $arraycampos);
		$tipocapacidad_gid = $this->db->insert_id();

		// report success
		$this->set_message('tipocapacidad_creation_successful');
		// return the brand new group id
		return $tipocapacidad_gid;
	}

	
	
	/**
	 * update_tipocapacidad
	 *
	 * @return bool
	 * @author Jaime Rojas
	 **/

    public function update_tipocapacidad($tipo, $arraycampos)
	{
		$this->db->update($this->tables['tipocapacidad'], $arraycampos, array('tipo' => $tipo));

        $this->ion_auth->set_message('tipocapacidad_update_successful');

        return TRUE;
	}

//		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;


	/**
	 * eliminar_tipocapacidad
	 * cuenta registros espaciales dependientes de tipocapacidad.
	 * @return integer 
	 * @author Jaime Rojas Landivar
	 **/
    public function cnt_tipocapacidad_reg_layers($tipo = null)
	{
		$total =  0; 
        $sq = "select sum(x.cnt) total from (
        select 'Tipo86' tabla, count(*) cnt from ema.capacidad where categoria = '".$tipo."' 
		) x;     
         ";

		$total = $this->db->query($sq)->row()->total;
		return $total; 
	}

	/**
	 * eliminar_tipocapacidad
	 * elimina dependientes de la tabla tipocapacidad
	 * @return bool
	 * @author Jaime Rojas Landivar
	 **/
    public function eliminar_tipocapacidad($tipo)
	{
		$resultado =  true; 
        $sq = "select sum(x.cnt) as total from (
        select count(*) cnt from ema.capacidad where categoria = '".$tipo."' 
		) x;     
         ";

		$total = $this->db->query($sq)->row()->total;

		if ($total == 0) {
			$sq = "delete from ema.tipocapacidad where tipo = '".$tipo."';";			
			$del = $this->db->query($sq);
			$sq = "select count(*) as total from ema.tipocapacidad where tipo = '".$tipo."'";
			$total = $this->db->query($sq)->row()->total;	
			if ($total == 0) {
				$resultado = true;
			}else{
				$resultado = false;
			}			

		}else{
			$resultado = false;
		}
		return $resultado; 
	}

	/*
	 * delete tipocapacidad
	 * elimina tipocapacidad 
	 * @return bool
	 * @author Jaime Rojas Lndivar
    */

    public function delete($tabla, $where)
	{
		$this->db->delete($this->tables[$tabla], $where);

        return TRUE;
	}


	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}



	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros_all ($tabla = NULL)
	{

		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla($tabla = NULL)
	{
		
		$resultado = $this->db->query("SELECT ema.f_eliminar_datos_tabla('".$tabla."');");

		return $resultado;
	}
	

	/**
	 * actualizar_categorias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_categorias($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT ema.actualizar_categorias('TIPO_ALTERNATIVO',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query
		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'tipo_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	



	/**
	 * actualizar_tipocapacidad
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_tipocapacidad($i_tabla = NULL, $i_colonia = NULL)
	{
		$i_sql = "SELECT ema.actualizar_tipocapacidad('".$i_tabla."',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query	
		return $resultado;
	}




	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas Landivar
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}
	

}