<?php
// application/models/Tumba_model.php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tumba_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function upload_documents($field_name, $upload_path, $id_documento, $tipo_documento) {
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = '*'; // Permitir cualquier tipo de archivo
        $config['max_size'] = 20480; // Máximo tamaño en KB (20MB)
        $this->load->library('upload', $config);

        $files = $_FILES[$field_name];
        $uploaded_files = [];
        $errors = [];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['document']['name'] = $files['name'][$key];
            $_FILES['document']['type'] = $files['type'][$key];
            $_FILES['document']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['document']['error'] = $files['error'][$key];
            $_FILES['document']['size'] = $files['size'][$key];

            if ($this->upload->do_upload('document')) {
                $file_data = $this->upload->data();
                $uploaded_files[] = $file_data['file_name'];

                // Guardar en la tabla 'tumba'
                $data = array(
                    'id_documento' => $id_documento, // Nuevo campo genérico
                    'tipo_documento' => $tipo_documento, // Guardamos la extensión como tipo de documento
                    'url' => $upload_path . $file_data['file_name'],
                    'estado' => 1, // Por defecto activo
                    'fecha_reg' => date('Y-m-d H:i:s')
                );
                $this->db->insert('ema.tumba', $data);

            } else {
                $errors[] = $this->upload->display_errors();
            }
        }

        if (empty($errors)) {
            return ['status' => true, 'files' => $uploaded_files];
        } else {
            return ['status' => false, 'errors' => $errors];
        }
    }

    public function get_documents_by_project($id_documento, $tipo_documento = null) {
        $this->db->select('*') // Selecciona todos los campos
                 ->from('ema.tumba')
                 ->where('id_documento', $id_documento);
    
        if ($tipo_documento !== null) {
            $this->db->where('tipo_documento', $tipo_documento);
        }
    
        return $this->db->get()->result(); // Devuelve una lista de documentos
    }

    public function get_project_by_document($id_documento, $tipo_documento) {
        return $this->db->select('id_documento') // Obtener el ID del proyecto
                        ->from('ema.tumba')
                        ->where('id_archivo', $id_documento)
                        ->where('tipo_documento', $tipo_documento)
                        ->get()
                        ->row();
    }
    
    
    public function get_document($id_documento, $tipo_documento) {
        return $this->db->get_where('ema.tumba', [
            'id_archivo' => $id_documento,
            'tipo_documento' => $tipo_documento
        ])->row();
    }
    

    public function delete_document($id_documento, $tipo_documento = '1') {
        // Obtener el documento antes de eliminarlo
        $documento = $this->db->get_where('ema.tumba', [
            'id_archivo' => $id_documento,
            'tipo_documento' => $tipo_documento
        ])->row();
    
        if (!$documento) {
            return false; // No existe el documento con ese tipo
        }
    
        // Verificar si el archivo físico existe antes de eliminarlo
        if (file_exists($documento->url)) {
            unlink($documento->url);
        }
    
        // Eliminar de la base de datos
        $this->db->where([
            'id_archivo' => $id_documento,
            'tipo_documento' => $tipo_documento
        ])->delete('ema.tumba');
    
        return true;
    }

}
