<?php
class Resoluciones_model extends CI_Model {

    public function get_resoluciones($filters = []) 
    {
        if (!empty($filters)) {
            // Filtrar por id_proyecto de manera exacta
            if (!empty($filters['id_proyecto'])) {
                $id_proyecto = $this->db->escape_str($filters['id_proyecto']);
                $this->db->where('id_proyecto', $id_proyecto);  // Filtrado exacto por id_proyecto
            }
            
            // Filtrar por nro_resolucion de manera parcial
            if (!empty($filters['nro_resolucion'])) {
                $nro_resolucion = $this->db->escape_str($filters['nro_resolucion']);
                $this->db->where("CONCAT(nro_resolucion, '') LIKE '%{$nro_resolucion}%'");
            }
            
            // Filtrar por gestion_resolucion de manera parcial
            if (!empty($filters['gestion_resolucion'])) {
                $gestion_resolucion = $this->db->escape_str($filters['gestion_resolucion']);
                $this->db->where("CONCAT(gestion_resolucion, '') LIKE '%{$gestion_resolucion}%'");
            }
            
            // Filtrar por estado
            if (!empty($filters['estado'])) {
                $this->db->where('estado', $filters['estado']);
            }

            // Filtrar por tipo_resoluciones
            if (!empty($filters['tipo_resoluciones'])) {
                $this->db->where('tipo_resoluciones', $filters['tipo_resoluciones']);
            }
        }
        
        // Ejecutar la consulta y devolver el resultado
        return $this->db->get('ema.resoluciones')->result();
    }
    

    public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
    {
        if (!$tabla) {
            return []; // Devuelve un array vacío si no se especifica una tabla
        }

        $this->db->from($tabla); // Especifica la tabla correctamente

        if ($where) {
            foreach ($where as $k => $v) {
                $this->db->where($k, $v);
            }
        }

        if ($order_by) {
            $this->db->order_by($order_by, 'ASC');
        }

        return $this->db->get()->result_array(); // Devuelve los resultados correctamente
    }

    public function count_resoluciones($filters) {
        if (!empty($filters['id_proyecto'])) {
            $this->db->where('id_proyecto', $filters['id_proyecto']);
        }
        if (!empty($filters['nro_resolucion'])) {
            $this->db->where('nro_resolucion', $filters['nro_resolucion']);
        }
        if (!empty($filters['gestion_resolucion'])) {
            $this->db->where('gestion_resolucion', $filters['gestion_resolucion']);
        }
        if (!empty($filters['estado'])) {
            $this->db->like('estado', $filters['estado']);
        }
        if (!empty($filters['tipo_resoluciones'])) {
            $this->db->where('tipo_resoluciones', $filters['tipo_resoluciones']);
        }
    
        return $this->db->count_all_results('ema.resoluciones'); // Cuenta los registros en la tabla 'pgas'
    }

    public function get_resolucion_by_id_bk($id) {
        return $this->db->get_where('ema.resoluciones', ['id_resoluciones' => $id])->row_array();
    }

    public function create_resolucion($data) {
        $this->db->insert('ema.resoluciones', $data);
        return $this->db->insert_id(); // Devuelve el ID de la última inserción
    }
    

    public function update_resolucion($id, $data) {
        return $this->db->where('id_resoluciones', $id)->update('ema.resoluciones', $data);
    }

    public function delete_resolucion($id) {
        return $this->db->where('id_resoluciones', $id)->delete('ema.resoluciones');
    }
    public function get_resolucion_by_id($id)
    {
        $this->db->where('id_resoluciones', $id);
        return $this->db->get('ema.resoluciones')->row_array(); // row_array para devolver un único registro como array asociativo
    }

    public function concepto($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }

    public function get_proyecto_nombre($id_proyecto) {
        $this->db->select('nombre');
        $this->db->from('ema.proyectos');
        $this->db->where('gid', $id_proyecto);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->nombre;
        }
        return null;
    }

    public function get_declaraciones_by_proyecto($id_proyecto) {
        $this->db->select('id_declaracion, nro_declaracion'); // Selecciona solo los campos necesarios
        $this->db->from('ema.declaraciones');
        $this->db->where('id_proyecto', $id_proyecto); // Filtra por el proyecto
        $query = $this->db->get();
        
        // Depuración: Muestra los datos de la consulta
        $result = $query->result_array();
        //var_dump($result); // Verifica si los datos se están obteniendo correctamente
        return $result;
    }
    

    
}
