<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Licencia extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('expedientes/expedientes_model');
		$this->lang->load('expedientes/expedientes_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_expedientes'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'EXPEDIENTES') {

			$_SESSION['arraywhere_expedientes'] 		 = NULL;
			$_SESSION['arraywhere_expedientes_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'EXPEDIENTES';
		}   
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_expedientes'), 'expedientes/expedientes');
	}

	public function expe_licencia($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Licencia', 'man_espacial/proyectos/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        //$expe_id = 19;

	        $proyecto_datos = $this->expedientes_model->view('proyectos', array('gid' => $expe_id))->row();

	        $_SESSION['identificador'] = $proyecto_datos->gid;
	        $_SESSION['tipo_estudio'] = $proyecto_datos->tipo_estudio;
	        $_SESSION['estado'] = $proyecto_datos->estado;

	        
	        $expe_tipo_ref      = $proyecto_datos->tipo_estudio;
	        $expe_id_expediente = $proyecto_datos->gid;
	        $expe_gestion		= $proyecto_datos->exp_gestion;
	        $expe_estado		= $proyecto_datos->estado;	        
	        

	        IF (isset($proyecto_datos->tipo_estudio) or isset($expe_tipo_ref)) { 
				$expe_tipo_ref = '0';
				$_SESSION['tipo_estudio'] = '0';	        
			} else { 
				$expe_tipo_ref				= $proyecto_datos->tipo_estudio; 
				$_SESSION['tipo_estudio'] 	= $proyecto_datos->tipo_estudio; 
			}

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";   

			$expe_info  = $this->expedientes_model->view('proyectos', array('gid' => $expe_id))->result_array();						

			/************* CANTIDAD DATOS LICENCIA ****************/

			$licencia = $this->expedientes_model->view('declaraciones', array('decl_expe_id' => $expe_id))->result_array();

			if ($licencia) {
			}
			else {
				$licencia[0]['decl_expe_id'] 				= $_SESSION['identificador'] ;
				$licencia[0]['decl_nro_declaracion']		= '';
				$licencia[0]['decl_gestion_declaracion']	= 0;
				$licencia[0]['decl_tipo_ref']				= $_SESSION['tipo_estudio'];
				$licencia[0]['decl_fecha_declaracion']		= '';
				$licencia[0]['decl_tipo_frecuencia_aa']		= '';
				$licencia[0]['decl_frecuencia_aa']			= 0;
				$licencia[0]['decl_fecha_proxima_aa']		= '';
				$licencia[0]['decl_comentario_frecuencia']	= '';
				$licencia[0]['decl_observacion']			= '';
				$licencia[0]['decl_sup_legal']				= '';
			}

			$decl_expe_id 					= $_SESSION['identificador'] ;
			$decl_nro_declaracion 			= $licencia[0]['decl_nro_declaracion'];
			$decl_gestion_declaracion 		= $licencia[0]['decl_gestion_declaracion'];
			$decl_tipo_ref 					= $_SESSION['tipo_estudio'];
			$decl_fecha_declaracion 		= $licencia[0]['decl_fecha_declaracion'];
			$decl_tipo_frecuencia_aa 		= $licencia[0]['decl_tipo_frecuencia_aa'];
			$decl_frecuencia_aa 			= $licencia[0]['decl_frecuencia_aa'];
			$decl_fecha_proxima_aa 			= $licencia[0]['decl_fecha_proxima_aa'];
			$decl_comentario_frecuencia 	= $licencia[0]['decl_comentario_frecuencia'];
			$decl_observacion 				= $licencia[0]['decl_observacion'];
			$decl_sup_legal 				= $licencia[0]['decl_sup_legal'];

			/************* FIN CANTIDAD DATOS LICENCIA ****************/

        	$this->data['decl_expe_id'] 	= $_SESSION['identificador'];

			$this->data['expe_info'] 		= $expe_info;

			//$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['licencia'] 		= $licencia;

			$this->data['decl_expe_id'] 				= $decl_expe_id;
			$this->data['decl_nro_declaracion'] 		= $decl_nro_declaracion;
			$this->data['decl_gestion_declaracion'] 	= $decl_gestion_declaracion;
			$this->data['decl_tipo_ref'] 				= $decl_tipo_ref;
			$this->data['decl_fecha_declaracion'] 		= $decl_fecha_declaracion;
			$this->data['decl_tipo_frecuencia_aa'] 		= $decl_tipo_frecuencia_aa;
			$this->data['decl_frecuencia_aa'] 			= $decl_frecuencia_aa;
			$this->data['decl_fecha_proxima_aa'] 		= $decl_fecha_proxima_aa;
			$this->data['decl_comentario_frecuencia'] 	= $decl_comentario_frecuencia;
			$this->data['decl_observacion'] 			= $decl_observacion;
			$this->data['decl_sup_legal'] 				= $decl_sup_legal;

			$this->form_validation->set_rules('decl_expe_id', 'lang:create_exp_validation_name_label', 'required|alpha_dash');
			$this->form_validation->set_rules('decl_nro_declaracion', 'lang:create_exp_validation_name_label', 'required|alpha_dash');
			$this->form_validation->set_rules('decl_gestion_declaracion', 'lang:create_exp_validation_name_label', 'required|alpha_dash');

				$this->data['expe_id_expediente'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_id_expediente',
					'id'       => 'expe_id_expediente',
					'value'    => $expe_id_expediente
				);
				$this->data['expe_gestion'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_gestion',
					'id'       => 'expe_gestion',
					'value'    => $expe_gestion
				);
				$this->data['expe_id'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_id',
					'id'       => 'expe_id',
					'value'    => $expe_id
				);
				$this->data['expe_estado'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_estado',
					'id'       => 'expe_estado',
					'value'    => $expe_estado
				);
				$this->data['expe_tipo_ref'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_tipo_ref',
					'id'       => 'expe_tipo_ref',
					'value'    => $expe_tipo_ref
				);						
				/* LICENCIAS */
				$this->data['decl_expe_id'] = array(
					'type'     => 'number',
					'name'     => 'decl_expe_id',
					'id'       => 'decl_expe_id',
					'value'    => $this->form_validation->set_value('decl_expe_id', $decl_expe_id),
					'class'    => 'form-control',
					'maxlength'=> '10',
					'readonly' => TRUE
				);			
				$this->data['decl_nro_declaracion'] = array(
					'type'     => 'number',
					'name'     => 'decl_nro_declaracion',
					'id'       => 'decl_nro_declaracion',
					'value'    => $this->form_validation->set_value('decl_nro_declaracion',$decl_nro_declaracion),
					'class'    => 'form-control',
					'maxlength'=> '10'
				);
				$this->data['decl_gestion_declaracion'] = array(
					'type'     => 'number',
					'name'     => 'decl_gestion_declaracion',
					'id'       => 'decl_gestion_declaracion',
					'value'    => $this->form_validation->set_value('decl_gestion_declaracion', $decl_gestion_declaracion),
					'class'    => 'form-control',
					'onkeyup'  => 'limit_dig(this.id,4)'
				);
				$this->data['decl_tipo_ref'] = array(
					'type'     => 'text',
					'name'     => 'decl_tipo_ref',
					'id'       => 'decl_tipo_ref',
					'value'    => $this->form_validation->set_value('decl_tipo_ref', $decl_tipo_ref),
					'class'    => 'form-control',
					'readonly' => TRUE
				);	
				$date = new DateTime($decl_fecha_declaracion);
				$newdate = utf8_decode($date->format('d-m-Y'));
				$this->data['decl_fecha_declaracion'] = array(
					'type'     => 'text',
					'name'     => 'decl_fecha_declaracion',
					'id'       => 'decl_fecha_declaracion',
					'value'    => $this->form_validation->set_value('decl_fecha_declaracion', $newdate),
					'class'    => 'form-control'
				);	
				/*	
				$this->data['decl_tipo_frecuencia_aa'] = array(
					'type'     => 'text',
					'name'     => 'decl_tipo_frecuencia_aa',
					'id'       => 'decl_tipo_frecuencia_aa',
					'value'    => $this->form_validation->set_value('decl_tipo_frecuencia_aa', $decl_tipo_frecuencia_aa),
					'class'    => 'form-control',
					'list'	   => 'decl_tipo_frecuencia_aa_list',
					'maxlength'=> '10'
				);		
				*/
				$this->data['decl_frecuencia_aa'] = array(
					'type'     => 'number',
					'name'     => 'decl_frecuencia_aa',
					'id'       => 'decl_frecuencia_aa',
					'value'    => $this->form_validation->set_value('decl_frecuencia_aa', $decl_frecuencia_aa),
					'class'    => 'form-control',
					'onkeyup'  => 'limit_dig(this.id,3)'
				);
				
				$date = new DateTime($decl_fecha_proxima_aa);
				$newdate = utf8_decode($date->format('d-m-Y'));
				$this->data['decl_fecha_proxima_aa'] = array(
					'type'     => 'text',
					'name'     => 'decl_fecha_proxima_aa',
					'id'       => 'decl_fecha_proxima_aa',
					'value'    => $this->form_validation->set_value('decl_fecha_proxima_aa', $newdate),
					'class'    => 'form-control' 
				);	
				$this->data['decl_comentario_frecuencia'] = array(
					'type'     => 'text',
					'name'     => 'decl_comentario_frecuencia',
					'id'       => 'decl_comentario_frecuencia',
					'value'    => $this->form_validation->set_value('decl_comentario_frecuencia', $decl_comentario_frecuencia),
					'class'    => 'form-control',
					'maxlength'=> '100'
				);
				$this->data['decl_observacion'] = array(
					'type'     => 'text',
					'name'     => 'decl_observacion',
					'id'       => 'decl_observacion',
					'value'    => $this->form_validation->set_value('decl_observacion', $decl_observacion),
					'class'    => 'form-control',
					'maxlength'=> '100'
				);
				$this->data['decl_sup_legal'] = array(
					'type'     => 'text',
					'name'     => 'decl_sup_legal',
					'id'       => 'decl_sup_legal',
					'value'    => $this->form_validation->set_value('decl_sup_legal', $decl_sup_legal),
					'class'    => 'form-control',
					'maxlength'=> '30'
				);
			

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('man_espacial/proyectos/Licencia', $this->data);
		}
	}

	public function expe_resolucion($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Licencia', 'expedientes/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();



	        $proyecto_datos = $this->expedientes_model->view('proyectos', array('gid' => $expe_id))->row();

	        $_SESSION['identificador'] = $proyecto_datos->gid;
	        $_SESSION['tipo_estudio'] = $proyecto_datos->tipo_estudio;
	        $_SESSION['estado'] = $proyecto_datos->estado;

	        
	        $expe_tipo_ref      = $proyecto_datos->tipo_estudio;
	        $expe_id_expediente = $proyecto_datos->gid;
	        $expe_gestion		= $proyecto_datos->exp_gestion;
	        $expe_estado		= $proyecto_datos->estado;	  
	        $expe_id_ref        = $proyecto_datos->gid;
	        $expe_id            = $proyecto_datos->gid;


	        IF (isset($proyecto_datos->tipo_estudio) or isset($expe_tipo_ref)) { 
				$expe_tipo_ref = '0';
				$_SESSION['tipo_estudio'] = '0';	        
			} else { 
				$expe_tipo_ref				= $proyecto_datos->tipo_estudio; 
				$_SESSION['tipo_estudio'] 	= $proyecto_datos->tipo_estudio; 
			}

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";   

			$expe_info  = $this->expedientes_model->view('proyectos', array('gid' => $expe_id))->result_array();	

			/************* CANTIDAD DATOS LICENCIA ****************/

			$licencia = $this->expedientes_model->view('declaraciones', array('decl_expe_id' => $expe_id))->result_array();

			if ($licencia) {

				//$licencia[0]["des_tipo_frecuencia_aa"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_FRECUENCIA_AA', 'concepto' => $licencia[0]["decl_tipo_frecuencia_aa"]));


				//$licencia[0]["des_decl_tipo_ref"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $licencia[0]["decl_tipo_ref"]));

				$licencia[0]["des_tipo_frecuencia_aa"] = '0';


				$licencia[0]["des_decl_tipo_ref"] = '0';


			}
			else {
				$licencia[0]['decl_expe_id'] 				= 0;
				$licencia[0]['decl_nro_declaracion']		= '';
				$licencia[0]['decl_gestion_declaracion']	= 0;
				$licencia[0]['decl_tipo_ref']				= '';
				$licencia[0]['decl_fecha_declaracion']		= '';
				$licencia[0]['decl_tipo_frecuencia_aa']		= '';
				$licencia[0]['decl_frecuencia_aa']			= 0;
				$licencia[0]['decl_fecha_proxima_aa']		= '';
				$licencia[0]['decl_comentario_frecuencia']	= '';
				$licencia[0]['decl_observacion']			= '';
				$licencia[0]["des_tipo_frecuencia_aa"] 		= '';
				$licencia[0]["des_decl_tipo_ref"] 			= '';

			}


			$decl_expe_id 					= $licencia[0]['decl_expe_id'];
			$decl_nro_declaracion 			= $licencia[0]['decl_nro_declaracion'];
			$decl_gestion_declaracion 		= $licencia[0]['decl_gestion_declaracion'];
			$decl_tipo_ref 					= $licencia[0]['decl_tipo_ref'];
			$decl_fecha_declaracion 		= $licencia[0]['decl_fecha_declaracion'];
			$decl_tipo_frecuencia_aa 		= $licencia[0]['decl_tipo_frecuencia_aa'];
			$decl_frecuencia_aa 			= $licencia[0]['decl_frecuencia_aa'];
			$decl_fecha_proxima_aa 			= $licencia[0]['decl_fecha_proxima_aa'];
			$decl_comentario_frecuencia 	= $licencia[0]['decl_comentario_frecuencia'];
			$decl_observacion 				= $licencia[0]['decl_observacion'];
			$des_tipo_frecuencia_aa 		= $licencia[0]["des_tipo_frecuencia_aa"];
			$des_decl_tipo_ref 				= $licencia[0]["des_decl_tipo_ref"];
			

			/************* FIN CANTIDAD DATOS LICENCIA ****************/
        	

        	$this->data['decl_expe_id'] 	= $expe_id;

			$this->data['expe_info'] 		= $expe_info;

			//$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['licencia'] 		= $licencia;


			$this->data['decl_expe_id'] 				= $decl_expe_id;
			$this->data['decl_nro_declaracion'] 		= $decl_nro_declaracion;
			$this->data['decl_gestion_declaracion'] 	= $decl_gestion_declaracion;
			$this->data['decl_tipo_ref'] 				= $decl_tipo_ref;
			$this->data['decl_fecha_declaracion'] 		= $decl_fecha_declaracion;
			$this->data['decl_tipo_frecuencia_aa'] 		= $decl_tipo_frecuencia_aa;
			$this->data['decl_frecuencia_aa'] 			= $decl_frecuencia_aa;
			$this->data['decl_fecha_proxima_aa'] 		= $decl_fecha_proxima_aa;
			$this->data['decl_comentario_frecuencia'] 	= $decl_comentario_frecuencia;
			$this->data['decl_observacion'] 			= $decl_observacion;	
			$this->data['des_tipo_frecuencia_aa'] 		= $des_tipo_frecuencia_aa;
			$this->data['des_decl_tipo_ref'] 			= $des_decl_tipo_ref;

			//--------------------------------------------------------------------------

			$resolucion = $this->expedientes_model->view('resoluciones', array('reso_expe_id' => $expe_id))->result_array();

			if ($resolucion) {

				$resolucion[0]["des_vige_tipo_frecuencia_aa"] = '';
			}
			else {
				$resolucion[0]['reso_expe_id'] 					= 0;
				$resolucion[0]['reso_decl_id'] 					= 0;
				$resolucion[0]['reso_nro_resolucion']			= '';
				$resolucion[0]['reso_gestion_resolucion']		= 0;
				$resolucion[0]['reso_tipo_ref']					= '';
				$resolucion[0]['reso_fecha_resolucion']			= '';
				$resolucion[0]['vige_tipo_frecuencia_aa']		= '';
				$resolucion[0]['vige_frecuencia_aa']			= 0;
				$resolucion[0]['vige_fecha_proxima_aa']			= '';
				$resolucion[0]['reso_comentario_frecuencia']	= '';
				$resolucion[0]['reso_observacion']				= '';
				$resolucion[0]["des_vige_tipo_frecuencia_aa"] 	= '';
				$resolucion[0]["reso_sup_legal"] 				= '';
			}


			$reso_expe_id 					= $resolucion[0]['reso_expe_id'];
			$reso_decl_id 					= $resolucion[0]['reso_decl_id'];
			$reso_nro_resolucion 			= $resolucion[0]['reso_nro_resolucion'];
			$reso_gestion_resolucion 		= $resolucion[0]['reso_gestion_resolucion'];
			$reso_tipo_ref 					= $resolucion[0]['reso_tipo_ref'];
			$reso_fecha_resolucion 			= $resolucion[0]['reso_fecha_resolucion'];
			$vige_tipo_frecuencia_aa 		= $resolucion[0]['vige_tipo_frecuencia_aa'];
			$vige_frecuencia_aa 			= $resolucion[0]['vige_frecuencia_aa'];
			$vige_fecha_proxima_aa 			= $resolucion[0]['vige_fecha_proxima_aa'];
			$reso_comentario_frecuencia 	= $resolucion[0]['reso_comentario_frecuencia'];
			$reso_observacion 				= $resolucion[0]['reso_observacion'];
			$des_vige_tipo_frecuencia_aa 	= $resolucion[0]["des_vige_tipo_frecuencia_aa"];
			$reso_sup_legal 				= $resolucion[0]["reso_sup_legal"];
			

			/************* FIN CANTIDAD DATOS LICENCIA ****************/
        	


			$this->data['resolucion'] 		= $resolucion;


			$this->data['reso_expe_id'] 				= $reso_expe_id;
			$this->data['reso_decl_id'] 				= $reso_decl_id;
			$this->data['reso_nro_resolucion'] 			= $reso_nro_resolucion;
			$this->data['reso_gestion_resolucion'] 		= $reso_gestion_resolucion;
			$this->data['reso_tipo_ref'] 				= $reso_tipo_ref;
			$this->data['reso_fecha_resolucion'] 		= $reso_fecha_resolucion;
			$this->data['vige_tipo_frecuencia_aa'] 		= $vige_tipo_frecuencia_aa;
			$this->data['vige_frecuencia_aa'] 			= $vige_frecuencia_aa;
			$this->data['vige_fecha_proxima_aa'] 		= $vige_fecha_proxima_aa;
			$this->data['reso_comentario_frecuencia'] 	= $reso_comentario_frecuencia;
			$this->data['reso_observacion'] 			= $reso_observacion;	
			$this->data['des_vige_tipo_frecuencia_aa'] 	= $des_vige_tipo_frecuencia_aa;	
			$this->data['reso_sup_legal'] 				= $reso_sup_legal;	




			$this->form_validation->set_rules('decl_expe_id', 'lang:create_exp_validation_name_label', 'required|alpha_dash');
			$this->form_validation->set_rules('decl_nro_declaracion', 'lang:create_exp_validation_name_label', 'required|alpha_dash');
			$this->form_validation->set_rules('decl_gestion_declaracion', 'lang:create_exp_validation_name_label', 'required|alpha_dash');


				$this->data['expe_id_expediente'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_id_expediente',
					'id'       => 'expe_id_expediente',
					'value'    => $expe_id_expediente
				);
				$this->data['expe_gestion'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_gestion',
					'id'       => 'expe_gestion',
					'value'    => $expe_gestion
				);
				$this->data['expe_id'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_id',
					'id'       => 'expe_id',
					'value'    => $expe_id
				);
				$this->data['expe_estado'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_estado',
					'id'       => 'expe_estado',
					'value'    => $expe_estado
				);
				$this->data['expe_tipo_ref'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_tipo_ref',
					'id'       => 'expe_tipo_ref',
					'value'    => $expe_tipo_ref
				);	
				$this->data['expe_id_ref'] = array(
					'type'     => 'hidden',
					'name'     => 'expe_id_ref',
					'id'       => 'expe_id_ref',
					'value'    => $expe_id_ref
				);

				/* LICENCIAS */
				$this->data['reso_expe_id'] = array(
					'type'     => 'number',
					'name'     => 'reso_expe_id',
					'id'       => 'reso_expe_id',
					'value'    => $this->form_validation->set_value('reso_expe_id', $reso_expe_id),
					'class'    => 'form-control',
					'maxlength'=> '10',
					'readonly' => TRUE
				);	
				$this->data['reso_decl_id'] = array(
					'type'     => 'number',
					'name'     => 'reso_decl_id',
					'id'       => 'reso_decl_id',
					'value'    => $this->form_validation->set_value('reso_decl_id', $reso_decl_id),
					'class'    => 'form-control',
					'maxlength'=> '10',
					'readonly' => TRUE
				);							
				$this->data['reso_nro_resolucion'] = array(
					'type'     => 'number',
					'name'     => 'reso_nro_resolucion',
					'id'       => 'reso_nro_resolucion',
					'value'    => $this->form_validation->set_value('reso_nro_resolucion',$reso_nro_resolucion),
					'class'    => 'form-control',
					'maxlength'=> '10'
				);


				$this->data['reso_gestion_resolucion'] = array(
					'type'     => 'number',
					'name'     => 'reso_gestion_resolucion',
					'id'       => 'reso_gestion_resolucion',
					'value'    => $this->form_validation->set_value('reso_gestion_resolucion', $reso_gestion_resolucion),
					'class'    => 'form-control',
					'onkeyup'  => 'limit_dig(this.id,4)'
				);
				$this->data['reso_tipo_ref'] = array(
					'type'     => 'text',
					'name'     => 'reso_tipo_ref',
					'id'       => 'reso_tipo_ref',
					'value'    => $this->form_validation->set_value('reso_tipo_ref', $reso_tipo_ref),
					'class'    => 'form-control',
					'readonly' => TRUE
				);	
				$date = new DateTime($reso_fecha_resolucion);
				$newdate = utf8_decode($date->format('d-m-Y'));
				$this->data['reso_fecha_resolucion'] = array(
					'type'     => 'text',
					'name'     => 'reso_fecha_resolucion',
					'id'       => 'reso_fecha_resolucion',
					'value'    => $this->form_validation->set_value('reso_fecha_resolucion', $newdate),
					'class'    => 'form-control'
				);		
				/*
				$this->data['decl_tipo_frecuencia_aa'] = array(
					'type'     => 'text',
					'name'     => 'decl_tipo_frecuencia_aa',
					'id'       => 'decl_tipo_frecuencia_aa',
					'value'    => $this->form_validation->set_value('decl_tipo_frecuencia_aa', $decl_tipo_frecuencia_aa),
					'class'    => 'form-control',
					'list'	   => 'decl_tipo_frecuencia_aa_list',
					'maxlength'=> '10'
				);
				*/	

				$this->data['vige_frecuencia_aa'] = array(
					'type'     => 'number',
					'name'     => 'vige_frecuencia_aa',
					'id'       => 'vige_frecuencia_aa',
					'value'    => $this->form_validation->set_value('vige_frecuencia_aa', $vige_frecuencia_aa),
					'class'    => 'form-control',
					'onkeyup'  => 'limit_dig(this.id,3)'
				);
				$date = new DateTime($vige_fecha_proxima_aa);
				$newdate = utf8_decode($date->format('d-m-Y'));
				$this->data['vige_fecha_proxima_aa'] = array(
					'type'     => 'text',
					'name'     => 'vige_fecha_proxima_aa',
					'id'       => 'vige_fecha_proxima_aa',
					'value'    => $this->form_validation->set_value('vige_fecha_proxima_aa', $newdate),
					'class'    => 'form-control'
				);	
				$this->data['reso_comentario_frecuencia'] = array(
					'type'     => 'text',
					'name'     => 'reso_comentario_frecuencia',
					'id'       => 'reso_comentario_frecuencia',
					'value'    => $this->form_validation->set_value('reso_comentario_frecuencia', $reso_comentario_frecuencia),
					'class'    => 'form-control',
					'maxlength'=> '100'
				);
				$this->data['reso_observacion'] = array(
					'type'     => 'text',
					'name'     => 'reso_observacion',
					'id'       => 'reso_observacion',
					'value'    => $this->form_validation->set_value('reso_observacion', $reso_observacion),
					'class'    => 'form-control',
					'maxlength'=> '100'
				);
				$this->data['reso_sup_legal'] = array(
					'type'     => 'text',
					'name'     => 'reso_sup_legal',
					'id'       => 'reso_sup_legal',
					'value'    => $this->form_validation->set_value('reso_sup_legal', $reso_sup_legal),
					'class'    => 'form-control',
					'maxlength'=> '33'
				);
			
				$frecuencias[''] = 'Seleccione el Tipo Frecuencia';
				$frecuencia = $this->expedientes_model->dropdown_data('conceptos',array('tipoconcepto' => 'TIPO_FRECUENCIA_AA'))->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
				foreach ($frecuencia as $frec) {
					$frecuencias[$frec['concepto']] = $frec['concepto'].' - '.$frec['nombre'];
				}
				$this->data['vige_tipo_frecuencia_aa'] = $frecuencias;
				$this->data['vige_tipo_frecuencia_aa_sel'] = $vige_tipo_frecuencia_aa;

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('man_espacial/proyectos/resolucion', $this->data);
		}
	}



	public function eliminar_geometrias($exp = NULL, $gest = NULL, $expe_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->expedientes_model->eliminar_geometrias($exp,$gest,$expe_id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('expedientes/Licencia/expe_licencia/'.$expe_id);
		
	}



	public function eliminar_licencia($expe_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->expedientes_model->eliminar_licencia($expe_id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS DE LICENCIA DE ELIMINARON!');
		redirect('man_espacial/proyectos/Licencia/expe_licencia/'.$expe_id);
		
	}

	public function eliminar_resolucion($expe_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->expedientes_model->eliminar_resolucion($expe_id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS DE LICENCIA DE ELIMINARON!');
		redirect('man_espacial/proyectos/Licencia/expe_resolucion/'.$expe_id);
		
	}


	public function download_expe($exp = NULL, $gest = NULL, $expe_id = NULL)
	{

        exec('cmd /c "C:\espacio_trabajo\exp_tabla_a_shp.bat postgres Elefante2024i7 '.trim($expe_id).'"');	

        $download_file = "expe".$expe_id.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('man_espacial/proyectos/Licencia/expe_licencia/'.$expe_id);
		
	}

	public function actualizar_licencia()
	{


		$id_expediente 	= $_SESSION['identificador'];
		$expe_id 		= $_SESSION['identificador'];
		$expe_estado 	= $_SESSION['estado'];
		$expe_tipo_ref 	= $_SESSION['tipo_estudio'];
		//$expe_id_ref 	= $_POST['expe_id_ref'];

        $decl_expe_id 				= $expe_id;
        $decl_nro_declaracion 		= $_POST['decl_nro_declaracion'];
        $decl_gestion_declaracion 	= $_POST['decl_gestion_declaracion'];
        $decl_tipo_ref			 	= $_SESSION['tipo_estudio'];
        $decl_fecha_declaracion 	= $_POST['decl_fecha_declaracion'];
        //$decl_comentario_frecuencia = $_POST['decl_comentario_frecuencia'];
        $decl_observacion 			= $_POST['decl_observacion'];
        //$decl_tipo_frecuencia_aa 	= $_POST['decl_tipo_frecuencia_aa'];
        //$decl_frecuencia_aa 		= $_POST['decl_frecuencia_aa'];
        $decl_fecha_proxima_aa 		= $_POST['decl_fecha_proxima_aa'];
        //$decl_sup_legal 			= $_POST['decl_sup_legal'];

        $datos_update['decl_expe_id']				= $expe_id;
        $datos_update['decl_nro_declaracion'] 		= $_POST['decl_nro_declaracion'];
        $datos_update['decl_gestion_declaracion'] 	= $_POST['decl_gestion_declaracion'];
        $datos_update['decl_tipo_ref']			 	= $_SESSION['tipo_estudio'];

		if (isset( $_SESSION['tipo_estudio'])){
			$datos_update['decl_tipo_ref'] = '0';
		}else{
			$datos_update['decl_tipo_ref'] = intval($_SESSION['tipo_estudio']);
		}

        $datos_update['decl_fecha_declaracion'] 	= $_POST['decl_fecha_declaracion'];        
        $datos_update['decl_observacion'] 			= $_POST['decl_observacion'];
        $datos_update['decl_fecha_proxima_aa'] 		= $_POST['decl_fecha_proxima_aa'];
        
        //CAMPOS SIN USO
        $datos_update['decl_comentario_frecuencia'] = '';
        $datos_update['decl_tipo_frecuencia_aa'] 	= 0;
        $datos_update['decl_frecuencia_aa'] 		= 0;        
        $datos_update['decl_sup_legal'] 			= 0.0;

		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		

		// pregunta sin existen datos graficos del expediente.
		$cnt_grafico = $this->expedientes_model->f_existe_grafico_expe_id($expe_id);

		$cnt_licencia = $this->expedientes_model->f_existe_licencia_expe_id($expe_id);

		//echo($cnt_licencia);
		//show_error(1);

		if ($cnt_grafico=0) {
			$this->session->set_flashdata('message', 'Expediente sin Datos espaciales!!');
			redirect('man_espacial/proyectos/licencia/expe_licencia/'.$_POST['expe_id']);
		}
		else { 		

			if ($cnt_licencia>0) {
				$actu = $this->expedientes_model->actualizar_licencia($expe_id, $datos_update);	
				
				$this->session->set_flashdata('message', 'Actualizacion Realizada!');
				redirect('man_espacial/proyectos/licencia/expe_licencia/'.$_POST['expe_id']);
			}
			else { 		

		        $datos_update['decl_tipo_frecuencia_aa_inicial'] 	= 0;
        		$datos_update['decl_frecuencia_aa_inicial'] 		= 0;
        		$datos_update['decl_fecha_proxima_aa_inicial'] 		= '01-01-0001';
        		//$datos_update['decl_fecha_proxima_aa_inicial'] 	  = 'NULL';
        		$datos_update['decl_sup_legal'] 					= 0.0;


				$actu = $this->expedientes_model->crear_licencia($datos_update);	

				if ($actu) {
					$this->session->set_flashdata('message', '¡Actualización Realizada!');
					redirect('man_espacial/proyectos/licencia/expe_licencia/'.$_POST['expe_id']);
				}
				else { 	
					$this->session->set_flashdata('message', '¡No actualizo!');		
					redirect('man_espacial/proyectos/licencia/expe_licencia/'.$_POST['expe_id']);
				}
			}
		}
	}

	public function actualizar_resolucion()
	{


		$id_expediente 	= $_SESSION['identificador'];
		$expe_id 		= $_SESSION['identificador'];
		$expe_estado 	= $_SESSION['estado'];
		$expe_tipo_ref 	= $_SESSION['tipo_estudio'];



		//$gestion 		= $_POST['expe_gestion'];

		if ($_POST['expe_id_ref'] != NULL) {
			$expe_id_ref 	= $_POST['expe_id_ref'];
		}else{
			$expe_id_ref 	= '0';
		}

        $reso_expe_id 				= $_SESSION['identificador'];
        $reso_decl_id				= $_SESSION['identificador'];
        $reso_nro_resolucion 		= $_POST['reso_nro_resolucion'];
        $reso_gestion_resolucion 	= $_POST['reso_gestion_resolucion'];
        $reso_tipo_ref			 	= $expe_tipo_ref;
        $reso_fecha_resolucion	 	= $_POST['reso_fecha_resolucion'];
        //$reso_comentario_frecuencia = $_POST['reso_comentario_frecuencia'];
        $reso_observacion 			= $_POST['reso_observacion'];
        //$vige_tipo_frecuencia_aa 	= $_POST['vige_tipo_frecuencia_aa'];
        //$vige_frecuencia_aa 		= $_POST['vige_frecuencia_aa'];
        $vige_fecha_proxima_aa 		= $_POST['vige_fecha_proxima_aa'];
        //$reso_sup_legal 			= $_POST['reso_sup_legal'];


        $datos_update['reso_expe_id'] 				= $expe_id;
        $datos_update['reso_decl_id']				= $expe_id_ref;
        $datos_update['reso_nro_resolucion'] 		= (integer)$_POST['reso_nro_resolucion'];
        $datos_update['reso_gestion_resolucion'] 	= (integer)$_POST['reso_gestion_resolucion'];
        $datos_update['reso_tipo_ref']			 	= $expe_tipo_ref;
        $datos_update['reso_fecha_resolucion']	 	= $_POST['reso_fecha_resolucion'];
        //$datos_update['reso_comentario_frecuencia'] = $_POST['reso_comentario_frecuencia'];
        $datos_update['reso_observacion'] 			= $_POST['reso_observacion'];
        $datos_update['vige_tipo_frecuencia_aa'] 	= '0';
        $datos_update['vige_frecuencia_aa'] 		= '0';
        $datos_update['vige_fecha_proxima_aa'] 		= $_POST['vige_fecha_proxima_aa'];
        //$datos_update['reso_sup_legal'] 			= $_POST['reso_sup_legal'];

     	$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		


		// pregunta sin existen datos graficos del expediente.
		//$cnt_grafico = $this->expedientes_model->f_existe_grafico_expe_id($expe_id);
		$cnt_grafico = 1;

		$cnt_licencia = $this->expedientes_model->f_existe_resolucion_expe_id($expe_id);

		//echo($cnt_licencia);
		//show_error(1);

		if ($cnt_grafico=0) {
			$this->session->set_flashdata('message', 'Expediente sin Datos espaciales!!');
			redirect('man_espacial/proyectos/licencia/expe_resolucion/'.$_POST['expe_id']);
		}
		else { 		



			if (isset( $_SESSION['tipo_estudio'])){
				$datos_update['reso_tipo_ref'] = '0';
			}else{
				$datos_update['reso_tipo_ref'] = intval($_SESSION['tipo_estudio']);
			}

			$reso_decl_id = $_SESSION['identificador'];

			if ($cnt_licencia>0) {
				$actu = $this->expedientes_model->actualizar_resolucion($expe_id, $datos_update);	
				
				$this->session->set_flashdata('message', 'Actualizacion Realizada!');
				redirect('man_espacial/proyectos/licencia/expe_resolucion/'.$_SESSION['identificador']);
			}
			else { 		

		        $datos_update_d['decl_tipo_frecuencia_aa_inicial'] 	= $_POST['vige_tipo_frecuencia_aa'];
        		$datos_update_d['decl_frecuencia_aa_inicial'] 		= $_POST['vige_frecuencia_aa'];
        		$datos_update_d['decl_fecha_proxima_aa_inicial'] 	= $_POST['vige_fecha_proxima_aa'];



				$actu = $this->expedientes_model->crear_resolucion($datos_update);	

				//$actu2 = $this->expedientes_model->actualizar_resolucion($expe_id, $datos_update_d);

				if ($actu) {
					$this->session->set_flashdata('message', '¡Actualización Realizada!');
					redirect('man_espacial/proyectos/licencia/expe_resolucion/'.$_SESSION['identificador']);
				}
				else { 	
					$this->session->set_flashdata('message', '¡No actualizo!');		
					redirect('man_espacial/proyectos//licencia/expe_resolucion/'.$_SESSION['identificador']);
				}
			}
		}
	}




	public function verparcela ($expe_id , $expe_gest) {
	
        	$i_jameuge = "http://217.77.14.121:8065/seamvisor02/index.html?exp=" . $expe_id;
        	$i_jameuge = $i_jameuge . "&gest=" . $expe_gest;

			redirect($i_jameuge);
	}

	public function imprimir_transacion_lic ($expe_id) {
	
        	$i_jameuge = "http://217.77.14.121:8065/seamvisor02/index.html?exp=" . $expe_id;
        	$i_jameuge = $i_jameuge . "";


        	$i_jameuge =  "http://217.77.14.121:8062/i3geo/ferramentas/imprimir/";
        	$i_jameuge = $i_jameuge . "imprimir_A4_transac_licencia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w06/ms4w/Apache/htdocs/i3geo/aplicmap/";
        	$i_jameuge = $i_jameuge . "imprimir_A4_plano_individual&expe_id=" . $expe_id;

			redirect($i_jameuge);
	}



}