<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usos extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('man_espacial/Usos_model');
        $this->lang->load('man_espacial/usos');

        /* Titulo de la pagina :: Common */
		/* Titulo de la pagina :: Common */
        $this->page_title->push(lang('man_espacial/usos/menu_usos'));
        $this->data['pagetitle'] = $this->page_title->show();

			//$_SESSION['arraywhere_aldeas'] 				= NULL;
			//$_SESSION['arraywhere_aldeas_busqueda'] 	= NULL;        
			//$_SESSION['arraywhere_aldeas_busqueda'] 	= NULL;        

        if ($_SESSION['id_modulo'] != 'USOS') {

			$_SESSION['arraywhere_usos'] 		= NULL;
			$_SESSION['arraywhere_usos_busq'] 	= NULL;

			$_SESSION['id_modulo'] = 'USOS';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_usos'), 'admin/usos');
    }
 	

	public function index()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

             if ($_POST) {
             	$arraywhere = NULL;

				if ($_POST['uso']) 
				{
					$arraywhere['uso'] 								= $_POST['uso'];
					$arraywherebusq['lower(uso) like '] 			= '%'.strtolower($_POST['uso']).'%';
				}
				if ($_POST['nombre_uso']) 
				{
					$arraywhere['nombre_uso'] 					= $_POST['nombre_uso'];
					$arraywherebusq['lower(nombre_uso) like '] 			= '%'.strtolower($_POST['nombre_uso']).'%';
				}
				if ($_POST['r']) 
				{
					if (is_numeric($_POST['r'])) {
						$arraywhere['r'] 					= $_POST['r'];
						$arraywherebusq['cast(r as varchar) like '] 	= '%'.$_POST['r'].'%';
					}
				}
				if ($_POST['g']) 
				{
					if (is_numeric($_POST['g'])) {
						$arraywhere['g'] 					= $_POST['g'];
						$arraywherebusq['cast(g as varchar) like '] 	= '%'.$_POST['g'].'%';
					}
				}
				if ($_POST['b']) 
				{
					if (is_numeric($_POST['b'])) {
						$arraywhere['b'] 					= $_POST['b'];
						$arraywherebusq['cast(b as varchar) like '] 	= '%'.$_POST['b'].'%';
					}
				}

				$_SESSION['arraywhere_usos	'] = $arraywhere;
				$_SESSION['arraywhere_usos_busq'] = $arraywherebusq;


				redirect('man_espacial/usos/index');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'index.php/man_espacial/usos/index/',  // url completa de la pagina paginada
				'usos',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_usos_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['usos']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'usos',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_usos_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/usos/index', $this->data);
		}
	}


	//////----------------------------------------//////
	//////                 create()               //////
	//////----------------------------------------//////

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_usos'), 'usos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('r' , 'lang:usos_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('g' , 'lang:usos_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('b' , 'lang:usos_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('nombre_uso', 'lang:usos_nombre_uso', 'required');
	
		if ($this->form_validation->run() == TRUE)
		{			
			if ($this->form_validation->run() == TRUE)
			{
				if ($_POST['nombre_uso']) {
					$arraycampos['nombre_uso']			= $_POST['nombre_uso'];
				}

				if ($_POST['r']) {
					$arraycampos['r']					= $_POST['r'];
				}	

				if ($_POST['g']) {
					$arraycampos['g']					= $_POST['g'];
				}

				if ($_POST['b']) {
					$arraycampos['b']					= $_POST['b'];
				}

				$pref_nombre_uso = substr($_POST['nombre_uso'],0,1);
				$secuencia = $this->Usos_model->obtener_nextval('ema.usos_id_seq');
				$arraycampos['uso']	= $pref_nombre_uso.$secuencia;
				$new_usos_id = $this->Usos_model->create_usos($arraycampos);
				if ($new_usos_id)
				{
					$this->session->set_flashdata('message', $this->ion_auth->messages());
					redirect('man_espacial/usos/index');
				}
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			//creando campos
			$this->data['uso'] = array(
			'type'     => 'text',
			'name'     => 'uso',
			'id'       => 'uso',
			'value'    => $this->form_validation->set_value('uso'),
			//'data-src' => $usos->uso,
			'class'    => 'form-control',
			'disabled'    => true
			);
			 
			$this->data['nombre_uso'] = array(
				'type'     => 'text',
				'name'     => 'nombre_uso',
				'id'       => 'nombre_uso',
				'value'    => $this->form_validation->set_value('nombre_uso'),
				//'data-src' => $usos->nombre_uso,
				'class'    => 'form-control'
			);

			$this->data['r'] = array(
				'type'     => 'text',
				'name'     => 'r',
				'id'       => 'r',
				'value'    => $this->form_validation->set_value('r'),
				//'data-src' => $usos->r,
				'class'    => 'form-control'
			);

			$this->data['g'] = array(
				'type'     => 'text',
				'name'     => 'g',
				'id'       => 'g',
				'value'    => $this->form_validation->set_value('g'),
				//'data-src' => $usos->g,
				'class'    => 'form-control'
			);

			$this->data['b'] = array(
				'type'     => 'text',
				'name'     => 'b',
				'id'       => 'b',
				'value'    => $this->form_validation->set_value('b'),
				//'data-src' => $usos->b,
				'class'    => 'form-control'
			);		

			
			/* Load Template */
			$this->template->admin_render('man_espacial/usos/create', $this->data);
		}
	}

	//////----------------------------------------//////
	//////                 edit()               //////
	//////----------------------------------------//////

	public function edit($uso)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $uso OR empty($uso))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_usos_edit'), 'usos/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$usos = $this->Usos_model->view('usos', array('uso' => $uso))->row();

		/* Validate form input */
		$this->form_validation->set_rules('nombre_uso', $this->lang->line('edit_uso_validation_name_label'), 'required');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{

				if ($_POST['uso']) {
					$arraycampos['uso']					= strtoupper($_POST['uso']);
				}

				if ($_POST['nombre_uso']) {
					$arraycampos['nombre_uso']			= $_POST['nombre_uso'];
				}

				if ($_POST['r']) {
					$arraycampos['r']					= $_POST['r'];
				}	

				if ($_POST['g']) {
					$arraycampos['g']					= $_POST['g'];
				}

				if ($_POST['b']) {
					$arraycampos['b']					= $_POST['b'];
				}

				$uso_update = $this->Usos_model->update_usos($usos->uso,$arraycampos);

				if ($uso_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('usos_update_successful'));
					redirect('man_espacial/usos/edit/'.$usos->uso); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['usos']   = $usos;
		
		//creando campos
		$this->data['uso'] = array(
			'type'     => 'text',
			'name'     => 'uso',
			'id'       => 'uso',
			'value'    => $this->form_validation->set_value('uso', $usos->uso),
			'data-src' => $usos->uso,
			'class'    => 'form-control',
			'disabled'    => true
		);
		 
		$this->data['nombre_uso'] = array(
			'type'     => 'text',
			'name'     => 'nombre_uso',
			'id'       => 'nombre_uso',
			'value'    => $this->form_validation->set_value('nombre_uso', $usos->nombre_uso),
			'data-src' => $usos->nombre_uso,
			'class'    => 'form-control'
		);

		$this->data['r'] = array(
			'type'     => 'text',
			'name'     => 'r',
			'id'       => 'r',
			'value'    => $this->form_validation->set_value('r', $usos->r),
			'data-src' => $usos->r,
			'class'    => 'form-control'
		);

		$this->data['g'] = array(
			'type'     => 'text',
			'name'     => 'g',
			'id'       => 'g',
			'value'    => $this->form_validation->set_value('g', $usos->g),
			'data-src' => $usos->g,
			'class'    => 'form-control'
		);

		$this->data['b'] = array(
			'type'     => 'text',
			'name'     => 'b',
			'id'       => 'b',
			'value'    => $this->form_validation->set_value('b', $usos->b),
			'data-src' => $usos->b,
			'class'    => 'form-control'
		);		


		/* Load Template */
		$this->template->admin_render('man_espacial/usos/edit', $this->data);
	}

	

	//////----------------------------------------//////
	//////                 delete()               //////
	//////----------------------------------------//////
	public function delete($uso)
	{
		$cnt_reg = $this->Usos_model->cnt_usos_reg_layers($uso);
		if ($cnt_reg == 0) {

			$eliminar_uso = $this->Usos_model->eliminar_usos($uso);
			$this->session->set_flashdata('message', 'Se elimino el Uso! <b>');
			redirect('man_espacial/usos/index/');
		}else{
			$this->session->set_flashdata('message', 'NO se pude eliminar porque tiene registros dependientes! <b>');
			redirect('man_espacial/usos/index/');
		}
	}



	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 
	public function verusos_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/ema/index.html?tipo_consulta=lotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}


	public function generar_usos ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimirema/Mapa_A3_f2_generar_uso_tipo.php";
			redirect($i_jameuge);
	}

	
}