<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tipocapacidad extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('man_espacial/Tipocapacidad_model');
        $this->lang->load('man_espacial/tipocapacidad');

        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('man_espacial/tipocapacidad/menu_tipocapacidad'));
        $this->data['pagetitle'] = $this->page_title->show();

			//$_SESSION['arraywhere_aldeas'] 				= NULL;
			//$_SESSION['arraywhere_aldeas_busqueda'] 	= NULL;        

        if ($_SESSION['id_modulo'] != 'TIPOCAPACIDAD') {

			$_SESSION['arraywhere_tipocapacidad'] 			= NULL;
			$_SESSION['arraywhere_tipocapacidad_busq'] 	= NULL;
			$_SESSION['id_modulo'] = 'TIPOCAPACIDAD';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_tipocapacidad'), 'admin/tipocapacidad');
    }
 	

	public function index()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

             if ($_POST) {

				if ($_POST['tipo']) 
				{
					$arraywhere['tipo'] 								= $_POST['tipo'];
					$arraywherebusq['lower(tipo) like '] 			= '%'.strtolower($_POST['tipo']).'%';
				}
				if ($_POST['nombre_tipo']) 
				{
					$arraywhere['nombre_tipo'] 					= $_POST['nombre_tipo'];
					$arraywherebusq['lower(nombre_tipo) like '] 			= '%'.strtolower($_POST['nombre_tipo']).'%';
				}
				if ($_POST['r']) 
				{
					if (is_numeric($_POST['r'])) {
						$arraywhere['r'] 					= $_POST['r'];
						$arraywherebusq['cast(r as varchar) like '] 	= '%'.$_POST['r'].'%';
					}
				}
				if ($_POST['g']) 
				{
					if (is_numeric($_POST['g'])) {
						$arraywhere['g'] 					= $_POST['g'];
						$arraywherebusq['cast(g as varchar) like '] 	= '%'.$_POST['g'].'%';
					}
				}
				if ($_POST['b']) 
				{
					if (is_numeric($_POST['b'])) {
						$arraywhere['b'] 					= $_POST['b'];
						$arraywherebusq['cast(b as varchar) like '] 	= '%'.$_POST['b'].'%';
					}
				}

				$_SESSION['arraywhere_tipocapacidad	'] = $arraywhere;
				$_SESSION['arraywhere_tipocapacidad_busq'] = $arraywherebusq;


				redirect('man_espacial/tipocapacidad/index');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				8, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'index.php/man_espacial/tipocapacidad/index/',  // url completa de la pagina paginada
				'tipocapacidad',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_tipocapacidad_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['tipocapacidad']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'tipocapacidad',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_tipocapacidad_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/tipocapacidad/index', $this->data);
		}
	}


	//////----------------------------------------//////
	//////                 create()               //////
	//////----------------------------------------//////

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_tipocapacidad'), 'tipocapacidad/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('r' , 'lang:tipocapacidad_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('g' , 'lang:tipocapacidad_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('b' , 'lang:tipocapacidad_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('nombre_tipo', 'lang:tipocapacidad_nombre_tipo', 'required');
	
		if ($this->form_validation->run() == TRUE)
		{			
			if ($this->form_validation->run() == TRUE)
			{
				if ($_POST['nombre_tipo']) {
					$arraycampos['nombre_tipo']			= $_POST['nombre_tipo'];
				}

				if ($_POST['r']) {
					$arraycampos['r']					= $_POST['r'];
				}	

				if ($_POST['g']) {
					$arraycampos['g']					= $_POST['g'];
				}

				if ($_POST['b']) {
					$arraycampos['b']					= $_POST['b'];
				}

				$pref_nombre_tipo = substr($_POST['nombre_tipo'],0,1);
				$secuencia = $this->Tipocapacidad_model->obtener_nextval('ema.tipocapacidad_id_seq');
				$arraycampos['tipo']	= $pref_nombre_tipo.$secuencia;
				$new_tipocapacidad_id = $this->Tipocapacidad_model->create_tipocapacidad($arraycampos);
				if ($new_tipocapacidad_id)
				{
					$this->session->set_flashdata('message', $this->ion_auth->messages());
					redirect('man_espacial/tipocapacidad/index');
				}
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			//creando campos
			$this->data['tipo'] = array(
			'type'     => 'text',
			'name'     => 'tipo',
			'id'       => 'tipo',
			'value'    => $this->form_validation->set_value('tipo'),
			//'data-src' => $tipocapacidad->tipo,
			'class'    => 'form-control',
			'disabled'    => true
			);
			 
			$this->data['nombre_tipo'] = array(
				'type'     => 'text',
				'name'     => 'nombre_tipo',
				'id'       => 'nombre_tipo',
				'value'    => $this->form_validation->set_value('nombre_tipo'),
				//'data-src' => $tipocapacidad->nombre_tipo,
				'class'    => 'form-control'
			);

			$this->data['r'] = array(
				'type'     => 'text',
				'name'     => 'r',
				'id'       => 'r',
				'value'    => $this->form_validation->set_value('r'),
				//'data-src' => $tipocapacidad->r,
				'class'    => 'form-control'
			);

			$this->data['g'] = array(
				'type'     => 'text',
				'name'     => 'g',
				'id'       => 'g',
				'value'    => $this->form_validation->set_value('g'),
				//'data-src' => $tipocapacidad->g,
				'class'    => 'form-control'
			);

			$this->data['b'] = array(
				'type'     => 'text',
				'name'     => 'b',
				'id'       => 'b',
				'value'    => $this->form_validation->set_value('b'),
				//'data-src' => $tipocapacidad->b,
				'class'    => 'form-control'
			);		

			
			/* Load Template */
			$this->template->admin_render('man_espacial/tipocapacidad/create', $this->data);
		}
	}

	//////----------------------------------------//////
	//////                 edit()               //////
	//////----------------------------------------//////

	public function edit($tipo)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $tipo OR empty($tipo))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_tipocapacidad_edit'), 'tipocapacidad/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$tipocapacidad = $this->Tipocapacidad_model->view('tipocapacidad', array('tipo' => $tipo))->row();

		/* Validate form input */
		$this->form_validation->set_rules('nombre_tipo', $this->lang->line('edit_tipo_validation_name_label'), 'required');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{

				if ($_POST['tipo']) {
					$arraycampos['tipo']					= strtoupper($_POST['tipo']);
				}

				if ($_POST['nombre_tipo']) {
					$arraycampos['nombre_tipo']			= $_POST['nombre_tipo'];
				}

				if ($_POST['r']) {
					$arraycampos['r']					= $_POST['r'];
				}	

				if ($_POST['g']) {
					$arraycampos['g']					= $_POST['g'];
				}

				if ($_POST['b']) {
					$arraycampos['b']					= $_POST['b'];
				}

				$tipo_update = $this->Tipocapacidad_model->update_tipocapacidad($tipocapacidad->tipo,$arraycampos);

				if ($tipo_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('tipocapacidad_update_successful'));
					redirect('man_espacial/tipocapacidad/edit/'.$tipocapacidad->tipo); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['tipocapacidad']   = $tipocapacidad;
		
		//creando campos
		$this->data['tipo'] = array(
			'type'     => 'text',
			'name'     => 'tipo',
			'id'       => 'tipo',
			'value'    => $this->form_validation->set_value('tipo', $tipocapacidad->tipo),
			'data-src' => $tipocapacidad->tipo,
			'class'    => 'form-control',
			'disabled'    => true
		);
		 
		$this->data['nombre_tipo'] = array(
			'type'     => 'text',
			'name'     => 'nombre_tipo',
			'id'       => 'nombre_tipo',
			'value'    => $this->form_validation->set_value('nombre_tipo', $tipocapacidad->nombre_tipo),
			'data-src' => $tipocapacidad->nombre_tipo,
			'class'    => 'form-control'
		);

		$this->data['r'] = array(
			'type'     => 'text',
			'name'     => 'r',
			'id'       => 'r',
			'value'    => $this->form_validation->set_value('r', $tipocapacidad->r),
			'data-src' => $tipocapacidad->r,
			'class'    => 'form-control'
		);

		$this->data['g'] = array(
			'type'     => 'text',
			'name'     => 'g',
			'id'       => 'g',
			'value'    => $this->form_validation->set_value('g', $tipocapacidad->g),
			'data-src' => $tipocapacidad->g,
			'class'    => 'form-control'
		);

		$this->data['b'] = array(
			'type'     => 'text',
			'name'     => 'b',
			'id'       => 'b',
			'value'    => $this->form_validation->set_value('b', $tipocapacidad->b),
			'data-src' => $tipocapacidad->b,
			'class'    => 'form-control'
		);		


		/* Load Template */
		$this->template->admin_render('man_espacial/tipocapacidad/edit', $this->data);
	}

	

	//////----------------------------------------//////
	//////                 delete()               //////
	//////----------------------------------------//////
	public function delete($tipo)
	{
		$cnt_reg = $this->Tipocapacidad_model->cnt_tipocapacidad_reg_layers($tipo);
		if ($cnt_reg == 0) {

			$eliminar_tipo = $this->Tipocapacidad_model->eliminar_tipocapacidad($tipo);
			$this->session->set_flashdata('message', 'Se elimino el tipo! <b>');
			redirect('man_espacial/tipocapacidad/index/');
		}else{
			$this->session->set_flashdata('message', 'NO se pude eliminar porque tiene registros dependientes! <b>');
			redirect('man_espacial/tipocapacidad/index/');
		}
	}



	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 
	public function vertipocapacidad_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/byavisor2/index.html?tipo_consulta=lotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	public function generar_tipocapacidad ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimirema/Mapa_A3_f2_generar_tipocapacidad.php";
			redirect($i_jameuge);
	}
	
}