<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Grupos extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('grupos2/Grupos_model');
        $this->lang->load('conceptos/conceptos');
        $this->load->library('pagination');
        $_SESSION['id_modulo'] = 'GRUPOS';
        //$this->breadcrumbs->unshift(1, lang('menu_conceptos'), 'grupos/grupos');

    }

    public function index() {
        // Obtener el filtro desde la solicitud (GET)
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        $id_cliente = $this->input->get('id_cliente');

        if (isset($id_cliente)) 
        {
            $id_cliente = 0 ;
        }

        // Configuración de la paginación
        $config = array();
        $config['base_url'] = site_url('grupos2/grupos/index');
        $config['total_rows'] = $this->Grupos_model->count_filtered_groups($id_cliente);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a>';
        $config['cur_tag_close'] = '</a></li>';
        $config['next_link'] = 'Siguiente';
        $config['prev_link'] = 'Anterior';

        $this->pagination->initialize($config);

        // Calcular el offset
        $page = $this->input->get('per_page') ? $this->input->get('per_page') : 0;

        // Obtener los datos del modelo
        $data['grupos'] = $this->Grupos_model->get_filtered_groups($id_cliente, $config['per_page'], $page);
        $data['pagination'] = $this->pagination->create_links();

        // Pasar el filtro para mantenerlo en el formulario
        $data['id_cliente'] = $id_cliente;

        // Cargar la vista
        //$this->load->view('grupos/index', $data);
        $this->template->admin_render('grupos2/index', $this->data);
    }
}