<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

        /* Load :: Common */
        $this->load->helper('number');
        $this->load->model('admin/dashboard_model');
        $_SESSION['id_modulo'] = NULL;
        $_SESSION['id_modulo'] != 'DASHBOARD';
    }

	public function index()
	{

        $_SESSION['url_ci'] = base_url(); 
        /*
        movido a dp_config.php
        application/config/admin/config
        $_SESSION['url_mapserver'] = 'http://localhost:8060/';
        $_SESSION['tipo_plataforma'] = 'desarrollo';
        */
        $largo = strlen(base_url());
        $cadena = substr(base_url(),7); 
        $pos = strpos($cadena,'/');
        $url_server = substr($cadena,0,$pos);        
        $cadena = substr($cadena,$pos+1); 
        $largo = strlen(trim($cadena));
        $nomsistema = substr($cadena,0,$largo-1); 
        $_SESSION['nomsistema'] = $nomsistema; 

        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
            /* Title Page */
            $this->page_title->push(lang('menu_dashboard'));
            $this->data['pagetitle'] = $this->page_title->show();

            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Data */
            $this->data['count_users']       = $this->dashboard_model->get_count_record('users');
            $this->data['count_groups']      = $this->dashboard_model->get_count_record('groups');
            $this->data['disk_totalspace']   = $this->dashboard_model->disk_totalspace(DIRECTORY_SEPARATOR);
            $this->data['disk_freespace']    = $this->dashboard_model->disk_freespace(DIRECTORY_SEPARATOR);
            $this->data['disk_usespace']     = $this->data['disk_totalspace'] - $this->data['disk_freespace'];
            $this->data['disk_usepercent']   = $this->dashboard_model->disk_usepercent(DIRECTORY_SEPARATOR, FALSE);
            $this->data['memory_usage']      = $this->dashboard_model->memory_usage();
            $this->data['memory_peak_usage'] = $this->dashboard_model->memory_peak_usage(TRUE);
            $this->data['memory_usepercent'] = $this->dashboard_model->memory_usepercent(TRUE, FALSE);

            //obtiene todos los grupos pertenecientes a este usuario
            $user_groups = $this->ion_auth->get_users_groups()->result();
            if ($user_groups) {
                foreach ($user_groups as $key => $value) {
                    $_SESSION['user_groups'][] = $value->id;
                }
            }else{
                $_SESSION['user_groups'] = NULL;
            }

            $tipo_usuario = $this->ion_auth->get_users_cliente(); // Aquí ya tienes el tipo de usuario directamente.

            if ($tipo_usuario) {
                $_SESSION['tipo_usuario'] = [$tipo_usuario]; // Guarda el tipo de usuario en el array de sesión.
            } else {
                $_SESSION['tipo_usuario'] = NULL; // Si no existe, establece como NULL.
            }

            $id_cliente = $this->ion_auth->get_users_id_cliente(); // Aquí ya tienes el tipo de usuario directamente.

            if ($id_cliente) {
                $_SESSION['id_cliente'] = [$id_cliente]; // Guarda el tipo de usuario en el array de sesión.
            } else {
                $_SESSION['id_cliente'] = NULL; // Si no existe, establece como NULL.
            }

            $this->data['alertas'] = $this->get_proyectos_por_vencer();
            $this->data['declaraciones_alertas'] = $this->get_declaraciones_por_vencer();
            $this->data['resoluciones_alertas'] = $this->get_resoluciones_por_vencer();
            $this->data['notificaciones'] = $this->get_notificaciones();

            $this->data['tipo_alertas'] = $this->get_tipo_alertas();
            /* TEST */
            $this->data['url_exist']    = is_url_exist('http://www.domprojects.com');


            /* Load Template */
            $this->template->admin_render('admin/dashboard/index', $this->data);
        }
	}
    public function ver_todas_notificaciones() {
        $query = $this->db->query("
            SELECT codigo, mensaje, clase 
            FROM ema.tipo_alertnotific 
            WHERE estado = 'activo'
            ORDER BY codigo DESC
        ");
        
        $this->data['notificaciones_completas'] = $query->result_array();
        
        $this->page_title->push('Todas las Notificaciones');
        $this->data['pagetitle'] = $this->page_title->show();
        
        $this->template->admin_render('admin/dashboard/ver_notificaciones', $this->data);
    }

    public function get_notificaciones() {
        $query = $this->db->query("
            SELECT codigo, mensaje, clase 
            FROM ema.tipo_alertnotific 
            WHERE estado = 'A' 
            ORDER BY codigo DESC 
            LIMIT 6
        ");
    
        return $query->result_array();
    }

    public function get_proyectos_por_vencer() {
        $query = $this->db->query("
            SELECT 
                COUNT(*) AS cantidad_alertas,
                SUM(CASE WHEN fecha_final BETWEEN NOW() AND NOW() + INTERVAL '30 days' THEN 1 ELSE 0 END) AS proximos_vencer,
                SUM(CASE WHEN fecha_final < NOW() THEN 1 ELSE 0 END) AS vencidos
            FROM ema.proyectos;
        ");
    
        return $query->row_array(); // Retorna un array en lugar de un solo valor
    }

    public function get_declaraciones_por_vencer() {
        $query = $this->db->query("
            SELECT 
                COUNT(*) AS cantidad_alertas,
                SUM(CASE WHEN fecha_declaracion_vto BETWEEN NOW() AND NOW() + INTERVAL '30 days' THEN 1 ELSE 0 END) AS proximos_vencer,
                SUM(CASE WHEN fecha_declaracion_vto < NOW() THEN 1 ELSE 0 END) AS vencidos
            FROM ema.declaraciones;
        ");
    
        return $query->row_array(); // Devuelve un array con los datos
    }

    /* public function get_resoluciones_por_vencer() {
        $query = $this->db->query("
            SELECT 
                COUNT(*) AS cantidad_alertas,
                SUM(CASE WHEN fecha_prox_vto_aa BETWEEN NOW() + INTERVAL '120 days' AND NOW() + INTERVAL '180 days' THEN 1 ELSE 0 END) AS alerta_180d_120d,
                SUM(CASE WHEN fecha_prox_vto_aa BETWEEN NOW() + INTERVAL '30 days' AND NOW() + INTERVAL '120 days' THEN 1 ELSE 0 END) AS alerta_120d_30d,
                SUM(CASE WHEN fecha_prox_vto_aa BETWEEN NOW() + INTERVAL '15 days' AND NOW() + INTERVAL '30 days' THEN 1 ELSE 0 END) AS alerta_30d_15d,
                SUM(CASE WHEN fecha_prox_vto_aa BETWEEN NOW() AND NOW() + INTERVAL '15 days' THEN 1 ELSE 0 END) AS alerta_15d_0d,
                SUM(CASE WHEN fecha_prox_vto_aa < NOW() THEN 1 ELSE 0 END) AS vencidos
            FROM ema.resoluciones;

        ");
        
        return $query->row_array(); // Devuelve un array con los datos
    } */


    public function get_resoluciones_por_vencer() {
        $query = $this->db->query("
            SELECT 
                COUNT(*) AS cantidad_alertas,
    
                -- Coincide con ?dia=-180
                SUM(CASE WHEN tipo_alerta = 'VENC_AA' AND clase = 'AUTOMATICA' AND modulo = 'RESOLUCIONES' AND estado = 'Activo' AND dia = -180 THEN 1 ELSE 0 END) AS alerta_180d_120d,
    
                -- Coincide con ?dia=-90
                SUM(CASE WHEN tipo_alerta = 'VENC_AA' AND clase = 'AUTOMATICA' AND modulo = 'RESOLUCIONES' AND estado = 'Activo' AND dia = -90 THEN 1 ELSE 0 END) AS alerta_120d_30d,
    
                -- Coincide con ?dia=-30
                SUM(CASE WHEN tipo_alerta = 'VENC_AA' AND clase = 'AUTOMATICA' AND modulo = 'RESOLUCIONES' AND estado = 'Activo' AND dia = -30 THEN 1 ELSE 0 END) AS alerta_30d_15d,
    
                -- Coincide con ?dia=-15
                SUM(CASE WHEN tipo_alerta = 'VENC_AA' AND clase = 'AUTOMATICA' AND modulo = 'RESOLUCIONES' AND estado = 'Activo' AND dia = -15 THEN 1 ELSE 0 END) AS alerta_15d_0d,
    
                -- Coincide con vencidas (día > 180 o estado diferente)
                SUM(CASE WHEN tipo_alerta = 'VENC_AA' AND clase = 'AUTOMATICA' AND modulo = 'RESOLUCIONES' AND estado = 'Activo' AND dia = 0 THEN 1 ELSE 0 END) AS vencidos
    
            FROM ema.alertnotific
        ");
    
        return $query->row_array(); // Devuelve los datos listos para los contadores
    }


    /* public function get_tipo_alertas() {
    $query = $this->db->query("
        SELECT 
            t.codigo, 
            t.mensaje, 
            t.modulo, 
            t.clase, 
            t.rgb1, 
            t.rgb2, 
            t.rgb3, 
            t.rgb4, 
            t.rgb5,
            COUNT(a.id_alerta) AS total_alertas
        FROM ema.tipo_alertnotific t
        LEFT JOIN ema.alertnotific a 
            ON a.tipo_alerta = t.codigo AND LOWER(a.estado) = 'activo'
        WHERE t.estado = 'ACTIVO'
        GROUP BY t.codigo, t.mensaje, t.modulo, t.clase, t.rgb1, t.rgb2, t.rgb3, t.rgb4, t.rgb5
        ORDER BY t.codigo DESC
    ");

    return $query->result_array();
} */
    public function get_tipo_alertas() {
    $id_cliente = isset($_SESSION['id_cliente']) && is_array($_SESSION['id_cliente']) && isset($_SESSION['id_cliente'][0])
        ? $_SESSION['id_cliente'][0]
        : null;

    $join_cliente = '';
    $filtro_cliente = '';

    if ($id_cliente !== null) {
        $join_cliente = "LEFT JOIN ema.proyectos p ON a.id_proyecto = p.gid";
        $filtro_cliente = "AND p.id_cliente = " . (int) $id_cliente;
    }

    $query = $this->db->query("
        SELECT 
            t.codigo, 
            t.mensaje, 
            t.modulo, 
            t.clase, 
            t.rgb1, 
            t.rgb2, 
            t.rgb3, 
            t.rgb4, 
            t.rgb5,
            COUNT(a.id_alerta) AS total_alertas
        FROM ema.tipo_alertnotific t
        LEFT JOIN ema.alertnotific a 
            ON a.tipo_alerta = t.codigo AND LOWER(a.estado) = 'activo'
        $join_cliente
        WHERE t.estado = 'ACTIVO' 
        $filtro_cliente
        GROUP BY t.codigo, t.mensaje, t.modulo, t.clase, t.rgb1, t.rgb2, t.rgb3, t.rgb4, t.rgb5
        ORDER BY t.codigo DESC
    ");

    return $query->result_array();
}


}
