<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notificaciones extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->database(); // Cargar la base de datos
        $this->load->helper('url'); // Cargar el helper para URLs
    }

    // Obtener todas las notificaciones activas
    public function obtener_notificaciones() {
        $query = $this->db->query("
            SELECT codigo, mensaje, clase 
            FROM ema.tipo_alertnotific 
            WHERE estado = 'A' 
            ORDER BY codigo DESC
        ");

        // Devolver datos en formato JSON para consumir en AJAX
        echo json_encode($query->result_array());
    }

    // Vista para ver todas las notificaciones (si es necesario)
    public function ver_todas() {
        $query = $this->db->query("
            SELECT codigo, mensaje, clase 
            FROM ema.tipo_alertnotific 
            WHERE estado = 'A' 
            ORDER BY codigo DESC
        ");
        
        $data['notificaciones'] = $query->result_array();

        $this->load->view('admin/notificaciones/ver_todas', $data);
    }
}
