<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Chart extends CI_Controller {

	public function __construct() {
    parent::__construct();

    $this->load->database();
    $this->load->library('session'); // Ya maneja la sesión internamente
    header('Content-Type: application/json');
}


    public function get_proyectos_por_distrito_y_fecha() {
        $query = $this->db->query("
            SELECT 
                d.dist_desc AS distrito_nombre,
                DATE_TRUNC('month', p.fecha_inicio)::DATE AS mes,
                COUNT(*) AS total_proyectos
            FROM ema.proyectos p
            LEFT JOIN ide.distritos d
                ON p.distrito = d.distrito AND p.dpto = d.dpto
            GROUP BY distrito_nombre, mes
            ORDER BY distrito_nombre, mes
        ");
    
        $data = $query->result_array();
    
        // Agrupar los datos por nombre del distrito
        $resultado = [];
        foreach ($data as $row) {
            $nombreDistrito = isset($row['distrito_nombre']) ? $row['distrito_nombre'] : 'Distrito desconocido';
            $resultado[$nombreDistrito][] = [
                'mes' => $row['mes'],
                'total' => $row['total_proyectos']
            ];
        }
    
        header('Content-Type: application/json');
        echo json_encode($resultado);
    }
    

    public function get_sales_data_by_state() {
        header("Access-Control-Allow-Origin: *"); // Permitir cualquier origen
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");
    
        // Modificar la consulta para agrupar por estado
        $query = $this->db->query("
            SELECT 
                EXTRACT(YEAR FROM c.fecha_registro) AS year, 
                c.estado, 
                COUNT(*) AS total,
                -- Obtener el nombre del estado desde la tabla conceptos
                (SELECT t.nombre
                 FROM public.conceptos t
                 WHERE t.tipoconcepto = 'PROYECTO_ESTADO' AND t.concepto = c.estado
                 LIMIT 1) AS estado_nombre
            FROM ema.proyectos c
            WHERE c.fecha_registro IS NOT NULL AND c.estado IS NOT NULL
            GROUP BY year, c.estado
            ORDER BY year
        ");
    
        // Obtener el resultado de la consulta
        $result = $query->result_array();
    
        // Manejar compatibilidad con PHP 5
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }

    public function get_tipo_estudio_data() {
        header("Access-Control-Allow-Origin: *"); 
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");

        $query = $this->db->query("
            SELECT tipo_estudio, COUNT(*) AS cantidad
            FROM ema.proyectos
            WHERE tipo_estudio IS NOT NULL
            GROUP BY tipo_estudio
            ORDER BY cantidad DESC
        ");

        echo json_encode($query->result(), JSON_NUMERIC_CHECK);
    }

    public function get_pie_data() {
        header("Access-Control-Allow-Origin: *"); 
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");
        $query = $this->db->query("
            SELECT c.nombre AS estado, COUNT(*) AS total
        FROM ema.proyectos p
        JOIN public.conceptos c 
            ON p.estado = c.concepto 
            AND c.tipoconcepto = 'PROYECTO_ESTADO'
        WHERE p.estado IS NOT NULL 
        AND p.estado <> '' 
        AND tipo_estudio IS NOT NULL
        GROUP BY c.nombre
        ORDER BY total DESC
        ");

        $result = $query->result_array();

        // Manejo de datos para compatibilidad con PHP 5
        echo json_encode($result, JSON_NUMERIC_CHECK);
    }

    public function get_sales_data() {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");
    
        // Consultar todos los años y tipos de estudio existentes en la base de datos
        $query = $this->db->query("
            SELECT 
                EXTRACT(YEAR FROM fecha_registro) AS year, 
                p.tipo_estudio, 
                c.nombre AS tipo_estudio_nombre,  -- Obtenemos el nombre del tipo de estudio
                COUNT(*) AS total
            FROM ema.proyectos p
            LEFT JOIN public.conceptos c ON c.concepto = p.tipo_estudio AND c.tipoconcepto = 'TIPO_ESTUDIO'  -- Relacionamos con la tabla conceptos
            WHERE p.fecha_registro IS NOT NULL AND p.tipo_estudio IS NOT NULL
            GROUP BY year, p.tipo_estudio, c.nombre
            ORDER BY year
        ");
    
        $result = $query->result_array();
    
        // Obtener todas las fechas únicas
        $allYears = [];
        $allTypes = [];
        $structuredData = [];
    
        foreach ($result as $item) {
            $year = $item['year'];
            $tipo = $item['tipo_estudio'];
    
            if (!in_array($year, $allYears)) {
                $allYears[] = $year;
            }
            if (!in_array($tipo, $allTypes)) {
                $allTypes[] = $tipo;
            }
    
            // Guardar la cantidad de proyectos por tipo y año
            $structuredData[$tipo][$year] = $item['total'];
        }
    
        // Asegurar que todos los tipos de estudio tengan datos en cada año
        sort($allYears); // Ordenar años cronológicamente
    
        $formattedData = [];
        foreach ($allTypes as $tipo) {
            $data = [];
    
            foreach ($allYears as $year) {
                // Si el año no tiene datos para este tipo de estudio, asignar 0
                $data[] = isset($structuredData[$tipo][$year]) ? $structuredData[$tipo][$year] : 0;
            }
    
            $formattedData[] = [
                'label' => $item['tipo_estudio_nombre'],  
                'data' => $data,
                'year' => $allYears 
            ];
        }
    
        echo json_encode($formattedData, JSON_NUMERIC_CHECK);
    }  

    public function sector_proyecto() {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");
    
        // Consulta de la base de datos
        $query = $this->db->query("
            SELECT 
                EXTRACT(YEAR FROM fecha_registro) AS year, 
                p.sector_proyecto, 
                c.nombre AS sector_proyecto_nombre,  
                COUNT(*) AS total
            FROM ema.proyectos p
            LEFT JOIN public.conceptos c 
                ON c.concepto = p.sector_proyecto AND c.tipoconcepto = 'SECTORE_PROYECTOS'  
            WHERE p.fecha_registro IS NOT NULL AND p.sector_proyecto IS NOT NULL
            GROUP BY year, p.sector_proyecto, c.nombre
            ORDER BY year
        ");
    
        $result = $query->result_array();
    
        // Obtener todos los años únicos
        $allYears = array_unique(array_column($result, 'year'));
        sort($allYears); // Ordenar los años de menor a mayor
    
        // Estructura para almacenar los sectores correctamente
        $sectorData = [];
    
        foreach ($result as $item) {
            $year = $item['year'];
            $sectorNombre = $item['sector_proyecto_nombre'];
            $total = $item['total'];
    
            // Inicializar el sector si no existe
            if (!isset($sectorData[$sectorNombre])) {
                $sectorData[$sectorNombre] = [
                    'label' => $sectorNombre,
                    'data' => array_fill(0, count($allYears), 0), // Relleno con ceros
                    'year' => $allYears
                ];
            }
    
            // Asignar el total al índice correcto
            $index = array_search($year, $allYears);
            $sectorData[$sectorNombre]['data'][$index] += $total;
        }
    
        // Convertir a formato JSON
        echo json_encode(array_values($sectorData), JSON_NUMERIC_CHECK);
    }
    // 1. Modificar el controlador (Chats.php)
public function tipo_estudio() {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
        header("Content-Type: application/json");

        // Corrección de consulta SQL
        $query = $this->db->query("SELECT 
        EXTRACT(YEAR FROM p.fecha_registro) AS year, 
        TRIM(p.tipo_estudio) AS tipo_estudio, 
        TRIM(COALESCE(c.nombre, 'Desconocido')) AS tipo_estudio_nombre,  
        COUNT(*) AS total
    FROM ema.proyectos p
    LEFT JOIN public.conceptos c 
        ON TRIM(c.concepto) = TRIM(p.tipo_estudio) 
        AND c.tipoconcepto = 'TIPO_ESTUDIO_2'
    WHERE p.fecha_registro IS NOT NULL 
        AND p.tipo_estudio IS NOT NULL
    GROUP BY year, p.tipo_estudio, c.nombre
    ORDER BY year;
            ");

    $result = $query->result_array();

    // Estructura para almacenar los datos del gráfico
    $data = [];
    foreach ($result as $item) {
        $year = $item['year'];
        $tipo_estudio = $item['tipo_estudio_nombre'];
        $total = (int) $item['total'];

        if (!isset($data[$tipo_estudio])) {
            $data[$tipo_estudio] = [
                'label' => $tipo_estudio,
                'data' => [],
                'years' => []
            ];
        }

        $data[$tipo_estudio]['data'][] = $total;
        $data[$tipo_estudio]['years'][] = $year;
    }

    echo json_encode(array_values($data), JSON_NUMERIC_CHECK);
}

public function get_tipo_proyecto_data() {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("Content-Type: application/json");

    // Consulta para obtener datos de tipo_proyecto por año
    $query = $this->db->query("
        SELECT 
            EXTRACT(YEAR FROM p.fecha_registro) AS year, 
            TRIM(p.tipo_proyecto) AS tipo_proyecto, 
            TRIM(COALESCE(c.nombre, 'Desconocido')) AS tipo_proyecto_nombre,  
            COUNT(*) AS total
        FROM ema.proyectos p
        LEFT JOIN public.conceptos c 
            ON TRIM(c.concepto) = TRIM(p.tipo_proyecto) 
            AND c.tipoconcepto = 'TIPO_PROYECTO'
        WHERE p.fecha_registro IS NOT NULL 
            AND p.tipo_proyecto IS NOT NULL
        GROUP BY year, p.tipo_proyecto, c.nombre
        ORDER BY year;
    ");

    $result = $query->result_array();

    // Estructura para almacenar los datos del gráfico
    $data = [];
    foreach ($result as $item) {
        $year = $item['year'];
        $tipo_proyecto = $item['tipo_proyecto_nombre'];
        $total = (int) $item['total'];

        if (!isset($data[$tipo_proyecto])) {
            $data[$tipo_proyecto] = [
                'label' => $tipo_proyecto,
                'data' => [],
                'years' => []
            ];
        }

        $data[$tipo_proyecto]['data'][] = $total;
        $data[$tipo_proyecto]['years'][] = $year;
    }

    echo json_encode(array_values($data), JSON_NUMERIC_CHECK);
}

public function get_proyectos_evaluaciones_data() {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("Content-Type: application/json");

    // Obtener variables de sesión
    $user_id = $this->session->userdata('user_id');
	$tipo_usuario = isset($_SESSION['tipo_usuario'][0]) ? $_SESSION['tipo_usuario'][0] : null;
	$id_cliente = isset($_SESSION['id_cliente'][0]) ? $_SESSION['id_cliente'][0] : null;

    // Construir condición
    $where = "WHERE pe.des_estado IS NOT NULL";
    if ($tipo_usuario === 'C' && $id_cliente) {
        $where .= " AND pe.id_proponente = " . $this->db->escape($id_cliente);
    }

    // Ejecutar consulta
    $query = $this->db->query("
        SELECT TRIM(pe.des_estado) AS des_estado, COUNT(*) AS total 
        FROM ema.proyectos pe 
        $where 
        GROUP BY des_estado;
    ");
    $result = $query->result_array();

    // Definir grupos
    $grupos = [
        '01' => 'Ingreso de Proyecto EMA',
        '02' => 'Mesa de Entrada',
        '03' => 'Dirección DGCCARN - Análisis Técnico inicial',
        '04' => 'Geomática',
        '05' => 'Análisis Técnico',
        '06.1' => 'RIMA (Publicación) - 3 días',
        '06.2' => 'RIMA (WEB) - 10 días hábiles',
        '07' => 'DVIA',
        '08' => 'Dirección General',
        '09' => 'Licencia(DIA)',
        '10' => 'Resoluciones(A.A)'
    ];

    // Agrupar resultados
    $dataAssoc = [];
    foreach ($result as $item) {
        foreach ($grupos as $prefix => $nombreGrupo) {
            if (preg_match('/^' . preg_quote($prefix, '/') . '\b/', $item['des_estado'])) {
                if (!isset($dataAssoc[$nombreGrupo])) {
                    $dataAssoc[$nombreGrupo] = 0;
                }
                $dataAssoc[$nombreGrupo] += (int) $item['total'];
                break;
            }
        }
    }

    // Formar salida final
    $data = [];
    foreach ($grupos as $prefix => $nombreGrupo) {
        if (isset($dataAssoc[$nombreGrupo])) {
            $data[] = [
                'label' => $nombreGrupo,
                'total' => $dataAssoc[$nombreGrupo]
            ];
        }
    }

    echo json_encode($data, JSON_NUMERIC_CHECK);
}

    public function get_proyectos_totales() {
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
    header("Access-Control-Allow-Headers: Content-Type, Authorization");
    header("Content-Type: application/json");

    $user_id = $this->session->userdata('user_id');
    $tipo_usuario = isset($_SESSION['tipo_usuario'][0]) ? $_SESSION['tipo_usuario'][0] : null;
    $id_cliente = isset($_SESSION['id_cliente'][0]) ? $_SESSION['id_cliente'][0] : null;

    $where_proyectos = "";
    $where_evaluaciones = "";
    $where_declaraciones = "";

    if ($tipo_usuario === 'C' && $id_cliente) {
        $escaped_id = $this->db->escape($id_cliente);
        $where_proyectos = "WHERE id_proponente = $escaped_id";
        $where_evaluaciones = "WHERE proyecto_id IN (SELECT gid FROM ema.proyectos WHERE id_proponente = $escaped_id)";
        $where_declaraciones = "WHERE id_proyecto IN (SELECT gid FROM ema.proyectos WHERE id_proponente = $escaped_id)";
    }

    $query = $this->db->query("
        SELECT 
            'Total Proyectos' AS categoria, COUNT(*) AS total 
        FROM ema.proyectos
        $where_proyectos

        UNION ALL

        SELECT 
            'Proyectos en Evaluación' AS categoria, COUNT(DISTINCT proyecto_id) AS total
        FROM ema.proyectos_evaluaciones
        $where_evaluaciones

        UNION ALL

        SELECT 
            'Proyectos con Licencia Ambiental' AS categoria, COUNT(DISTINCT id_proyecto) AS total
        FROM ema.declaraciones
        $where_declaraciones
    ");

    $result = $query->result_array();

    $data = [];
    foreach ($result as $item) {
        $data[] = [
            'label' => $item['categoria'],
            'total' => (int) $item['total']
        ];
    }

    echo json_encode($data, JSON_NUMERIC_CHECK);
}


  
}
?>
