<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px;
        }
        .btn-container .btn {
            margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('message')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('message'); ?>
            </div>
        <?php endif; ?>
    </section>

    <section class="content">
        <div class="container mt-5">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Evaluación de Proyecto</h4>
                </div>
                <div class="card-body">
                    <form action="<?= base_url('proyectos_evaluaciones/views/' . $proyecto['id']) ?>" method="post">
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="proyecto_id">ID del Proyecto</label>
                                <input type="number" class="form-control" name="proyecto_id" id="proyecto_id" value="<?= set_value('proyecto_id', $proyecto['proyecto_id']) ?>" required readonly>
                                <?= form_error('proyecto_id', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="form-group col-md-8">
                                <label for="categoria">Categoría</label>
                                <input type="text" class="form-control" name="categoria" id="categoria" value="<?= set_value('categoria', $proyecto['categoria']) ?>" readonly>
                                <?= form_error('categoria', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="estado">Estado</label>
                                <select name="estado" id="estado" class="form-control" readonly>
                                    <option value="presentado" <?= set_select('estado', 'presentado', $proyecto['estado'] == 'presentado') ?>>Presentado</option>
                                    <option value="aprobado" <?= set_select('estado', 'aprobado', $proyecto['estado'] == 'aprobado') ?>>Aprobado</option>
                                    <option value="rechazado" <?= set_select('estado', 'rechazado', $proyecto['estado'] == 'rechazado') ?>>Rechazado</option>
                                    <option value="no requiere" <?= set_select('estado', 'no requiere', $proyecto['estado'] == 'no requiere') ?>>No Requiere</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="si_no">Aprobado (Sí/No)</label>
                                <select name="si_no" id="si_no" class="form-control" disabled>
                                    <option value="1" <?= set_select('si_no', '1', $proyecto['si_no'] == 1) ?>>Sí</option>
                                    <option value="0" <?= set_select('si_no', '0', $proyecto['si_no'] == 0) ?>>No</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="fecha">Fecha</label>
                                <input type="date" class="form-control" name="fecha" id="fecha" value="<?= set_value('fecha', $proyecto['fecha']) ?>" readonly>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="observaciones">Observaciones</label>
                                <textarea class="form-control" name="observaciones" id="observaciones" rows="3" readonly><?= set_value('observaciones', $proyecto['observaciones']) ?></textarea>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="btn-container">
                               
                                    <a href="<?= base_url('index.php/proyectos_evaluaciones/index/'.$proyecto['proyecto_id']) ?>" class="btn btn-warning">Volver</a>
                                    
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                </div>
            </div>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
