<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>

    <div class="content-wrapper">
        <section class="content-header">
        </section>

        <section class="content">
            
            <div class="container mt-5">
            <?php
            echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
            ?>
                <h1 class="mb-4"><?php echo $pagetitle; ?></h1>
                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?>
                
               
                <?php
                } else {  
                ?>
                <a href="<?= site_url('proyectos_evaluaciones/create/'.$proyecto_id) ?>" class="btn btn-block btn-primary btn-flat">
                    <i class="fa fa-plus"></i> Crear Evaluación
                </a>
                <?php
                    } 
                ?>
                <div class="table-container mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>ID Proyecto</th>
                                    <th>Categoría</th>
                                    <th>Estado</th>
                                    <th>¿Aprobado?</th>
                                    <th>Fecha</th>
                                    <th>Observaciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($proyectos_evaluaciones as $row): ?>
                                    <?php
                                        // Mapeo de los estados numéricos a sus palabras correspondientes
                                        $estado_map = [
                                            0 => 'No requiere',
                                            1 => 'Presentado',
                                            2 => 'Aprobado',
                                            3 => 'Rechazado'
                                        ];

                                        // Obtener el estado en forma de palabra dependiendo del número
                                        $estado_palabra = isset($estado_map[$row->estado]) ? $estado_map[$row->estado] : 'Desconocido'; // Por defecto "Desconocido" si no hay coincidencia
                                    ?>
                                    <tr>
                                        <td>
                                            <?php 
                                                $user_id = $this->session->userdata('user_id');
                                                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                                $id_cliente = $_SESSION['id_cliente'][0];
                                                if ($tipo_usuario == 'C') { 
                                            ?>
                                            <a href="<?= site_url('proyectos_evaluaciones/views/'.$row->id.'/'.$proyecto_id) ?>" class="btn btn-warning btn-sm">Ver</a>
                                            <?php
                                                } else {  
                                            ?>
                                                <a href="<?= site_url('proyectos_evaluaciones/edit/'.$row->id.'/'.$proyecto_id) ?>" class="btn btn-warning btn-sm">Editar</a>
                                                &nbsp;
                                                <a href="<?= site_url('proyectos_evaluaciones/delete/'.$row->id.'/'.$proyecto_id) ?>" 
                                               class="btn btn-danger btn-sm" 
                                               onclick="return confirm('¿Está seguro de eliminar esta evaluación?')">Eliminar</a>
                                            <?php
                                                } 
                                            ?>
                                        </td>
                                        <td><?= htmlspecialchars($row->id, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->proyecto_id, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($row->categoria, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars($estado_palabra, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= $row->si_no ? 'Sí' : 'No' ?></td>
                                        <td><?= htmlspecialchars($row->fecha, ENT_QUOTES, 'UTF-8') ?></td>
                                        <td><?= htmlspecialchars(substr($row->observaciones, 0, 30), ENT_QUOTES, 'UTF-8') ?>...</td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>
</html>
