<!--!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar PGA</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head-->
<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-inline {
            gap: 10px;
        }
        .table th {
            background-color: #007bff;
            color: white;
        }
        .btn-container {
            margin-top: 30px; /* Espacio entre los botones y los campos */
        }
        .btn-container .btn {
            margin-right: 10px; /* Espacio entre los botones */
        }
    </style>
</head>
<body>    
<div class="content-wrapper">
                <section class="content-header">
                    <?php //echo $pagetitle; ?>
                    <?php //echo $breadcrumb; ?>
                </section>

                <section class="content"> 

    <div class="container mt-5">
        <h1 class="mb-4">Editar PGA</h1>

        <form method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label for="id_proyecto" class="form-label">ID Proyecto</label>
                <input type="number" name="id_proyecto" id="id_proyecto" class="form-control" value="<?= $id_proyecto ?>" required readonly>
            </div>
            <div class="mb-3">
                <label for="estado" class="form-label">Estado</label>
                <select name="estado" id="estado" class="form-control">
                    <?php foreach ($dropdown_estados as $key => $value): ?>
                        <option value="<?= $key ?>" <?= $pga->estado == $key ? 'selected' : '' ?>>
                            <?= $value ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="tipo_riesgo" class="form-label">Tipo de Riesgo</label>
                <select name="tipo_riesgo" id="tipo_riesgo" class="form-control">
                    <?php foreach ($dropdown_tipos_riesgo as $key => $value): ?>
                        <option value="<?= $key ?>" <?= $pga->tipo_riesgo == $key ? 'selected' : '' ?>>
                            <?= $value ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="tipo_plan" class="form-label">Tipo de Plan</label>
                <select name="tipo_plan" id="tipo_plan" class="form-control">
                    <?php foreach ($dropdown_tipos_plan as $key => $value): ?>
                        <option value="<?= $key ?>" <?= $pga->tipo_plan == $key ? 'selected' : '' ?>>
                            <?= $value ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="mb-3">
                <label for="descript_plan" class="form-label">Descripción</label>
                <textarea name="descript_plan" id="descript_plan" class="form-control" rows="4"><?= $pga->descript_plan ?></textarea>
            </div>
            <div class="mb-3">
                <label for="fecha_reg" class="form-label">Fecha de Registro</label>
                <input type="date" name="fecha_reg" id="fecha_reg" class="form-control" value="<?= $pga->fecha_reg ?>" required>
            </div>
            <br>
            <div class="form-group">
                <label for="documento" class="col-sm-2 control-label">Importar Documentos</label>
                <div class="col-sm-4">
                <input type="file" name="documento[]" id="documento" class="form-control" multiple>
                    <p class="help-block">Selecciona un archivo CSV o Excel para importar documentos.</p>
                </div>
                <div class="col-sm-2">
                    <button type="submit" name="importar" class="btn btn-success btn-flat">Importar</button>
                </div>
            </div>
            <br>
            <br>
            <br>
            <div style="border: 1px solid #ccc; border-radius: 5px; background-color: #f1f1f1; padding: 20px; margin-top: 20px;">
                <h4>Documentos Existentes</h4>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Nombre del Archivo</th>
                            <th>Fecha de Subida</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($documentos)): ?>
                            <?php foreach ($documentos as $documento): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars(basename($documento->url)); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($documento->fecha_reg)); ?></td>
                                    <td>
                                    <a href="<?php echo site_url('documentos/descargarArchivo/' . $documento->id_archivo); ?>" class="btn btn-info btn-sm">
                                                                        Descargar
                                                                    </a>
                                        &nbsp;
                                        <a href="#" class="btn btn-danger btn-sm delete-document"
                                        data-id="<?php echo $documento->id_archivo; ?>"
                                        data-tipo="<?php echo $documento->tipo_documento; ?>">
                                            Eliminar
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="3" class="text-center">No hay documentos asociados.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
                <div class="form-row">
                    <div class="form-group col-md-12">
                        <div class="btn-container">
                            <button type="submit" class="btn btn-primary">Actualizar</button>
                        <a href="<?= site_url('pga/index/'.$pga->id_proyecto ) ?>" class="btn btn-warning">Cancelar</a> 
                    </div>
                </div>
            </div>
        </form>
    </div>
<!--/body>
</html-->
</section>
</div>
    <!-- Modal para mensajes -->
    <div class="modal fade" id="mensajeModal" tabindex="-1" role="dialog" aria-labelledby="mensajeModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header alert-success">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mensajeModalLabel">Mensaje</h4>
                </div>
                <div class="modal-body">
                    <?= $this->session->flashdata('message') ?: $this->session->flashdata('error') ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                </div>
                </div>
            </div>
        </div>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <script>
    $(document).ready(function() {
        $('.delete-document').on('click', function(e) {
            e.preventDefault();
            var id = $(this).data('id');
            var tipo = $(this).data('tipo');

            var deleteUrl = '<?= site_url("pga/delete_document") ?>/' + id + '/' + tipo + '/' + <?= $pga->id_proyecto ?>;
            console.log("Eliminando documento en:", deleteUrl);

            if (confirm('¿Estás seguro de que deseas eliminar este documento?')) {
                window.location.href = deleteUrl;
            }
        });
    });
    </script>
    <script>
        $(document).ready(function() {
            <?php if ($this->session->flashdata('message') || $this->session->flashdata('error')): ?>
                $('#mensajeModal').modal('show');
            <?php endif; ?>
        });
    </script>

