<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
        }

        .table {
            font-size: 15px;
        }

        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 10px;
        }

        .form-row .col {
            flex: 1;
            min-width: 200px;
        }

        .content-header h1 {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Gestión de PGA</h1>
        </section>

        <section class="content">
            <div class="container table-container">
                <!-- Filters -->
                <form method="get" class="mb-4">
                    <div class="form-row">
                        <div class="col">
                            <input type="text" name="nombre_proyecto" id="nombre_proyecto" class="form-control" placeholder="Proyecto" value="<?= $this->input->get('nombre_proyecto') ?>">
                        </div>
                        <div class="col">
                            <input type="text" name="tipo_riesgo" id="tipo_riesgo" class="form-control" placeholder="Tipo Riesgo" value="<?= $this->input->get('tipo_riesgo') ?>">
                        </div>
                        <div class="col">
                            <input type="text" name="tipo_plan" id="tipo_plan" class="form-control" placeholder="Tipo Plan" value="<?= $this->input->get('tipo_plan') ?>">
                        </div>
                        <div class="col">
                            <input type="text" name="estado" id="estado" class="form-control" placeholder="Estado" value="<?= $this->input->get('estado') ?>">
                        </div>
                        <div class="col">
                            <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                        </div>
                    </div>
                </form>

                <!-- Data Table -->
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Tipo Riesgo</th>
                            <th>Tipo Plan</th>
                            <th>Descripción</th>
                            <th>Fecha Reg</th>
                            <th>Estado</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pgas as $pga): ?>
                            <tr>
                                <td><?= $pga->id ?></td>
                                <td><?= $pga->tipo_riesgo ?></td>
                                <td><?= $pga->tipo_plan ?></td>
                                <td><?= substr($pga->descript_plan, 0, 50) ?>...</td>
                                <td><?= $pga->fecha_reg ?></td>
                                <td><?= $pga->estado ?></td>
                                <td>
                                    <a href="<?= site_url('pga/edit/' . $pga->id) ?>" class="btn btn-warning btn-sm">Editar</a>
                                    <a href="<?= site_url('pga/delete/' . $pga->id) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>

                <a href="<?= site_url('pga/create') ?>" class="btn btn-success">Crear Nuevo</a>
            </div>
        </section>
    </div>
</body>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
