
<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px; /* Aumentar el ancho máximo */
            margin: auto; /* Centrar la tabla */
        }

        .table {
            font-size: 15px; /* Ajustar tamaño de fuente si es necesario */
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
        <?php //echo $pagetitle; ?>
        <?php //echo $breadcrumb; ?>
    </section>

    <section class="content">    
    <div class="container mt-5">
        <h1 class="mb-4">Gestión de PGA</h1>
        
        <!-- Filters -->
        <form method="get" class="row g-3 mb-4">
            <div class="col-md-3">
                <label for="nombre_proyecto" class="form-label">Proyecto</label>
                <input type="text" name="nombre_proyecto" id="nombre_proyecto" class="form-control" value="<?= $this->input->get('nombre_proyecto') ?>">
            </div>            
            <div class="col-md-3">
                <label for="tipo_riesgo" class="form-label">Tipo Riesgo</label>
                <input type="text" name="tipo_riesgo" id="tipo_riesgo" class="form-control" value="<?= $this->input->get('tipo_riesgo') ?>">
            </div>
            <div class="col-md-3">
                <label for="tipo_plan" class="form-label">Tipo Plan</label>
                <input type="text" name="tipo_plan" id="tipo_plan" class="form-control" value="<?= $this->input->get('tipo_plan') ?>">
            </div>
            <div class="col-md-3">
                <label for="estado" class="form-label">Estado</label>
                <input type="text" name="estado" id="estado" class="form-control" value="<?= $this->input->get('estado') ?>">
            </div>            
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Filtrar</button>
            </div>
        </form>

        <!-- Data Table -->
        <table class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Tipo Riesgo</th>
                    <th>Tipo Plan</th>
                    <th>Descripción</th>
                    <th>Fecha Reg</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pgas as $pga): ?>
                    <tr>
                        <td><?= $pga->id ?></td>
                        <td><?= $pga->tipo_riesgo ?></td>
                        <td><?= $pga->tipo_plan ?></td>
                        <td><?= substr($pga->descript_plan, 0, 50) ?>...</td>
                        <td><?= $pga->fecha_reg ?></td>
                        <td><?= $pga->estado ?></td>
                        <td>
                            <a href="<?= site_url('pga/edit/' . $pga->id, $pga->id_proyecto) ?>" class="btn btn-warning btn-sm">Editar</a>
                            <a href="<?= site_url('pga/delete/' . $pga->id, $pga->id_proyecto) ?>" class="btn btn-danger btn-sm">Eliminar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <a href="<?= site_url('pga/create') ?>" class="btn btn-success">Crear Nuevo</a>
    </div>
    </section>
</div>   
</body>


<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
