<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px; /* Espaciado interno */
            border-radius: 5px; /* Bordes redondeados */
            background-color: #ffffff; /* Fondo blanco */
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4">Grupos</h1>

                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-md-2">
                        <label for="id" class="form-label">ID Grupo</label>
                        <input type="text" name="id" class="form-control" placeholder="ID" value="<?php echo isset($filters['id']) ? $filters['id'] : ''; ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="nombre_cliente" class="form-label">Nombre Cliente</label>
                        <input type="text" name="nombre_cliente" class="form-control" placeholder="Nombre Cliente" value="<?php echo isset($filters['nombre_cliente']) ? $filters['nombre_cliente'] : ''; ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="nombre_grupo" class="form-label">Nombre Grupo</label>
                        <input type="text" name="nombre_grupo" class="form-control" placeholder="Nombre Grupo" value="<?php echo isset($filters['nombre_grupo']) ? $filters['nombre_grupo'] : ''; ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>


                <?php 
                $user_id = $this->session->userdata('user_id');
                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                $id_cliente = $_SESSION['id_cliente'][0];
                if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                    <a href="<?= site_url('grupos/grupos/create') ?>" class="btn btn-success mb-3">Crear Nuevo Grupo</a>
                    <br>
                <?php
                    } 
                ?>
                
                <br>
                <!-- Contenedor con fondo blanco -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Nombre Cliente</th>
                                    <th>Nombre Grupo</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($grupos as $grupo): ?>
                                    <tr>
                                        <td>
                                            <?php 
                                            $user_id = $this->session->userdata('user_id');
                                            $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                            $id_cliente = $_SESSION['id_cliente'][0];
                                            if ($tipo_usuario == 'C') { 
                                            ?> 
                                                <a href="<?= site_url('grupos/grupos/view/'.$grupo['id']) ?>" class="btn btn-info btn-sm">Ver</a>
                                            <?php
                                                } else {  
                                            ?>   
                                                <a href="<?= site_url('grupos/grupos/edit/'.$grupo['id']) ?>" class="btn btn-warning btn-sm">Editar</a>
                                                &nbsp;
                                                <a href="<?= site_url('grupos/grupos/delete/'.$grupo['id']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                                &nbsp;
                                                <a href="<?= site_url('grupos/grupos/view/'.$grupo['id']) ?>" class="btn btn-info btn-sm">Ver</a>
                                            <?php
                                                } 
                                            ?>
                                           
                                        </td>
                                        <td><?= $grupo['id'] ?></td>
                                        <td><?= $grupo['nombre_cliente'] ?></td>
                                        <td><?= $grupo['nombre_grupo'] ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
</body>
