<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .table-container {
            max-width: 1200px; /* Aumentar el ancho máximo */
            margin: auto; /* Centrar la tabla */
        }

        .table {
            font-size: 15px; /* Ajustar tamaño de fuente si es necesario */
        }

        .btn-container {
            margin-top: 30px; /* Espacio entre los botones y los campos */
        }
        .btn-container .btn {
            margin-right: 10px; /* Espacio entre los botones */
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <?php //echo $pagetitle; ?>
        <?php //echo $breadcrumb; ?>
    </section>

    <section class="content">
<body>
<div class="container mt-5">
    <h1>Crear Declaración</h1>
    <?= validation_errors('<div class="alert alert-danger">', '</div>'); ?>

    <?php if ($this->session->flashdata('message')): ?>
        <div class="alert alert-success">
            <?= $this->session->flashdata('message') ?>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger">
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data" action="<?= site_url('declaraciones/create') ?>">
        <div class="form-group">
            <label for="id_proyecto">ID Proyecto</label>
            <input type="number" class="form-control" id="id_proyecto" name="id_proyecto" value="<?= $id_proyecto ?>" required readonly>
        </div>
        <div class="form-group">
            <label for="nro_declaracion">Número de Declaración</label>
            <input type="number" class="form-control" id="nro_declaracion" name="nro_declaracion" required>
        </div>
        <div class="form-group">
            <label for="gestion_declaracion">Gestión</label>
            <input type="number" class="form-control" id="gestion_declaracion" name="gestion_declaracion" required>
        </div>
        <div class="form-group">
            <label for="estado">Estado</label>
                <select name="estado" id="estado" class="form-control">
                    <?php foreach ($dropdown_estados as $key => $value): ?>
                        <option value="<?php echo $key; ?>" 
                            <?php echo isset($_POST['estado']) && $_POST['estado'] == $key ? 'selected' : ''; ?>>
                            <?php echo $value; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
        </div>
        <div class="form-group">
            <label for="fecha_declaracion">Fecha de Declaración</label>
            <input type="date" class="form-control" id="fecha_declaracion" name="fecha_declaracion" required>
        </div>
        
        <div class="form-group">
            <label for="fecha_prox_vto_aa">Fecha Próximo Vencimiento</label>
            <input type="date" class="form-control" id="fecha_prox_vto_aa" name="fecha_prox_vto_aa" required>
        </div>
        <div class="form-group">
            <label for="observacion">Observación</label>
            <textarea class="form-control" id="observacion" name="observacion"></textarea>
        </div>
        <div class="form-group">
            <label for="documento">Subir Documentos</label>
            <input type="file" name="documento[]" class="form-control" multiple>
            <small class="text-muted">Puede subir un documento, para mayor carga de documentos vaya a la seccion editar luego de guardar.</small>
        </div>
        
        <div class="form-row">
            <div class="form-group col-md-12">
                <div class="btn-container">
                    <button type="submit" class="btn btn-primary">Guardar</button>
                    <a href="<?= site_url('declaraciones/index/'. $id_proyecto) ?>" class="btn btn-warning">Cancelar</a>
                </div>
            </div>
        </div>
        
    </form>
</div>

</section>
</div>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

