<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$user_id = $this->session->userdata('user_id');
$id_cliente = $_SESSION['id_cliente'][0];
?>
<?php
    // Asegurar valores para PHP 5
    $proyectos_proximos_vencer = isset($alertas['proximos_vencer']) ? $alertas['proximos_vencer'] : 0;
    $proyectos_vencidos = isset($alertas['vencidos']) ? $alertas['vencidos'] : 0;

    // Definir color según los datos
    $color = 'bg-green'; // Verde si no hay alertas

    if ($proyectos_proximos_vencer > 0) {
        $color = 'bg-yellow'; // Amarillo si hay proyectos por vencer
    }
    if ($proyectos_vencidos > 0) {
        $color = 'bg-red'; // Rojo si hay proyectos vencidos
    }
?>
<?php
    // Declaraciones
    $proximos_vencer_declaraciones = isset($declaraciones_alertas['proximos_vencer']) ? $declaraciones_alertas['proximos_vencer'] : 0;
    $vencidos_declaraciones = isset($declaraciones_alertas['vencidos']) ? $declaraciones_alertas['vencidos'] : 0;
    $color_declaraciones = 'bg-green'; // Verde si no hay alertas

    if ($proximos_vencer_declaraciones > 0) {
        $color_declaraciones = 'bg-yellow'; // Amarillo si hay declaraciones por vencer
    }
    if ($vencidos_declaraciones > 0) {
        $color_declaraciones = 'bg-red'; // Rojo si hay declaraciones vencidas
    }
?>

<?php
    // Resoluciones
    $proximos_vencer_resoluciones = isset($resoluciones_alertas['proximos_vencer']) ? $resoluciones_alertas['proximos_vencer'] : 0;
    $vencidos_resoluciones = isset($resoluciones_alertas['vencidos']) ? $resoluciones_alertas['vencidos'] : 0;
    $vencen_6_meses_resoluciones = isset($resoluciones_alertas['vencen_6_meses']) ? $resoluciones_alertas['vencen_6_meses'] : 0;
    $color_resoluciones = 'bg-green'; // Verde si no hay alertas

    if ($vencen_6_meses_resoluciones > 0) {
        $color_resoluciones = 'bg-orange'; // Naranja si hay resoluciones que vencen en 6 meses
    }
?>
<?php
    // Resoluciones
    $proximos_vencer_6m_resoluciones = isset($resoluciones_alertas['alerta_180d_120d']) ? $resoluciones_alertas['alerta_180d_120d'] : 0;
    $proximos_vencer_3m_resoluciones = isset($resoluciones_alertas['alerta_120d_30d']) ? $resoluciones_alertas['alerta_120d_30d'] : 0;
    $proximos_vencer_1m_resoluciones = isset($resoluciones_alertas['alerta_30d_15d']) ? $resoluciones_alertas['alerta_30d_15d'] : 0;
    $proximos_vencer_15d_resoluciones = isset($resoluciones_alertas['alerta_15d_0d']) ? $resoluciones_alertas['alerta_15d_0d'] : 0;
    $vencidos_resoluciones = isset($resoluciones_alertas['vencidos']) ? $resoluciones_alertas['vencidos'] : 0;

    // Colores para los cuadros
    $color_6m = 'bg-green'; // Por defecto verde si no hay alertas
    $color_3m = 'bg-green';
    $color_1m = 'bg-green';
    $color_15d_vencidos = 'bg-green'; // Combinado para 15 días y vencidos

    // Lógica para 6 meses
    if ($proximos_vencer_6m_resoluciones > 0) {
        $color_6m = 'bg-blue'; // Azul si hay resoluciones que vencen en 6 meses
    }

    // Lógica para 3 meses
    if ($proximos_vencer_3m_resoluciones > 0) {
        $color_3m = 'bg-orange'; // Naranja si hay resoluciones que vencen en 3 meses
    }

    // Lógica para 1 mes
    if ($proximos_vencer_1m_resoluciones > 0) {
        $color_1m = 'bg-yellow'; // Amarillo si hay resoluciones que vencen en 1 mes
    }

    // Lógica combinada para 15 días y vencidos
    if ($proximos_vencer_15d_resoluciones > 0 || $vencidos_resoluciones > 0) {
        $color_15d_vencidos = 'bg-red'; // Rojo si hay resoluciones que vencen en 15 días o ya están vencidas
    }
?>
<style>
    .tabla-proceso {
        width: 100%;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        font-weight: bold;
        table-layout: fixed;
    }

    .tabla-proceso td {
        border: 1px solid black;
        width: 90px;
        height: 110px;
        position: relative;
        overflow: hidden;
        padding: 0;
    }

    .etiqueta {
        display: block;
        position: absolute;
        bottom: 5px; /* Mueve el texto hacia la parte inferior de la celda */
        left: 10px;
        width: 120px; /* Aumentamos el ancho del texto diagonal */
        font-size: 11px;
        transform: rotate(-45deg);
        transform-origin: left top;
        white-space: normal; /* Permite varias líneas */
        text-align: left;
        line-height: 1.1;
    }

    .numero {
        position: absolute;
        top: 5px;
        left: 5px;
        font-size: 14px;
        font-weight: bold;
        color: black;
    }

    .inicio, .fin {
        background-color: white;
        width: 60px;
        font-size: 12px;
        text-align: center;
    }

    .color-1 { background-color: #E53935; }
    .color-2 { background-color: #FB8C00; }
    .color-3 { background-color: #FDD835; }
    .color-4 { background-color: #C0CA33; }
    .color-5 { background-color: #7CB342; }
    .color-6 { background-color: #4CAF50; }
    .color-7 { background-color: #00897B; }
    .color-8 { background-color: #388E3C; }
    .color-9 { background-color: #1B5E20; }

    /* Ajuste de texto para info-boxes */
    .info-box {
        min-height: 100px;
    }

    .info-box-content {
        white-space: normal !important; /* Permite salto de línea */
        word-wrap: break-word;          /* Para navegadores antiguos */
        overflow-wrap: break-word;      /* Para navegadores modernos */
        max-height: 100px;              /* Opcional: limita altura */
        overflow: hidden;               /* Evita desborde */
    }

    .info-box-number {
        font-size: 20px; /* Tamaño ajustado */
        line-height: 1.3;
    }

    /* Íconos con fondo personalizado (puede venir de PHP) */
    .info-box-icon {
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 30px;
        color: #fff;
        height: 100%;
        min-height: 100px;
    }

    /* Ajustes para texto superior */
    .info-box-text {
        font-weight: bold;
        text-transform: capitalize;
    }

</style>



            <div class="content-wrapper">
                <section class="content-header">
                    <?php echo $pagetitle; ?>
                    <?php echo $breadcrumb; ?>
                </section>

                <section class="content">
                    <h2>Alertas de vencimientos de presentacion de Auditorias</h2>
                <div class="row">

                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <a href="ruta_a_tu_pagina_de_Resoluciones" class="info-box-icon <?= $color_6m ?>">
                                    <i class="fa fa-balance-scale"></i>
                                </a>
                                <div class="info-box-content">
                                    <span class="info-box-text">6 Meses</span>
                                    <span class="info-box-number">
                                        <?php if ($proximos_vencer_6m_resoluciones > 0 ): ?>
                                            <?= $proximos_vencer_6m_resoluciones; ?> por vencer en 6 meses
                                        <?php else: ?>
                                            No hay resoluciones próximas a vencer.
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <a href="ruta_a_tu_pagina_de_Resoluciones" class="info-box-icon <?= $color_3m ?>" title="Ir a ver las resoluciones">
                                    <i class="fa fa-file-text"></i>
                                </a>
                                <div class="info-box-content">
                                    <span class="info-box-text">3 Meses</span>
                                    <span class="info-box-number">
                                        <?php if ($proximos_vencer_3m_resoluciones > 0): ?>
                                            <?= $proximos_vencer_3m_resoluciones; ?> por vencer en 3 meses
                                        <?php else: ?>
                                            No hay resoluciones próximos a vencer.
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <div class="info-box">
                                    <span class="info-box-icon <?= $color_1m ?>"><i class="fa fa-file-text"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">1 Mes</span>
                                        <span class="info-box-number">
                                            <?php if ($proximos_vencer_1m_resoluciones > 0): ?>
                                                <?= $proximos_vencer_1m_resoluciones; ?> por vencer en 1 mes
                                            <?php else: ?>
                                                No hay resoluciones próximas a vencer.
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <div class="info-box">
                                    <span class="info-box-icon <?= $color_15d_vencidos ?>"><i class="fa fa-exclamation-triangle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">15 dias o vencidas</span>
                                        <span class="info-box-number">
                                            <?php if ($proximos_vencer_15d_resoluciones > 0 || $vencidos_resoluciones > 0): ?>
                                                <?= $proximos_vencer_15d_resoluciones; ?> por vencer en 15 dias | <?= $vencidos_resoluciones; ?> vencidas
                                            <?php else: ?>
                                                No hay resoluciones próximas a vencer.
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php if (grupo_usuario(6)): ?>
                    <div class="clearfix visible-sm-block"></div>
                        
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-user"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Users</span>
                                    <span class="info-box-number"><?php echo $count_users; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-shield"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Security groups</span>
                                    <span class="info-box-number"><?php echo $count_groups; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-user"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Clientes Activos</span>
                                    <span class="info-box-number">
                                        24.321
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
               
                    

                    <div class="row">
                        <div class="col-md-12">
<?php
/*
if ($url_exist) {
    echo 'OK';
} else {
    echo 'KO';
}
*/
?>
                        </div>

                        <div class="col-md-12">
                    	<?php if (grupo_usuario(6)): ?>
                            <section class="content-header">
                                <h1>Dashboard de Proyectos</h1>
                            </section>
                     	<?php endif; ?>
                        
                        <?php if (grupo_usuario(9)): ?>
                     		<section class="content-header">
                                <h1>Resumen de su Gestión Ambiental</h1>
                            </section>
						<?php endif; ?>
                            <section class="content">
                                <div class="row">
                                    <!-- Contenedor para los gráficos principales -->
                                    <div class="col-md-12">
                                        <div class="row">
                                            <!-- Gráfico de líneas ocupa 12 columnas -->
                                            <div class="col-md-12 d-flex align-items-stretch">
                                                <div class="box h-100">
                                                    <table class="tabla-proceso">
                                                        <tr>
                                                            <td class="inicio">INICIO DE PROCESO</td>
                                                            <td class="color-1"><span class="numero">1</span><span class="etiqueta">Ingreso de Proyecto EMA</span></td>
                                                            <td class="color-2"><span class="numero">2</span><span class="etiqueta">Mesa de Entrada</span></td>
                                                            <td class="color-3"><span class="numero">3</span><span class="etiqueta">Dirección DGCCARN Análisis Técnico</span></td>
                                                            <td class="color-4"><span class="numero">4</span><span class="etiqueta">Geomática</span></td>
                                                            <td class="color-5"><span class="numero">5</span><span class="etiqueta">Análisis Técnico</span></td>
                                                            <td class="color-6"><span class="numero">6</span><span class="etiqueta">RIMA (Publicación)</span></td>
                                                            <td class="color-7"><span class="numero">7</span><span class="etiqueta">RIMA (WEB)</span></td>
                                                            <td class="color-8"><span class="numero">8</span><span class="etiqueta">DVIA</span></td>
                                                            <td class="color-9"><span class="numero">9</span><span class="etiqueta">Dirección General</span></td>
                                                            <td class="color-9"><span class="numero">10</span><span class="etiqueta">Licencia(DIA)</span></td>
                                                            <td class="fin">FIN DE PROCESO</td>
                                                        </tr>
                                                    </table>
                                                </div>  
                                            </div><!-- Cierre del row anidado -->

                                            <div class="col-md-12">
                                                <div class="row">
                                                    <!-- Gráfico de líneas ocupa 6 columnas -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                    <center><h3 class="box-title">Estados de Proyectos</h3></center>
                                
                                                                <div class="box-tools pull-right">
                                                                        <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                    <canvas id="barChartCategorias" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>  
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                      						<?php if (grupo_usuario(6)): ?>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico de líneas ocupa 6 columnas -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Sector</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="bar-chart" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> <!-- Cierre del row anidado -->
                                            </div>

                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Tipo de Estudio</h3></center>
                            
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="barChart" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php if (grupo_usuario(6)): ?>
                                        <div class="col-md-12 d-flex align-items-stretch">
                                            <div class="box box-info h-100">
                                                <div class="box-header with-border">
                                                    <center><h3 class="box-title">Proyectos por Distrito y Fecha</h3></center>
                                                    <div class="box-tools pull-right">
                                                        <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                                            <i class="fa fa-minus"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="box-body">
                                                    <canvas id="lineChartDistritoFecha" style="height: 475px; width: 100%;"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php if (grupo_usuario(6)): ?>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Tipo de Impacto Ambiental</h3></center>
                            
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="barChartTipoProyecto" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        <?php endif; ?>
                                        <?php if (grupo_usuario(6)): ?>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y tipo de estudio</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="line-chart" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>  
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        <?php endif; ?>
                                        </div> <!-- Cierre del row principal -->
                                    </div>
                                <?php if (grupo_usuario(6)): ?>
                                <div class="col-md-12">
                                    <div class="row">
                                        <!-- Contenedor para los otros dos gráficos -->
                                            <div class="col-md-3">
                                                <div class="row">
                                                    <!-- Gráfico Donut 1 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-danger h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Tipos de Estudio</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="pieChart" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>                                                    
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                     
                                        <div class="col-md-9">
                                            <div class="row">
                                                <!-- Gráfico de líneas ocupa 6 columnas -->
                                                <div class="col-md-12 d-flex align-items-stretch">
                                                    <div class="box box-info h-100">
                                                        <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos presentados</h3></center>
                            
                                                            <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="box-body">
                                                                <canvas id="barChartProyectos" style="height: 350px; width: 100%;"></canvas>
                                                        </div>
                                                    </div>
                                                </div>  
                                            </div> <!-- Cierre del row anidado -->
                                        </div>
                                    </div> <!-- Cierre del row principal -->
                                </div>
 								<?php endif; ?>
                                <?php if (!grupo_usuario(3)): ?>
                                	<div class="col-md-12">
                                            <div class="row">
                                                <!-- Gráfico de líneas ocupa 6 columnas -->
                                                <div class="col-md-12 d-flex align-items-stretch">
                                                    <div class="box box-info h-100">
                                                        <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos presentados</h3></center>
                            
                                                            <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                            </div>
                                                        </div>
                                                        <div class="box-body">
                                                                <canvas id="barChartProyectos" style="height: 350px; width: 100%;"></canvas>
                                                        </div>
                                                    </div>
                                                </div>  
                                            </div> <!-- Cierre del row anidado -->
                                        </div>
									<?php endif; ?>
                                    <!-- Sección de Recursos alineada debajo de los gráficos -->
                                    <?php if (grupo_usuario(6)): ?>
                                        <div class="col-md-12">
                                            <div class="box box-primary">
                                                <div class="box-header with-border">
                                                    <h3 class="box-title">Resources</h3>
                                                </div>
                                                <div class="box-body">
                                                    <div class="progress-group">
                                                        <span class="progress-text">Disk use space</span>
                                                        <span class="progress-number">
                                                            <strong><?php echo byte_format($disk_usespace, 2); ?></strong>/<?php echo byte_format($disk_totalspace, 2); ?>
                                                        </span>
                                                        <div class="progress">
                                                            <div class="progress-bar progress-bar-aqua" role="progressbar" aria-valuenow="<?php echo $disk_usepercent; ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $disk_usepercent; ?>%"></div>
                                                        </div>
                                                    </div>
                                                    <div class="progress-group">
                                                        <span class="progress-text">Memory usage</span>
                                                        <span class="progress-number">
                                                            <strong><?php echo byte_format($memory_usage, 2); ?></strong>/<?php echo byte_format($memory_peak_usage, 2); ?>
                                                        </span>
                                                        <div class="progress">
                                                            <div class="progress-bar progress-bar-red" role="progressbar" aria-valuenow="<?php echo $memory_usepercent; ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $memory_usepercent; ?>%"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </section>
                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- Cargar Chart.js antes de ejecutar el script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    console.log("El script de la vista se está ejecutando.");
</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        console.log("Cargando el Donut Chart...");

        fetch('http://45.10.163.71/ema/index.php/api/proyectos/tipos-estudio')
            .then(response => response.json())
            .then(data => {
                console.log("Datos recibidos para Donut Chart:", data);

                if (!Array.isArray(data) || data.length === 0) {
                    console.warn("No hay datos disponibles para el gráfico.");
                    return;
                }

                let labels = data.map(item => item.tipo_estudio || "Sin Tipo");
                let counts = data.map(item => item.cantidad);
                let colors = labels.map(() => `hsl(${Math.random() * 360}, 70%, 50%)`);

                let ctx = document.getElementById("pieChart").getContext("2d");

                if (!ctx) {
                    console.error("No se encontró el canvas del gráfico.");
                    return;
                }

                new Chart(ctx, {
                    type: "pie",
                    data: {
                        labels: labels,
                        datasets: [{
                            data: counts,
                            backgroundColor: colors,
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: { position: "bottom" }
                        }
                    }
                });

            })
            .catch(error => console.error("Error en la petición:", error));
    });
</script>
<script>
   document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico se está ejecutando.");

    
    fetch('http://45.10.163.71/ema/index.php/Chart/get_sales_data_by_state')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            
            let labels = data.map(item => item.year + ' - ' + item.estado_nombre); 
            let counts = data.map(item => parseInt(item.total)); 

            console.log("Labels:", labels);
            console.log("Counts:", counts);

            let ctx = document.getElementById("line-chart");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "line",  
                data: {
                    labels: labels,
                    datasets: [{
                        label: "Proyectos por Año y Estado",
                        data: counts,
                        borderColor: "rgba(60, 141, 188, 1)",  
                        backgroundColor: "rgba(60, 141, 188, 0.2)",  
                        fill: true,
                        tension: 0.4  
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true  
                            }
                        }]
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        console.log("Cargando Chart - Estados...");

        setTimeout(() => {
            fetch('http://45.10.163.71/ema/index.php/api/proyectos/tipo_estudio')
                .then(response => response.json())
                .then(data => {
                    console.log("Datos recibidos para Bar Chart - Estados:", data);

                    if (!Array.isArray(data) || data.length === 0) {
                        console.warn("No hay datos disponibles para el gráfico.");
                        return;
                    }

                    let labels = data.map((item, index) => `${index + 1}- ${item.estado || "Desconocido"}`);
                    let counts = data.map(item => item.total);
                    let colors = "#3b82f6"; 

                    let ctx = document.getElementById("donutEstadosChart").getContext("2d");

                    if (!ctx) {
                        console.error("No se encontró el canvas del gráfico de estados.");
                        return;
                    }

                    
                    if (window.barChartEstados instanceof Chart) {
                        window.barChartEstados.destroy();
                    }

                    
                    window.barChartEstados = new Chart(ctx, {
                        type: "bar",
                        data: {
                            labels: labels,
                            datasets: [{
                                label: "Total",
                                data: counts,
                                backgroundColor: colors,
                                borderColor: "#1e3a8a",
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: { position: "right" },
                                tooltip: {
                                    callbacks: {
                                        label: function (tooltipItem) {
                                            return `${tooltipItem.label}: ${tooltipItem.raw}`;
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    ticks: {
                                        autoSkip: false,
                                        maxRotation: 30,
                                        minRotation: 0
                                    }
                                },
                                y: {
                                    beginAtZero: true,
                                    ticks: {
                                        stepSize: 1
                                    }
                                }
                            }
                        }
                    });

                    console.log("Gráfico generado con éxito.");

                })
                .catch(error => console.error("Error en la petición de Estados:", error));
        }, 500);
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico se está ejecutando.");

    fetch('http://45.10.163.71/ema/index.php/Chart/get_sales_data')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            let labels = [];  
            let datasets = [];  

            
            let colors = [
                "rgba(255, 99, 132, 1)", 
                "rgba(54, 162, 235, 1)", 
                "rgba(255, 206, 86, 1)", 
                "rgba(75, 192, 192, 1)", 
                "rgba(153, 102, 255, 1)", 
                "rgba(255, 159, 64, 1)", 
                "rgba(201, 203, 207, 1)"  
            ];

            let colorIndex = 0;

            
            data.forEach(item => {
                
                item.year.forEach(year => {
                    if (!labels.includes(year)) {
                        labels.push(year);
                    }
                });

                let borderColor = colors[colorIndex % colors.length]; 
                let backgroundColor = borderColor.replace("1)", "0.2)"); 

                datasets.push({
                    label: item.label,  
                    data: item.data,    
                    borderColor: borderColor,
                    backgroundColor: backgroundColor,
                    fill: true,
                    tension: 0.4
                });

                colorIndex++; 
            });

            let ctx = document.getElementById("line-chart2");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            
            new Chart(ctx, {
                type: "line",
                data: {
                    labels: labels,  
                    datasets: datasets 
                },
                options: {
                    responsive: true,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico de barras se está ejecutando.");

    fetch('http://45.10.163.71/ema/index.php/Chart/sector_proyecto')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            let labels = [];  
            let datasets = [];  
            
            let colors = [
                "rgba(255, 99, 132, 0.8)", 
                "rgba(54, 162, 235, 0.8)", 
                "rgba(255, 206, 86, 0.8)", 
                "rgba(75, 192, 192, 0.8)", 
                "rgba(153, 102, 255, 0.8)", 
                "rgba(255, 159, 64, 0.8)", 
                "rgba(201, 203, 207, 0.8)"  
            ];

            let borderColors = colors.map(color => color.replace("0.8", "1"));  

            let colorIndex = 0;

            data.forEach(item => {
                item.year.forEach(year => {
                    if (!labels.includes(year)) {
                        labels.push(year);
                    }
                });

                datasets.push({
                    label: item.label,  
                    data: item.data,    
                    backgroundColor: colors[colorIndex % colors.length],  
                    borderColor: borderColors[colorIndex % borderColors.length], 
                    borderWidth: 1
                });

                colorIndex++; 
            });

            let ctx = document.getElementById("bar-chart").getContext("2d");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: labels,  
                    datasets: datasets 
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    },
                    scales: {
                        x: {
                            beginAtZero: true
                        },
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Tipos de Estudio...");

    fetch('http://45.10.163.71/ema/index.php/Chart/tipo_estudio')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let allYears = [];
            let datasets = [];

            
            data.forEach(d => {
                if (d.years) {
                    d.years.forEach(year => {
                        if (!allYears.includes(year)) {
                            allYears.push(year);
                        }
                    });
                }
            });

            allYears.sort((a, b) => a - b); 

            data.forEach((item, index) => {
                let dataValues = allYears.map(year => {
                    let yearIndex = item.years.indexOf(year);
                    return yearIndex !== -1 ? item.data[yearIndex] : 0;
                });

                datasets.push({
                    label: item.label || "Desconocido",
                    data: dataValues,
                    backgroundColor: `hsl(${index * 40}, 70%, 50%)`,
                    borderColor: `hsl(${index * 40}, 70%, 30%)`,
                    borderWidth: 1
                });
            });

            let ctx = document.getElementById("barChart");

            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: allYears,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Tipo de Proyecto...");

    fetch('http://45.10.163.71/ema/index.php/Chart/get_tipo_proyecto_data')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let allYears = [];
            let datasets = [];

          
            data.forEach(d => {
                if (d.years) {
                    d.years.forEach(year => {
                        if (!allYears.includes(year)) {
                            allYears.push(year);
                        }
                    });
                }
            });

            allYears.sort((a, b) => a - b); 

            data.forEach((item, index) => {
                let dataValues = allYears.map(year => {
                    let yearIndex = item.years.indexOf(year);
                    return yearIndex !== -1 ? item.data[yearIndex] : 0;
                });

                datasets.push({
                    label: item.label || "Desconocido",
                    data: dataValues,
                    backgroundColor: `hsl(${index * 40}, 70%, 50%)`,
                    borderColor: `hsl(${index * 40}, 70%, 30%)`,
                    borderWidth: 1
                });
            });

            let ctx = document.getElementById("barChartTipoProyecto");

            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: allYears,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico de Tipo de Proyecto generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Categorías...");

    const apiUrl = 'http://45.10.163.71/ema/index.php/Chart/get_proyectos_evaluaciones_data';

    fetch(apiUrl)
        .then(response => {
            if (!response.ok) {
                throw new Error(`Error HTTP: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            const colorMap = {
                "Ingreso de Proyecto EMA": "#E53935",
                "Mesa de Entrada": "#FB8C00",
                "Dirección DGCCARN - Análisis Técnico inicial": "#FDD835",
                "Geomática": "#C0CA33",
                "Análisis Técnico": "#7CB342",
                "RIMA (Publicación) - 3 días": "#4CAF50",
                "RIMA (WEB) - 10 días hábiles": "#00897B",
                "DVIA": "#388E3C",
                "Dirección General": "#1B5E20",
                "Licencia(DIA)": "#1B5E20",
                "Resoluciones(A.A)": "#1B5E20"
            };

            let labels = data.map(item => item.label);
            let totals = data.map(item => item.total);
            let backgroundColors = labels.map(label => colorMap[label] || "#999999");

            let ctx = document.getElementById("barChartCategorias");
            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            if (window.myBarChart) {
                window.myBarChart.destroy();
            }

            window.myBarChart = new Chart(ctx, {
                type: "bar",
                data: {
                    labels: labels,
                    datasets: [{
                        label: "Total por Categoría",
                        data: totals,
                        backgroundColor: backgroundColors,
                        borderColor: "#333333",
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico de Categorías generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Proyectos...");

    fetch('http://45.10.163.71/ema/index.php/Chart/get_proyectos_totales')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let labels = data.map(item => item.label);
            let totals = data.map(item => item.total);
            let backgroundColors = ["#3498db", "#2ecc71", "#e74c3c"];
            let borderColors = ["#2980b9", "#27ae60", "#c0392b"];

            let ctx = document.getElementById("barChartProyectos");
            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: labels,
                    datasets: [{
                        label: "Cantidad de Proyectos",
                        data: totals,
                        backgroundColor: backgroundColors,
                        borderColor: borderColors,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico de Proyectos generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});
</script>
<script>
document.addEventListener("DOMContentLoaded", async function () {
    console.log("Cargando gráfico Proyectos por Distrito y Fecha...");

    try {
        const response = await fetch('<?= base_url('/index.php/chart/get_proyectos_por_distrito_y_fecha'); ?>');
        
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }

        const data = await response.json();
        console.log("Datos recibidos:", data);

        let labels = new Set();
        Object.values(data).forEach(distrito => {
            distrito.forEach(item => labels.add(item.mes));
        });

        labels = Array.from(labels).sort();

        const colores = [
            "rgba(229, 57, 53, 1)",   
            "rgba(251, 140, 0, 1)",  
            "rgba(76, 175, 80, 1)",   
            "rgba(124, 179, 66, 1)",  
            "rgba(0, 137, 123, 1)",   
            "rgba(27, 94, 32, 1)",    
            "rgba(25, 118, 210, 1)",  
            "rgba(106, 27, 154, 1)"   
        ];

        let datasets = [];
        let colorIndex = 0;

        for (let distrito in data) {
            let dataset = {
                label: distrito,
                data: labels.map(label => {
                    let item = data[distrito].find(i => i.mes === label);
                    return item ? item.total : 0;
                }),
                borderColor: colores[colorIndex % colores.length],
                backgroundColor: colores[colorIndex % colores.length].replace(/1\)$/, "0.2)"),
                fill: true,
                tension: 0.4
            };
            datasets.push(dataset);
            colorIndex++;
        }

        let ctx = document.getElementById("lineChartDistritoFecha");
        new Chart(ctx, {
            type: "line",
            data: {
                labels: labels.map(fecha => new Date(fecha).toLocaleDateString('es-ES', { month: 'short', year: 'numeric' })),
                datasets: datasets
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: { beginAtZero: true }
                },
                plugins: {
                    legend: { position: "top" }
                }
            }
        });

        console.log("Gráfico por Distrito y Fecha generado correctamente.");
    } catch (error) {
        console.error("Error en la petición:", error);
    }
});

</script>






