<?php
// application/models/Tumba_model.php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tumba_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function upload_documents($field_name, $upload_path, $id_proyecto)
    {
        $config['upload_path'] = $upload_path;
        $config['allowed_types'] = 'pdf|doc|docx|txt'; // Tipos de archivos permitidos
        $config['max_size'] = 2048; // Máximo tamaño en KB
        $this->load->library('upload', $config);

        $files = $_FILES[$field_name];
        $uploaded_files = [];
        $errors = [];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['document']['name'] = $files['name'][$key];
            $_FILES['document']['type'] = $files['type'][$key];
            $_FILES['document']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['document']['error'] = $files['error'][$key];
            $_FILES['document']['size'] = $files['size'][$key];

            if ($this->upload->do_upload('document')) {
                $file_data = $this->upload->data();
                $uploaded_files[] = $file_data['file_name'];

                // Guardar en la tabla 'tumba'
                $data = array(
                    'id_proyecto' => $id_proyecto,
                    'tipo_documento' => $file_data['file_ext'], // Guardamos la extensión como tipo de documento
                    'url' => $upload_path . $file_data['file_name'],
                    'estado' => 1, // Por defecto activo
                    'fecha_reg' => date('Y-m-d H:i:s')
                );
                $this->db->insert('ema.tumba', $data);

            } else {
                $errors[] = $this->upload->display_errors();
            }
        }

        if (empty($errors)) {
            return ['status' => true, 'files' => $uploaded_files];
        } else {
            return ['status' => false, 'errors' => $errors];
        }
    }

}
