<?php
class Tipo_alertnotific_model extends CI_Model {

    public function get_tipo_alertas($filters = [], $limit = 10, $offset = 0) 
    {
        if (!empty($filters)) {
            if (!empty($filters['codigo'])) {
                $codigo = $this->db->escape_str($filters['codigo']);
                $this->db->where('codigo', $codigo);
            }

            if (!empty($filters['mensaje'])) {
                $mensaje = $this->db->escape_str($filters['mensaje']);
                $this->db->like('mensaje', $mensaje);
            }

            if (!empty($filters['modulo'])) {
                $modulo = $this->db->escape_str($filters['modulo']);
                $this->db->where('modulo', $modulo);
            }

            if (!empty($filters['estado'])) {
                $this->db->where('estado', $filters['estado']);
            }
        }

        // Aplicar la paginación
        $this->db->limit($limit, $offset);

        return $this->db->get('ema.tipo_alertnotific')->result();
    }

    
    public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
    {
        if (!$tabla) {
            return []; // Devuelve un array vacío si no se especifica una tabla
        }
        $this->db->from($tabla);
        if ($where) {
            foreach ($where as $k => $v) {
                $this->db->where($k, $v);
            }
        }
        if ($order_by) {
            $this->db->order_by($order_by, 'ASC');
        }
        return $this->db->get()->result_array();
    }
    
    public function count_tipo_alertas($filters = []) {
        if (!empty($filters['codigo'])) {
            $this->db->where('codigo', $filters['codigo']);
        }
        if (!empty($filters['modulo'])) {
            $this->db->where('modulo', $filters['modulo']);
        }
        if (!empty($filters['estado'])) {
            $this->db->like('estado', $filters['estado']);
        }
    
        return $this->db->count_all_results('ema.tipo_alertnotific');
    }
    
    public function get_tipo_alerta_by_id($codigo) {
        $this->db->where('codigo', $codigo);
        return $this->db->get('ema.tipo_alertnotific')->row_array();
    }
    
    /* public function create_tipo_alerta($data) {
        // Asegurarse de que los días de alerta estén establecidos correctamente
        $dias_alerta_keys = ['dias_alerta1', 'dias_alerta2', 'dias_alerta3', 'dias_alerta4', 'dias_alerta5'];
        foreach ($dias_alerta_keys as $key) {
            if (empty($data[$key])) {
                $data[$key] = NULL; // O usar 0 si prefieres un valor entero
            }
        }
    
        $this->db->insert('ema.tipo_alertnotific', $data);
        return $this->db->insert_id(); // Devuelve el ID de la última inserción (si aplica)
    } */

    public function create_tipo_alerta($data) {
        // Asegurarse de que los días de alerta estén establecidos correctamente
        $dias_alerta_keys = ['dias_alerta1', 'dias_alerta2', 'dias_alerta3', 'dias_alerta4', 'dias_alerta5'];
        foreach ($dias_alerta_keys as $key) {
            if (empty($data[$key])) {
                $data[$key] = NULL; // O usar 0 si prefieres un valor entero
            }
        }
    
        // Insertar el registro sin depender de un ID
        return $this->db->insert('ema.tipo_alertnotific', $data);
    }
    
    
    public function update_tipo_alerta($codigo, $data) {
        return $this->db->where('codigo', $codigo)->update('ema.tipo_alertnotific', $data);
    }
    
    public function delete_tipo_alerta($codigo) {
        return $this->db->where('codigo', $codigo)->delete('ema.tipo_alertnotific');
    }
}
?>
