<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departamentos_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function count_departamentos($filters = []) {
        $this->db->from('ide.vista_departamentos');
        $this->apply_filters($filters);
        return $this->db->count_all_results();
    }

    public function get_departamentos($filters = [], $limit = 10, $offset = 0) {
        $this->db->select('*');
        $this->db->from('ide.vista_departamentos');
        $this->apply_filters($filters);
        $this->db->limit($limit, $offset);
        return $this->db->get()->result_array();
    }

    public function get_departamento_by_id($id) {
        $this->db->select('*');
        $this->db->from('ide.vista_departamentos');
        $this->db->where('id_departamento', $id);
        return $this->db->get()->row_array();
    }

    private function apply_filters($filters) {
        if (!empty($filters['departamento'])) {
            $this->db->like('departamento', $filters['departamento']);
        }
        if (!empty($filters['distrito'])) {
            $this->db->like('distrito', $filters['distrito']);
        }
        if (!empty($filters['localidad'])) {
            $this->db->like('localidad', $filters['localidad']);
        }
    }
}
