<?php
class Declaraciones_model extends CI_Model {

    public function get_declaraciones($filters = []) {

        // Filtrar por id_proyecto
        if (!empty($filters['id_proyecto'])) {
            $this->db->where('id_proyecto', $filters['id_proyecto']);
        }
        if (!empty($filters['id_declaracion'])) {
            $this->db->where('id_declaracion', $filters['id_declaracion']);
        }
        if (!empty($filters['nro_declaracion'])) {
            $nro = $this->db->escape_str($filters['nro_declaracion']);
            $this->db->where("CONCAT(nro_declaracion, '') LIKE '%{$nro}%'");
        }
        if (!empty($filters['gestion_declaracion'])) {
            $nro = $this->db->escape_str($filters['gestion_declaracion']);
            $this->db->where("CONCAT(gestion_declaracion, '') LIKE '%{$nro}%'");
        }
        if (!empty($filters['estado'])) {
            $this->db->like('estado', $filters['estado']);
        }
        if (!empty($filters['des_estado'])) {
            $this->db->like('des_estado', $filters['des_estado']);
        }
        if (!empty($filters['gestion_declaracion'])) {
            $this->db->where('gestion_declaracion', $filters['gestion_declaracion']);
        }
        if (!empty($filters['dia'])) {
            $this->db->like('dia', $filters['dia']);
        }                
        if (!empty($filters['des_fecha_declaracion'])) {
            $this->db->like('des_fecha_declaracion', $filters['des_fecha_declaracion']);
        }
        
        // --- Filtros de fechas ---
        if (!empty($filters['fecha_desde'])) {
            $this->db->where('des_fecha_declaracion >=', $filters['fecha_desde']);
        }
        if (!empty($filters['fecha_hasta'])) {
            $this->db->where('des_fecha_declaracion <=', $filters['fecha_hasta']);
        }
        
        // Filtro por tipo de declaración (si aplica)
        if (!empty($filters['tipo_declaracion'])) {
            $this->db->where('tipo', $filters['tipo_declaracion']);
        }
        
        // Aplicar paginación (si es necesario)
        if (isset($filters['limit']) && isset($filters['offset'])) {
            $this->db->limit($filters['limit'], $filters['offset']);
        }
        
        // Consultar la tabla (o vista) de declaraciones
        $query = $this->db->get('ema.v_declaraciones_index');
        return $query->result_array();
    }
    

    public function count_declaraciones($filters = []) {

        if (!empty($filters['id_proyecto'])) {
            $this->db->where('id_proyecto', $filters['id_proyecto']);
        }
        if (!empty($filters['id_declaracion'])) {
            $this->db->where('id_declaracion', $filters['id_declaracion']);
        }
        if (!empty($filters['nro_declaracion'])) {
            $nro = $this->db->escape_str($filters['nro_declaracion']);
            $this->db->where("CONCAT(nro_declaracion, '') LIKE '%{$nro}%'");
        }
        if (!empty($filters['gestion_declaracion'])) {
            $nro = $this->db->escape_str($filters['gestion_declaracion']);
            $this->db->where("CONCAT(gestion_declaracion, '') LIKE '%{$nro}%'");
        }
        if (!empty($filters['estado'])) {
            $this->db->like('estado', $filters['estado']);
        }
        if (!empty($filters['des_estado'])) {
            $this->db->like('des_estado', $filters['des_estado']);
        }
        if (!empty($filters['gestion_declaracion'])) {
            $this->db->where('gestion_declaracion', $filters['gestion_declaracion']);
        }
        if (!empty($filters['dia'])) {
            $this->db->like('dia', $filters['dia']);
        }                
        
        // --- Filtros de fechas ---
        if (!empty($filters['fecha_desde'])) {
            $this->db->where('des_fecha_declaracion >=', $filters['fecha_desde']);
        }
        if (!empty($filters['fecha_hasta'])) {
            $this->db->where('des_fecha_declaracion <=', $filters['fecha_hasta']);
        }
        
        // Filtro por tipo de declaración (si aplica)
        if (!empty($filters['tipo_declaracion'])) {
            $this->db->where('tipo', $filters['tipo_declaracion']);
        }
        
        return $this->db->count_all_results('ema.v_declaraciones_index');
    }
    
    public function create_declaracion($data) {
        // Verificar si ya existe
        $this->db->where('nro_declaracion', $data['nro_declaracion']);
        $this->db->where('gestion_declaracion', $data['gestion_declaracion']);
        $existe = $this->db->get('ema.declaraciones')->row();
    
        if ($existe) {
            return 'duplicado';
        }
    
        // Insertar
        $this->db->insert('ema.declaraciones', $data);
        return $this->db->insert_id();
    }
    
    
    
    public function update_declaracion($id, $data) {
        $this->db->where('id_declaracion', $id);
        return $this->db->update('ema.declaraciones', $data);
    }

    public function delete_declaracion($id) {
        $this->db->where('id_declaracion', $id);
        return $this->db->delete('ema.declaraciones');
    }

    public function get_declaracion_by_id($id)
    {
        $this->db->where('id_declaracion', $id);
        return $this->db->get('ema.declaraciones')->row_array(); // row_array para devolver un único registro como array asociativo
    }

    public function concepto($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }

    public function get_proyecto_nombre($id_proyecto) {
        $this->db->select('nombre');
        $this->db->from('ema.proyectos');
        $this->db->where('gid', $id_proyecto);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->nombre;
        }
        return null;
    }
}
