<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Consultores extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('man_espacial/Consultores_model');
        $this->lang->load('man_espacial/consultores');
		// inicializamos la librería
        $this->load->library('Classes/PHPExcel.php');
		$this->load->library('pagination');


        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('man_espacial/consultores/menu_consultores'));
        $this->data['pagetitle'] = $this->page_title->show();

        if ($_SESSION['id_modulo'] != 'CONSULTORES') {
			$_SESSION['arraywhere_consultores'] 		= NULL;
			$_SESSION['arraywhere_consultores_busq'] 	= NULL;
			$_SESSION['id_modulo'] = 'CONSULTORES';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_consultores'), 'admin/consultores');
    }
 	
public function index()
    {

        // Obtener los filtros desde el formulario
        $filters = [
            'cedularuc' => $this->input->get('cedularuc'),
            'nombre' => $this->input->get('nombre'),
            'apellido' => $this->input->get('apellido'),
            'email' => $this->input->get('email')
        ];

        $user_id= $this->session->userdata('user_id');
        $tipo_usuario = $_SESSION['tipo_usuario'][0];
        $id_cliente = $_SESSION['id_cliente'][0];

        if ($tipo_usuario == 'C') {
            $filters['id_cliente'] = $id_cliente;                                 
        }


            /*
            echo '<pre>';
            echo 'Contenido de $_SESSION: ';
            print_r($_SESSION);
            //echo '</pre>';

            echo 'filters: ';
            print_r($filters);            
            echo '</pre>';
            */
            
            //show();

        $this->data['lang'] = $this->lang->load('man_espacial/consultores', 'spanish'); // Ajusta el idioma
        $this->data['charset'] = 'UTF-8';
        $this->data['mobile'] = FALSE;
		$config['base_url'] = site_url('man_espacial/consultores/index');      
        $config['total_rows'] = $this->Consultores_model->count_consultores($filters);
		$config['per_page'] = 10;


		$this->pagination->initialize($config);
		$data['consultores'] = $this->Consultores_model->get_consultores($filters, $config['per_page'], $this->uri->segment(4));
		$data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;

		
        /* $this->load->view('clientes/index', $data); */
        $this->template->admin_render('man_espacial/consultores/index2', array_merge($data, $this->data));
    }

	public function index2()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

			$user_id= $this->session->userdata('user_id');
			$tipo_usuario = $_SESSION['tipo_usuario'][0];
			$id_cliente = $_SESSION['id_cliente'][0];

			if ($tipo_usuario == 'C' && !$_POST) {
				$arraywhere = $_SESSION['arraywhere_consultores'];
				$arraywherebusq = $_SESSION['arraywhere_consultores_busq'];					

				if (isset($id_cliente) && !empty($id_cliente)) {
					$arraywhere['id_cliente'] = $id_cliente;
					$arraywherebusq['id_cliente'] = $id_cliente;
				} else {
					echo 'Error: id_cliente no está configurado en la sesión.';
					exit();
				}
				$_SESSION['arraywhere_consultores'] = $arraywhere;
				$_SESSION['arraywhere_consultores_busq'] = $arraywherebusq;					
			}
			

			if ($_POST) {
             	//$arraywhere = NULL;
				
				if ($_POST['id_consultor']) 
				{
					$arraywhere['id_consultor'] 										= $_POST['id_consultor'];
					$arraywherebusq['cast(id_consultor as varchar) like '] 						= '%'.$_POST['id_consultor'].'%';
				}				
				if ($_POST['cedularuc']) 
				{
					if (is_numeric($_POST['cedularuc'])) {
						$arraywhere['cedularuc'] 								= $_POST['cedularuc'];
						$arraywherebusq['cast(cedularuc as varchar) like '] 	= '%'.$_POST['cedularuc'].'%';
					}
				}
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 										= $_POST['nombre'];
					$arraywherebusq['lower(nombre) like '] 						= '%'.strtolower($_POST['nombre']).'%';
				}
				if ($_POST['apellido']) 
				{
					$arraywhere['apellido'] 									= $_POST['apellido'];
					$arraywherebusq['lower(apellido) like ']					= '%'.strtolower($_POST['apellido']).'%';
				}
				if ($_POST['email']) 
				{
					$arraywhere['email'] 										= $_POST['email'];
					$arraywherebusq['lower(email) like '] 						= '%'.strtolower($_POST['email']).'%';
				}				
				if ($_POST['des_fecha_nac']) 
				{
					$arraywhere['des_fecha_nac'] 									= $_POST['des_fecha_nac'];
					$arraywherebusq['lower(des_fecha_nac) like ']					= '%'.strtolower($_POST['des_fecha_nac']).'%';
				}
				if ($_POST['des_sexo']) 
				{
					$arraywhere['des_sexo']											= $_POST['des_sexo'];
					$arraywherebusq['lower(des_sexo) like ']						= '%'.strtolower($_POST['des_sexo']).'%';
				}
				if ($_POST['des_tipo_persona']) 
				{
					$arraywhere['des_tipo_persona']									= $_POST['des_tipo_persona'];
					$arraywherebusq['lower(des_tipo_persona) like ']				= '%'.strtolower($_POST['des_tipo_persona']).'%';
				}
				if ($_POST['telefono']) 
				{
					if (is_numeric($_POST['telefono'])) {
						$arraywhere['telefono'] 								= $_POST['telefono'];
						$arraywherebusq['cast(telefono as varchar) like '] 		= '%'.$_POST['telefono'].'%';
					}
				}
				if ($_POST['direccion']) 
				{
					$arraywhere['direccion'] 									= $_POST['direccion'];
					$arraywherebusq['lower(direccion) like '] 					= '%'.strtolower($_POST['direccion']).'%';
				}
				if ($_POST['des_tipo_empresa']) 
				{
					$arraywhere['des_tipo_empresa'] 								= $_POST['des_tipo_empresa'];
					$arraywherebusq['lower(des_tipo_empresa) like '] 				= '%'.strtolower($_POST['des_tipo_empresa']).'%';
				}
				if ($_POST['nacionalidad']) 
				{
					$arraywhere['nacionalidad'] 								= $_POST['nacionalidad'];
					$arraywherebusq['lower(nacionalidad) like '] 				= '%'.strtolower($_POST['nacionalidad']).'%';
				}
				if ($_POST['rlegal_cedula']) 
				{
					if (is_numeric($_POST['rlegal_cedula'])) {
						$arraywhere['rlegal_cedula'] 							= $_POST['rlegal_cedula'];
						$arraywherebusq['cast(rlegal_cedula as varchar) like '] = '%'.$_POST['rlegal_cedula'].'%';
					}
				}
				if ($_POST['rlegal_nombre']) 
				{
					$arraywhere['rlegal_nombre'] 								= $_POST['rlegal_nombre'];
					$arraywherebusq['lower(rlegal_nombre) like '] 				= '%'.strtolower($_POST['rlegal_nombre']).'%';
				}
				if ($_POST['rlegal_apellido']) 
				{
					$arraywhere['rlegal_apellido'] 								= $_POST['rlegal_apellido'];
					$arraywherebusq['lower(rlegal_apellido) like '] 			= '%'.strtolower($_POST['rlegal_apellido']).'%';
				}
				if ($_POST['des_rlegal_sexo']) 
				{
					$arraywhere['rlegal_sexo'] 									= $_POST['des_rlegal_sexo'];
					$arraywherebusq['lower(rlegal_sexo) like '] 				= '%'.strtolower($_POST['des_rlegal_sexo']).'%';
					if (trim($_POST['des_rlegal_sexo']) == '') {
						$arraycampos['rlegal_sexo']   = null;
					} else {
						$arraycampos['rlegal_sexo']   = $_POST['des_rlegal_sexo'];
					}					
				}

				$_SESSION['arraywhere_consultores	'] = $arraywhere;
				$_SESSION['arraywhere_consultores_busq'] = $arraywherebusq;


				redirect('man_espacial/consultores/index');				
			}

			if ($tipo_usuario == 'C' && !$_POST) {
				$arraywhere = $_SESSION['arraywhere_consultores'];
				$arraywherebusq = $_SESSION['arraywhere_consultores_busq'];					

				if (isset($id_cliente) && !empty($id_cliente)) {
					$arraywhere['id_cliente'] = $id_cliente;
					$arraywherebusq['id_cliente'] = $id_cliente;
				} else {
					echo 'Error: id_cliente no está configurado en la sesión.';
					exit();
				}
				$_SESSION['arraywhere_consultores'] = $arraywhere;
				$_SESSION['arraywhere_consultores_busq'] = $arraywherebusq;					
			}
			
			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				7, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/consultores/index/',  // url completa de la pagina paginada
				'v_consultores_index',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_consultores_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['consultores']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'v_consultores_index',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_consultores_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/consultores/index', $this->data);
		}
	}


	//////----------------------------------------//////
	//////                 create()               //////
	//////----------------------------------------//////

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_consultores'), 'consultores/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();



		/* Validate form input */
		//$this->form_validation->set_rules('id_proponente' , 'lang:proponentes_e' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'required|is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date');

		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[100]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[100]');
		$this->form_validation->set_rules('rlegal_cedula', 'Representante Legal Cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'Representante Legal Nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'Representante Legal Apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'Representante Legal Sexo', 'max_length[1]');
		if ($this->form_validation->run() == TRUE)
		{			
			if (isset($_POST) && ! empty($_POST))
			{

				//if ($_POST['id_consultor']) {
				//	$arraycampos['id_consultor']				= $_POST['id_consultor'];
				//}

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']					= $_POST['cedularuc'];
				}	

				if ($_POST['nombre']) {
					$arraycampos['nombre']						= $_POST['nombre'];
				}

				if ($_POST['apellido']) {
					$arraycampos['apellido']					= $_POST['apellido'];
				}

				if ($_POST['email']) {
					$arraycampos['email']						= $_POST['email'];
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']					= $_POST['fecha_nac'];
				}

				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']						= $_POST['dp_sexo'];
				}

				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']				= $_POST['dp_tipo_persona'];
				}

				if ($_POST['telefono']) {
					$arraycampos['telefono']					= $_POST['telefono'];
				}

				if ($_POST['direccion']) {
					$arraycampos['direccion']					= $_POST['direccion'];
				}

				if ($_POST['dp_tipo_empresa']) {
					$arraycampos['tipo_empresa']				= $_POST['dp_tipo_empresa'];
				}

				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']				= $_POST['nacionalidad'];
				}

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']				= $_POST['rlegal_cedula'];
				}

				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre']				= $_POST['rlegal_nombre'];
				}

				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido']				= $_POST['rlegal_apellido'];
				}

				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo']					= $_POST['dp_rlegal_sexo'];
				}

				$arraycampos['id_consultor'] = $this->Consultores_model->obtener_nextval('ema.consultores_id_consultor_seq');

				$new_consultores_id = $this->Consultores_model->create_consultores($arraycampos);
				if ($new_consultores_id)
				{
					$this->session->set_flashdata('message', $this->ion_auth->messages());
					redirect('man_espacial/consultores/index');
				}
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			//creando campos
			$this->data['id_consultor'] = array(
				'type'     => 'text',
				'name'     => 'id_consultor',
				'id'       => 'id_consultor',
				'value'    => $this->form_validation->set_value('id_consultor'),
				//'data-src' => $consultores->id_consultor,
				'class'    => 'form-control',
				'disabled'    => true
			);

			$this->data['cedularuc'] = array(
				'type'     => 'text',
				'name'     => 'cedularuc',
				'id'       => 'cedularuc',
				'value'    => $this->form_validation->set_value('cedularuc'),
				//'data-src' => $consultores->cedularuc,
				'class'    => 'form-control'
			);
			 
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('nombre'),
				//'data-src' => $consultores->nombre,
				'class'    => 'form-control'
			);
			 
			$this->data['apellido'] = array(
				'type'     => 'text',
				'name'     => 'apellido',
				'id'       => 'apellido',
				'value'    => $this->form_validation->set_value('apellido'),
				//'data-src' => $consultores->apellido,
				'class'    => 'form-control'
			);
			 
			$this->data['email'] = array(
				'type'     => 'text',
				'name'     => 'email',
				'id'       => 'email',
				'value'    => $this->form_validation->set_value('email'),
				//'data-src' => $consultores->email,
				'class'    => 'form-control'
			);
			 
			$this->data['fecha_nac'] = array(
				'type'     => 'text',
				'name'     => 'fecha_nac',
				'id'       => 'fecha_nac',				
				'value'    => $this->form_validation->set_value('fecha_nac'),
				//'value'    => formato_fecha($this->form_validation->set_value('fecha_nac')),				
				//'value'    => $this->form_validation->set_value('fecha_nac', $consultores->fecha_nac),
				//'value'    => formato_fecha($this->form_validation->set_value('fecha_nac', $consultores->fecha_nac)),				
				'class'    => 'form-control'				
			);

			 
			$d_sexo = $this->Consultores_model->concepto('SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_sexo as $r_sexo) {
				$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
			}
			$this->data['sexo'] = $a_sexo;


			$d_tipopersona = $this->Consultores_model->concepto('TIPO_PERSONA', false, 'CONCEPTO')->result_array();

			// Inserta en un array asociativo para usarlo en el form_dropdown
			$a_tipopersona = [];
			foreach ($d_tipopersona as $r_tipopersona) {
				$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'] . ' - ' . $r_tipopersona['nombre'];
			}

			// Obtén la primera clave del array como valor predeterminado
			reset($a_tipopersona); // Coloca el puntero al primer elemento del array
			$default_tipo_persona = key($a_tipopersona); // Obtiene la clave del primer elemento

			$this->data['tipo_persona'] = $a_tipopersona;
			$this->data['tipo_persona_sel'] = $default_tipo_persona;

			$this->data['telefono'] = array(
				'type'     => 'text',
				'name'     => 'telefono',
				'id'       => 'telefono',
				'value'    => $this->form_validation->set_value('telefono'),
				//'data-src' => $consultores->telefono,
				'class'    => 'form-control'
			);
			 
			$this->data['direccion'] = array(
				'type'     => 'text',
				'name'     => 'direccion',
				'id'       => 'direccion',
				'value'    => $this->form_validation->set_value('direccion'),
				//'data-src' => $consultores->direccion,
				'class'    => 'form-control'
			);

			 
			$d_tipoempresa = $this->Consultores_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipoempresa as $r_tipoempresa) {
				$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
			}
			$this->data['tipo_empresa'] = $a_tipoempresa;

			$a_clientes[''] = 'Seleccione el Cliente';
			$d_clientes = $this->Consultores_model->dropdown_data('cliente')->result_array();

			foreach ($d_clientes as $r_cliente) {
				$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'] . ' - ' . $r_cliente['nombre'];
			}

			$this->data['cliente'] = $a_clientes;

			

			 
			$this->data['nacionalidad'] = array(
				'type'     => 'text',
				'name'     => 'nacionalidad',
				'id'       => 'nacionalidad',
				'value'    => $this->form_validation->set_value('nacionalidad'),
				//'data-src' => $consultores->nacionalidad,
				'class'    => 'form-control'
			);


			$this->data['rlegal_cedula'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_cedula',
				'id'       => 'rlegal_cedula',
				'value'    => $this->form_validation->set_value('rlegal_cedula'),
				//'data-src' => $consultores->rlegal_cedula,
				'class'    => 'form-control'
			);	

			 
			$this->data['rlegal_nombre'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_nombre',
				'id'       => 'rlegal_nombre',
				'value'    => $this->form_validation->set_value('rlegal_nombre'),
				//'data-src' => $consultores->rlegal_nombre,
				'class'    => 'form-control'
			);

			 
			$this->data['rlegal_apellido'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_apellido',
				'id'       => 'rlegal_apellido',
				'value'    => $this->form_validation->set_value('rlegal_apellido'),
				//'data-src' => $consultores->rlegal_apellido,
				'class'    => 'form-control'
			);

			 
			$dp_rlegal_sexo = $this->Consultores_model->concepto('SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($dp_rlegal_sexo as $r_rlegal_sexo) {
				$a_rlegal_sexo[$r_rlegal_sexo['concepto']] = $r_rlegal_sexo['concepto'].' - '.$r_rlegal_sexo['nombre'];
			}
			$this->data['rlegal_sexo'] = $a_rlegal_sexo;

			/* Load Template */
			$this->template->admin_render('man_espacial/consultores/create', $this->data);
		}
	}



    // Función de validación personalizada
    public function valid_date($date) {
        // Validar la fecha en formato dd/mm/yyyy
        $d = DateTime::createFromFormat('d/m/Y', $date);
		/*
	        echo '<pre>';
	        print_r( $d1 );
	        echo '</pre>';
	        show_error(1); 
		*/
        if ($d !== false) {
        //if (preg_match('/\d{2}-\d{2}-\d{4}/', $d1)) {
            // Verificar si la fecha es válida
            //$d = DateTime::createFromFormat('d-m-Y', $d1);

            //return $d && $d->format('d-m-Y') === $d1;
            return $d->format('d-m-Y');
        } else {
            $this->form_validation->set_message('valid_date', 'El campo {field} debe contener una fecha válida en formato dd/mm/yyyy.');
            return FALSE;
        }
    }

	public function get_clientes_autocomplete()
{
    // Verifica que sea una solicitud AJAX
    
        $term = $this->input->get('term'); // Obtiene el término de búsqueda

        $this->load->model('Consultores_model');

        // Realiza la consulta
        $clientes = $this->Consultores_model->buscar_clientes($term);

        // Prepara la respuesta
        $result = [];
        foreach ($clientes as $cliente) {
            $result[] = [
                'id' => $cliente->id_cliente,
                'label' => $cliente->nombre . ' ' . $cliente->apellido . ' - ' . $cliente->cedularuc,
                'value' => $cliente->nombre,
                'cedularuc' => $cliente->cedularuc,
                'apellido' => $cliente->apellido,
                'email' => $cliente->email,
                'telefono' => $cliente->telefono,
            ];
        }

        // Devuelve los datos en formato JSON
        echo json_encode($result);
    
}

	//////----------------------------------------//////
	//////                 edit()                 //////
	//////----------------------------------------//////
	
	public function edit($consultor)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $consultor OR empty($consultor))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_consultores_edit'), 'consultores/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$consultores = $this->Consultores_model->view('consultores', array('id_consultor' => $consultor))->row();
		$this->data['consultor'] = $consultores;
		/* Validate form input */
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date');
		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[30]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[30]');
		$this->form_validation->set_rules('rlegal_cedula', 'Representante Legal Cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'Representante Legal Nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'Representante Legal Apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'Representante Legal Sexo', 'max_length[1]');

		//Se produce cuando el usuario da click en el submit
		if ($this->form_validation->run() == TRUE)
		{
			if (isset($_POST) && ! empty($_POST))			
			{

				//if ($_POST['id_consultor']) {
				//	$arraycampos['id_consultor']			= strtoupper($_POST['id_consultor']);
				//}

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']				= $_POST['cedularuc'];
				}else{
					$arraycampos['cedularuc']		= 	NULL;
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']					= $_POST['nombre'];
				}else{
					$arraycampos['nombre']		= 	NULL;
				}

				if ($_POST['apellido']) {
					$arraycampos['apellido']				= $_POST['apellido'];
				}else{
					$arraycampos['apellido']		= 	NULL;
				}

				if ($_POST['email']) {
					$arraycampos['email']					= $_POST['email'];
				}else{
					$arraycampos['email']		= 	NULL;
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']				= $_POST['fecha_nac'];
				}else{
					$arraycampos['fecha_nac']		= 	NULL;
				}

				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']					= $_POST['dp_sexo'];
				}

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}

				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']			= $_POST['dp_tipo_persona'];
				}else{
					$arraycampos['tipo_persona']		= 	NULL;
				}

				if ($_POST['telefono']) {
					$arraycampos['telefono']				= $_POST['telefono'];
				}else{
					$arraycampos['telefono']		= 	NULL;
				}

				if ($_POST['direccion']) {
					$arraycampos['direccion']				= $_POST['direccion'];
				}else{
					$arraycampos['direccion']		= 	NULL;
				}

				if ($_POST['dp_tipo_empresa']) {
					$arraycampos['tipo_empresa']			= $_POST['dp_tipo_empresa'];
				}else{
					$arraycampos['tipo_empresa']		= 	NULL;
				}

				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']			= $_POST['nacionalidad'];
				}else{
					$arraycampos['nacionalidad']		= 	NULL;
				}	

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']			= $_POST['rlegal_cedula'];
				}else{
					$arraycampos['rlegal_cedula']		= 	NULL;
				}

				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre']			= $_POST['rlegal_nombre'];
				}else{
					$arraycampos['rlegal_nombre']		= 	NULL;
				}	

				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido']			= $_POST['rlegal_apellido'];
				}else{
					$arraycampos['rlegal_apellido']		= 	NULL;
				}	

				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo']				= $_POST['dp_rlegal_sexo'];
				}else{
					$arraycampos['rlegal_sexo']		= 	NULL;
				}	


				$consultor_update = $this->Consultores_model->update_consultores($consultores->id_consultor,$arraycampos);

				if ($consultor_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('consultores_update_successful'));
					redirect('man_espacial/consultores/edit/'.$consultores->id_consultor); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		} else {

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['consultores']   = $consultores;
			
			//creando campos
			$this->data['id_consultor'] = array(
				'type'     => 'text',
				'name'     => 'id_consultor',
				'id'       => 'id_consultor',
				'value'    => $this->form_validation->set_value('id_consultor', $consultores->id_consultor),
				'data-src' => $consultores->id_consultor,
				'class'    => 'form-control',
				'disabled'    => true
			);

			$this->data['cedularuc'] = array(
				'type'     => 'text',
				'name'     => 'cedularuc',
				'id'       => 'cedularuc',
				'value'    => $this->form_validation->set_value('cedularuc', $consultores->cedularuc),
				'data-src' => $consultores->cedularuc,
				'class'    => 'form-control'
			);
			 
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('nombre', $consultores->nombre),
				'data-src' => $consultores->nombre,
				'class'    => 'form-control'
			);
			 
			$this->data['apellido'] = array(
				'type'     => 'text',
				'name'     => 'apellido',
				'id'       => 'apellido',
				'value'    => $this->form_validation->set_value('apellido', $consultores->apellido),
				'data-src' => $consultores->apellido,
				'class'    => 'form-control'
			);
			 
			$this->data['email'] = array(
				'type'     => 'text',
				'name'     => 'email',
				'id'       => 'email',
				'value'    => $this->form_validation->set_value('email', $consultores->email),
				'data-src' => $consultores->email,
				'class'    => 'form-control'
			);
			 
			$this->data['fecha_nac'] = array(
				'type'     => 'DAtetime',
				'name'     => 'fecha_nac',
				'id'       => 'fecha_nac',
				//'value'    => $this->form_validation->set_value('fecha_nac', $consultores->fecha_nac),
				'value'    => formato_fecha($this->form_validation->set_value('fecha_nac', $consultores->fecha_nac)),
				//'data-src' => $consultores->fecha_nac,
				'class'    => 'form-control'
			);
			 
			$d_sexo = $this->Consultores_model->concepto('SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_sexo as $r_sexo) {
				$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
			}
			$this->data['sexo'] = $a_sexo;
			$this->data['sexo_sel'] = $consultores->sexo;	
			 
			$d_tipopersona = $this->Consultores_model->concepto('TIPO_PERSONA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipopersona as $r_tipopersona) {
				$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'].' - '.$r_tipopersona['nombre'];
			}
			$this->data['tipo_persona'] = $a_tipopersona;
			$this->data['tipo_persona_sel'] = $consultores->tipo_persona;

			$this->data['telefono'] = array(
				'type'     => 'text',
				'name'     => 'telefono',
				'id'       => 'telefono',
				'value'    => $this->form_validation->set_value('telefono', $consultores->telefono),
				'data-src' => $consultores->telefono,
				'class'    => 'form-control'
			);
			 
			$this->data['direccion'] = array(
				'type'     => 'text',
				'name'     => 'direccion',
				'id'       => 'direccion',
				'value'    => $this->form_validation->set_value('direccion', $consultores->direccion),
				'data-src' => $consultores->direccion,
				'class'    => 'form-control'
			);
			 

			$d_tipoempresa = $this->Consultores_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipoempresa as $r_tipoempresa) {
				$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
			}
			$this->data['tipo_empresa'] = $a_tipoempresa;
			$this->data['tipo_empresa_sel'] = $consultores->tipo_empresa;	

			$a_clientes[''] = 'Seleccione el Cliente';
			$d_clientes = $this->Consultores_model->dropdown_data('cliente')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_clientes as $r_cliente) {
				$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
			}
			$this->data['cliente'] = $a_clientes;
			$this->data['cliente_sel'] = $consultores->id_cliente;
				 
			$this->data['nacionalidad'] = array(
				'type'     => 'text',
				'name'     => 'nacionalidad',
				'id'       => 'nacionalidad',
				'value'    => $this->form_validation->set_value('nacionalidad', $consultores->nacionalidad),
				'data-src' => $consultores->nacionalidad,
				'class'    => 'form-control'
			);

			$this->data['rlegal_cedula'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_cedula',
				'id'       => 'rlegal_cedula',
				'value'    => $this->form_validation->set_value('rlegal_cedula', $consultores->rlegal_cedula),
				'data-src' => $consultores->rlegal_cedula,
				'class'    => 'form-control'
			);
			 
			$this->data['rlegal_nombre'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_nombre',
				'id'       => 'rlegal_nombre',
				'value'    => $this->form_validation->set_value('rlegal_nombre', $consultores->rlegal_nombre),
				'data-src' => $consultores->rlegal_nombre,
				'class'    => 'form-control'
			);
			 
			$this->data['rlegal_apellido'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_apellido',
				'id'       => 'rlegal_apellido',
				'value'    => $this->form_validation->set_value('rlegal_apellido', $consultores->rlegal_apellido),
				'data-src' => $consultores->rlegal_apellido,
				'class'    => 'form-control'
			);

			 
			$d_rlegal_sexo = $this->Consultores_model->concepto('SEXO',true,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_rlegal_sexo as $r_rlegal_sexo) {
				$a_rlegal_sexo[$r_rlegal_sexo['concepto']] = $r_rlegal_sexo['concepto'].' - '.$r_rlegal_sexo['nombre'];
			}
			$this->data['rlegal_sexo'] = $a_rlegal_sexo;
			$this->data['rlegal_sexo_sel'] = $consultores->rlegal_sexo;
		}

		/* Load Template */
		$this->template->admin_render('man_espacial/consultores/edit', $this->data);
	}

	public function view($consultor)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $consultor OR empty($consultor))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_consultores_edit'), 'consultores/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$consultores = $this->Consultores_model->view('consultores', array('id_consultor' => $consultor))->row();
		$this->data['consultor'] = $consultores;
		/* Validate form input */
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('cedularuc' , 'lang:proponentes_cedularuc' , 'is_numeric|min_length[4]|max_length[9]|regex_match[/^([0-9]{4,9})?$/]');
		$this->form_validation->set_rules('nombre' , 'lang:proponentes_nombre' , 'max_length[100]');
		$this->form_validation->set_rules('apellido' , 'lang:proponentes_apellido' , 'max_length[100]');
		$this->form_validation->set_rules('email' , 'lang:proponentes_email' , 'max_length[100]');
		$this->form_validation->set_rules('fecha_nac', 'Date');
		$this->form_validation->set_rules('sexo' , 'lang:proponentes_sexo' , 'max_length[1]');
		$this->form_validation->set_rules('tipo_persona' , 'lang:proponentes_tipo_persona' , 'max_length[1]');
		$this->form_validation->set_rules('telefono' , 'lang:proponentes_telefono' , 'max_length[30]');
		$this->form_validation->set_rules('direccion' , 'lang:proponentes_direccion' , 'max_length[100]');
		$this->form_validation->set_rules('tipo_empresa' , 'lang:proponentes_tipo_empresa' , 'max_length[1]');
		$this->form_validation->set_rules('nacionalidad' , 'lang:proponentes_nacionalidad' , 'max_length[30]');
		$this->form_validation->set_rules('rlegal_cedula', 'Representante Legal Cedula', 'max_length[10]');
        $this->form_validation->set_rules('rlegal_nombre', 'Representante Legal Nombre', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_apellido', 'Representante Legal Apellido', 'max_length[100]');
        $this->form_validation->set_rules('rlegal_sexo', 'Representante Legal Sexo', 'max_length[1]');

		//Se produce cuando el usuario da click en el submit
		if ($this->form_validation->run() == TRUE)
		{
			if (isset($_POST) && ! empty($_POST))			
			{

				//if ($_POST['id_consultor']) {
				//	$arraycampos['id_consultor']			= strtoupper($_POST['id_consultor']);
				//}

				if ($_POST['cedularuc']) {
					$arraycampos['cedularuc']				= $_POST['cedularuc'];
				}else{
					$arraycampos['cedularuc']		= 	NULL;
				}

				if ($_POST['nombre']) {
					$arraycampos['nombre']					= $_POST['nombre'];
				}else{
					$arraycampos['nombre']		= 	NULL;
				}

				if ($_POST['apellido']) {
					$arraycampos['apellido']				= $_POST['apellido'];
				}else{
					$arraycampos['apellido']		= 	NULL;
				}

				if ($_POST['email']) {
					$arraycampos['email']					= $_POST['email'];
				}else{
					$arraycampos['email']		= 	NULL;
				}

				if ($_POST['fecha_nac']) {
					$arraycampos['fecha_nac']				= $_POST['fecha_nac'];
				}else{
					$arraycampos['fecha_nac']		= 	NULL;
				}

				if ($_POST['dp_sexo']) {
					$arraycampos['sexo']					= $_POST['dp_sexo'];
				}

				if ($_POST['dp_clientes']) {
					$arraycampos['id_cliente']		= $_POST['dp_clientes'];
				}else{
					$arraycampos['id_cliente']		= 	NULL;
				}

				if ($_POST['dp_tipo_persona']) {
					$arraycampos['tipo_persona']			= $_POST['dp_tipo_persona'];
				}else{
					$arraycampos['tipo_persona']		= 	NULL;
				}

				if ($_POST['telefono']) {
					$arraycampos['telefono']				= $_POST['telefono'];
				}else{
					$arraycampos['telefono']		= 	NULL;
				}

				if ($_POST['direccion']) {
					$arraycampos['direccion']				= $_POST['direccion'];
				}else{
					$arraycampos['direccion']		= 	NULL;
				}

				if ($_POST['dp_tipo_empresa']) {
					$arraycampos['tipo_empresa']			= $_POST['dp_tipo_empresa'];
				}else{
					$arraycampos['tipo_empresa']		= 	NULL;
				}

				if ($_POST['nacionalidad']) {
					$arraycampos['nacionalidad']			= $_POST['nacionalidad'];
				}else{
					$arraycampos['nacionalidad']		= 	NULL;
				}	

				if ($_POST['rlegal_cedula']) {
					$arraycampos['rlegal_cedula']			= $_POST['rlegal_cedula'];
				}else{
					$arraycampos['rlegal_cedula']		= 	NULL;
				}

				if ($_POST['rlegal_nombre']) {
					$arraycampos['rlegal_nombre']			= $_POST['rlegal_nombre'];
				}else{
					$arraycampos['rlegal_nombre']		= 	NULL;
				}	

				if ($_POST['rlegal_apellido']) {
					$arraycampos['rlegal_apellido']			= $_POST['rlegal_apellido'];
				}else{
					$arraycampos['rlegal_apellido']		= 	NULL;
				}	

				if ($_POST['dp_rlegal_sexo']) {
					$arraycampos['rlegal_sexo']				= $_POST['dp_rlegal_sexo'];
				}else{
					$arraycampos['rlegal_sexo']		= 	NULL;
				}	


				$consultor_update = $this->Consultores_model->update_consultores($consultores->id_consultor,$arraycampos);

				if ($consultor_update)
				{

					$this->session->set_flashdata('message', $this->lang->line('consultores_update_successful'));
					redirect('man_espacial/consultores/edit/'.$consultores->id_consultor); 
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		} else {

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['consultores']   = $consultores;
			
			//creando campos
			$this->data['id_consultor'] = array(
				'type'     => 'text',
				'name'     => 'id_consultor',
				'id'       => 'id_consultor',
				'value'    => $this->form_validation->set_value('id_consultor', $consultores->id_consultor),
				'data-src' => $consultores->id_consultor,
				'class'    => 'form-control',
				'disabled'    => true
			);

			$this->data['cedularuc'] = array(
				'type'     => 'text',
				'name'     => 'cedularuc',
				'id'       => 'cedularuc',
				'value'    => $this->form_validation->set_value('cedularuc', $consultores->cedularuc),
				'data-src' => $consultores->cedularuc,
				'class'    => 'form-control'
			);
			 
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('nombre', $consultores->nombre),
				'data-src' => $consultores->nombre,
				'class'    => 'form-control'
			);
			 
			$this->data['apellido'] = array(
				'type'     => 'text',
				'name'     => 'apellido',
				'id'       => 'apellido',
				'value'    => $this->form_validation->set_value('apellido', $consultores->apellido),
				'data-src' => $consultores->apellido,
				'class'    => 'form-control'
			);
			 
			$this->data['email'] = array(
				'type'     => 'text',
				'name'     => 'email',
				'id'       => 'email',
				'value'    => $this->form_validation->set_value('email', $consultores->email),
				'data-src' => $consultores->email,
				'class'    => 'form-control'
			);
			 
			$this->data['fecha_nac'] = array(
				'type'     => 'DAtetime',
				'name'     => 'fecha_nac',
				'id'       => 'fecha_nac',
				//'value'    => $this->form_validation->set_value('fecha_nac', $consultores->fecha_nac),
				'value'    => formato_fecha($this->form_validation->set_value('fecha_nac', $consultores->fecha_nac)),
				//'data-src' => $consultores->fecha_nac,
				'class'    => 'form-control'
			);
			 
			$d_sexo = $this->Consultores_model->concepto('SEXO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_sexo as $r_sexo) {
				$a_sexo[$r_sexo['concepto']] = $r_sexo['concepto'].' - '.$r_sexo['nombre'];
			}
			$this->data['sexo'] = $a_sexo;
			$this->data['sexo_sel'] = $consultores->sexo;	
			 
			$d_tipopersona = $this->Consultores_model->concepto('TIPO_PERSONA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipopersona as $r_tipopersona) {
				$a_tipopersona[$r_tipopersona['concepto']] = $r_tipopersona['concepto'].' - '.$r_tipopersona['nombre'];
			}
			$this->data['tipo_persona'] = $a_tipopersona;
			$this->data['tipo_persona_sel'] = $consultores->tipo_persona;

			$this->data['telefono'] = array(
				'type'     => 'text',
				'name'     => 'telefono',
				'id'       => 'telefono',
				'value'    => $this->form_validation->set_value('telefono', $consultores->telefono),
				'data-src' => $consultores->telefono,
				'class'    => 'form-control'
			);
			 
			$this->data['direccion'] = array(
				'type'     => 'text',
				'name'     => 'direccion',
				'id'       => 'direccion',
				'value'    => $this->form_validation->set_value('direccion', $consultores->direccion),
				'data-src' => $consultores->direccion,
				'class'    => 'form-control'
			);
			 

			$d_tipoempresa = $this->Consultores_model->concepto('TIPO_EMPRESA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_tipoempresa as $r_tipoempresa) {
				$a_tipoempresa[$r_tipoempresa['concepto']] = $r_tipoempresa['concepto'].' - '.$r_tipoempresa['nombre'];
			}
			$this->data['tipo_empresa'] = $a_tipoempresa;
			$this->data['tipo_empresa_sel'] = $consultores->tipo_empresa;	

			$a_clientes[''] = 'Seleccione el Cliente';
			$d_clientes = $this->Consultores_model->dropdown_data('cliente')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_clientes as $r_cliente) {
				$a_clientes[$r_cliente['id_cliente']] = $r_cliente['id_cliente'].' - '.$r_cliente['nombre'].' '.$r_cliente['apellido'];
			}
			$this->data['cliente'] = $a_clientes;
			$this->data['cliente_sel'] = $consultores->id_cliente;
				 
			$this->data['nacionalidad'] = array(
				'type'     => 'text',
				'name'     => 'nacionalidad',
				'id'       => 'nacionalidad',
				'value'    => $this->form_validation->set_value('nacionalidad', $consultores->nacionalidad),
				'data-src' => $consultores->nacionalidad,
				'class'    => 'form-control'
			);

			$this->data['rlegal_cedula'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_cedula',
				'id'       => 'rlegal_cedula',
				'value'    => $this->form_validation->set_value('rlegal_cedula', $consultores->rlegal_cedula),
				'data-src' => $consultores->rlegal_cedula,
				'class'    => 'form-control'
			);
			 
			$this->data['rlegal_nombre'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_nombre',
				'id'       => 'rlegal_nombre',
				'value'    => $this->form_validation->set_value('rlegal_nombre', $consultores->rlegal_nombre),
				'data-src' => $consultores->rlegal_nombre,
				'class'    => 'form-control'
			);
			 
			$this->data['rlegal_apellido'] = array(
				'type'     => 'text',
				'name'     => 'rlegal_apellido',
				'id'       => 'rlegal_apellido',
				'value'    => $this->form_validation->set_value('rlegal_apellido', $consultores->rlegal_apellido),
				'data-src' => $consultores->rlegal_apellido,
				'class'    => 'form-control'
			);

			 
			$d_rlegal_sexo = $this->Consultores_model->concepto('SEXO',true,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($d_rlegal_sexo as $r_rlegal_sexo) {
				$a_rlegal_sexo[$r_rlegal_sexo['concepto']] = $r_rlegal_sexo['concepto'].' - '.$r_rlegal_sexo['nombre'];
			}
			$this->data['rlegal_sexo'] = $a_rlegal_sexo;
			$this->data['rlegal_sexo_sel'] = $consultores->rlegal_sexo;
		}

		/* Load Template */
		$this->template->admin_render('man_espacial/consultores/view', $this->data);
	}

    /* public function views($id) {
        $data['consultor'] = $this->Consultores_model->get_consultor_by_id($id);
        if (!$data['consultor']) {
            show_404();
        }
        $this->template->admin_render('man_espacial/consultores/views', $this->data);
    } */

	//////----------------------------------------//////
	//////                 delete()               //////
	//////----------------------------------------//////
	public function delete($consultor)
	{
		$cnt_reg = $this->Consultores_model->cnt_consultores_reg_layers($consultor);
		if ($cnt_reg == 0) {

			$eliminar_consultor = $this->Consultores_model->eliminar_consultores($consultor);
			$this->session->set_flashdata('message', 'Se elimino el Consultor! <b>');
			redirect('man_espacial/consultores/index/');
		}else{
			$this->session->set_flashdata('message', 'NO se pude eliminar porque tiene registros dependientes! <b>');
			redirect('man_espacial/consultores/index/');
		}
	}



	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 
	public function verconsultores_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/ema/index.html?tipo_consulta=lotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}


	public function generar_consultores ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimirema/Mapa_A3_f2_generar_consultor_tipo.php";
			redirect($i_jameuge);
	}
/* 
	public function view($consultor_id) {
		if (!$consultor_id) {
			redirect('consultores', 'refresh');
		}
	
		// Obtener datos del consultor
		$consultor = $this->Consultores_model->view_consultor(['id_consultor' => $consultor_id]);
	
		if (!$consultor) {
			$this->session->set_flashdata('message', 'Consultor no encontrado');
			redirect('consultores');
		}
	
		// Preparar datos para la vista
		$data['consultor'] = $consultor;
		$data['breadcrumb'] = $this->breadcrumbs->show();
	
		// Cargar la vista (asegúrate de que la ruta y el nombre del archivo sean correctos)
		$this->template->admin_render('man_espacial/consultores/views', $data);
	} */
//Intento 1
	/* public function view($consultor)
	{
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin() || !$consultor || empty($consultor)) {
			redirect('auth', 'refresh');
		}
		$this->breadcrumbs->unshift(2, lang('menu_consultores_view'), 'consultores/view');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
	
		// Trae de la base de datos la fila seleccionada
		$this->data['consultor'] = $this->Consultores_model->view('consultores', array('id_consultor' => $consultor))->row();
	
		if (!$this->data['consultor']) {
			$this->session->set_flashdata('message', 'Consultor no encontrado.');
			redirect('man_espacial/consultores');
		}
	
		
		$this->template->admin_render('man_espacial/consultores/view', $this->data);
	} */
	
		
}


	
