<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Finca_mapas extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('finca_mapas/finca_mapas_model');
        $this->lang->load('finca_mapas/finca_mapas');



        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('finca_mapas/menu_finca_mapas'));
        $this->data['pagetitle'] = $this->page_title->show();

      	if ($_SESSION['id_modulo'] != 'finca_mapas') {
			$_SESSION['arraywhere_finca_mapas'] 		= NULL;
			$_SESSION['arraywhere_finca_mapas_busq'] 	= NULL;
			$_SESSION['id_modulo'] = 'finca_mapas';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_finca_mapas'), 'finca_mapas/finca_mapas');
    }


	public function index()
{
    // Verificar si el usuario está logueado y es administrador
    if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
    {
        redirect('auth/login', 'refresh');
    } else {

        if ($_POST) {
            // Inicializar las variables para los filtros
            $arraywhere = array();
            $arraywherebusq = array();

            // Filtrar por los campos de la tabla según los datos recibidos por POST
            if ($_POST['id_proponente']) {
                if (is_numeric($_POST['id_proponente'])) {
                    $arraywhere['id_proponente'] = $_POST['id_proponente'];
                    $arraywherebusq['cast(id_proponente as varchar) like '] = '%'.$_POST['id_proponente'].'%';
                }
            }
            if ($_POST['des_tipo_persona']) {
                $arraywhere['des_tipo_persona'] = $_POST['des_tipo_persona'];
                $arraywherebusq['lower(des_tipo_persona) like '] = '%'.strtolower($_POST['des_tipo_persona']).'%';
            }
            if ($_POST['cedularuc']) {
                if (is_numeric($_POST['cedularuc'])) {
                    $arraywhere['cedularuc'] = $_POST['cedularuc'];
                    $arraywherebusq['cast(cedularuc as varchar) like '] = '%'.$_POST['cedularuc'].'%';
                }
            }
            if ($_POST['nombre']) {
                $arraywhere['nombre'] = $_POST['nombre'];
                $arraywherebusq['lower(nombre) like '] = '%'.strtolower($_POST['nombre']).'%';
            }
            if ($_POST['apellido']) {
                $arraywhere['apellido'] = $_POST['apellido'];
                $arraywherebusq['lower(apellido) like '] = '%'.strtolower($_POST['apellido']).'%';
            }
            if ($_POST['email']) {
                $arraywhere['email'] = $_POST['email'];
                $arraywherebusq['lower(email) like '] = '%'.strtolower($_POST['email']).'%';
            }
            if ($_POST['des_fecha_nac']) {
                $arraywhere['des_fecha_nac'] = $_POST['des_fecha_nac'];
                $arraywherebusq['lower(des_fecha_nac) like '] = '%'.strtolower($_POST['des_fecha_nac']).'%';
            }
            if ($_POST['des_sexo']) {
                $arraywhere['des_sexo'] = $_POST['des_sexo'];
                $arraywherebusq['lower(des_sexo) like '] = '%'.strtolower($_POST['des_sexo']).'%';
            }
            if ($_POST['telefono']) {
                $arraywhere['telefono'] = $_POST['telefono'];
                $arraywherebusq['lower(telefono) like '] = '%'.strtolower($_POST['telefono']).'%';
            }
            if ($_POST['direccion']) {
                $arraywhere['direccion'] = $_POST['direccion'];
                $arraywherebusq['lower(direccion) like '] = '%'.strtolower($_POST['direccion']).'%';
            }
            if ($_POST['des_tipo_empresa']) {
                $arraywhere['des_tipo_empresa'] = $_POST['des_tipo_empresa'];
                $arraywherebusq['lower(des_tipo_empresa) like '] = '%'.strtolower($_POST['des_tipo_empresa']).'%';
            }
            if ($_POST['nacionalidad']) {
                $arraywhere['nacionalidad'] = $_POST['nacionalidad'];
                $arraywherebusq['lower(nacionalidad) like '] = '%'.strtolower($_POST['nacionalidad']).'%';
            }

            // Guardar los filtros en la sesión
            $_SESSION['arraywhere_finca_mapas'] = $arraywhere;
            $_SESSION['arraywhere_finca_mapas_busq'] = $arraywherebusq;

            // Redirigir para aplicar los filtros
            redirect('finca_mapas/finca_mapas/index');
        }

        // Paginación
        $mi_paginacion = $this->ion_auth->paginacion_generica(
            12,                         // Resultados por página
            5,                          // Segmento URI a leer
            5,                          // Cantidad de enlaces
            base_url() . 'finca_mapas/finca_mapas/index/', // URL de la página paginada
            'v_finca_mapas_index',      // Nombre de la vista a consultar
            $_SESSION['arraywhere_finca_mapas_busq'] // Filtros de búsqueda
        );

        $this->data['pagination'] = $mi_paginacion['pagination'];

        // Consultar los registros de acuerdo a los filtros y la paginación
        $this->data['finca_mapas'] = $this->ion_auth_model->segmentador_paginas(
            $mi_paginacion['per_page'],  // Resultados por página
            5,                            // Segmento URI a leer
            'v_finca_mapas_index',        // Nombre de la tabla a consultar
            $_SESSION['arraywhere_finca_mapas_busq'] // Filtros
        )->result();

        // Mensajes de validación o errores
        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

        // Breadcrumbs
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        // Cargar la vista con los datos
        $this->template->admin_render('finca_mapas/index', $this->data);
    }
}



}