<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Documentos extends CI_Controller {

    public function descargarArchivo($id_archivo) {
        $this->load->database(); // Cargar la base de datos

        // Buscar el archivo en la base de datos
        $query = $this->db->get_where('ema.tumba', array('id_archivo' => $id_archivo));
        $archivo = $query->row();

        if (!$archivo) {
            show_404();
        }

        // Obtener la ruta completa del archivo en tu PC
        $ruta_archivo = $archivo->url;

        // Verificar si el archivo existe
        if (!file_exists($ruta_archivo)) {
            show_error('El archivo no existe en el servidor.', 404);
        }

        // Forzar la descarga del archivo
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($ruta_archivo) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($ruta_archivo));
        
        // Leer el archivo y enviarlo al navegador
        readfile($ruta_archivo);
        exit;
    }
}