<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Barloc extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Barloc_model');
        $this->load->library('pagination');
        $this->load->library('form_validation');
    }

    public function index() {
        $filters = $this->input->get();
        if (isset($filters['per_page'])) {
            unset($filters['per_page']);
        }

        $config['base_url'] = site_url('barloc/index') . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Barloc_model->count_barlocs($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }

        $data['barlocs'] = $this->Barloc_model->get_barlocs($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Listado de Barrios y Localidades';

        $this->template->admin_render('barloc/index', array_merge($data, $this->data));
    }

    public function create() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('bar_loc', 'Código de Barrio', 'required');
            $this->form_validation->set_rules('barlo_desc', 'Nombre del Barrio', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['pagetitle'] = 'Crear Barrio/Localidad';
                $this->template->admin_render('barloc/create', array_merge($data, $this->data));
            } else {
                $data_insert = [
                    'dpto' => $this->input->post('dpto'),
                    'distrito' => $this->input->post('distrito'),
                    'dpto_desc' => $this->input->post('dpto_desc'),
                    'dist_desc' => $this->input->post('dist_desc'),
                    'bar_loc' => $this->input->post('bar_loc'),
                    'barlo_desc' => $this->input->post('barlo_desc'),
                    'cant_viv' => $this->input->post('cant_viv'),
                    'codigo' => $this->input->post('codigo'),
                    'objectid' => $this->input->post('objectid'),
                ];

                if ($this->Barloc_model->create_barloc($data_insert)) {
                    $this->session->set_flashdata('message', 'Barrio/Localidad creado exitosamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al crear el Barrio/Localidad.');
                }
                redirect('barloc');
            }
        } else {
            $data['pagetitle'] = 'Crear Barrio/Localidad';
            $this->template->admin_render('barloc/create', array_merge($data, $this->data));
        }
    }

    public function edit($id) {
        $barloc = $this->Barloc_model->get_barloc_by_id($id);
        if (!$barloc) {
            show_404();
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('bar_loc', 'Código de Barrio', 'required');
            $this->form_validation->set_rules('barlo_desc', 'Nombre del Barrio', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['barloc'] = $barloc;
                $data['pagetitle'] = 'Editar Barrio/Localidad';
                $this->template->admin_render('barloc/edit', array_merge($data, $this->data));
            } else {
                $data_update = [
                    'dpto' => $this->input->post('dpto'),
                    'distrito' => $this->input->post('distrito'),
                    'dpto_desc' => $this->input->post('dpto_desc'),
                    'dist_desc' => $this->input->post('dist_desc'),
                    'bar_loc' => $this->input->post('bar_loc'),
                    'barlo_desc' => $this->input->post('barlo_desc'),
                    'cant_viv' => $this->input->post('cant_viv'),
                    'codigo' => $this->input->post('codigo'),
                    'objectid' => $this->input->post('objectid'),
                ];

                if ($this->Barloc_model->update_barloc($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Barrio/Localidad actualizado correctamente.');
                    redirect('barloc');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar el Barrio/Localidad.');
                    redirect('barloc/edit/' . $id);
                }
            }
        } else {
            $data['barloc'] = $barloc;
            $data['pagetitle'] = 'Editar Barrio/Localidad';
            $this->template->admin_render('barloc/edit', array_merge($data, $this->data));
        }
    }
}
?>
